---
title: Reading accounts
---

*Reading accounts, both public and corporate is all too often seen as something best left to specialists and accountants. But with a few key ideas and some terms explained you will find that accounts are really quite readable and a great source of news.*

This guide aims to show you how to read accounts. This advice should be taken with an exploratory attitude because there are no universal standards for presenting accounts - although you would think there should be given the number of accounting standards and regulators.

Ultimately accounts are a statement for a company’s or public body’s shareholders (yes, public bodies have shareholders - they are the taxpayers) and so putting accounts together is a mixture of sticking to accounting guidance and trying to be clear for the particular investors.

We will outline common patterns that you will see in accounts over and over, no matter what type of organisation you are interested in or where in the world they are based. It’s these features that form the headings of this resource.

## 3 Statements
To fully describe the financial health of an organisation there are usually three financial statements and a document full of description and footnotes to contextualise them.

The three statements are:

### cash flow statement
For the year it shows money the organisation received and spent through particular activities. Usually it starts with money coming into the organisation followed by money leaving the organisation and ends with a total where spending is deducted from income to give a figure that represents the balance of money gained or needed. Often there are cash flow statements for different aspects or activities in the organisation. For example there may be a cash flow for profit making activities and another for costs of keeping the organisation ticking over.
<div class="well" 'markdown="1"'>
Important note: An organisation’s overall profit is not calculated from cash flows so it’s incorrect to refer to the final total of the cash flow statement as profit. It’s also incorrect to take the positive figures from the cash flow and sum them to form a profit figure. The reason that this is incorrect is because the cash flow statements don’t take into account subtleties of the organisation’s delivery of goods and services in the timeframe of the financial year.  For example say you have a company that buys sofas from a manufacturer to sell on to customers. The profit making cash flow statement will show the sales figures and the cost of buying the sofas from the manufacturer. But there are some customers who buy on credit and don’t pay for two or three years and even though a customer may have agreed to buy a sofa it may not have been delivered to them. So the profit in this situation is calculated as the costs for the sofas actually delivered to customers and the amount customers actually paid in that financial year.
</div>

### the profit and loss

*This is where subtlety of costs and timing is considered...*

Gives the overall money earned or loss suffered by an organisation over the year.

### the balance sheet

Shows the investors the assets and debts held by the organisation at the end of the year. The question is: *is the organisation (or your local council) solvent?* This means that at this point in time if the whole operation was closed down could the stuff owned be used to pay off debts and how much would be left over for the shareholders, or how much would the shareholders owe, if this was to happen. Assets include everything of any value such as cash owed, cash currently held within the organisation and an estimate of the worth of items owned.

**Now a really neat part about accounts is that these three statements are related.**

## Relationships between statements
The three statements all show something different about the financial health of the organisation, but in themselves they are limited in what they can tell us. However, in combination the financial statements can start to answer questions like:

* **How long are products held, on average, before they are sold?** This is found by taking the cost of goods purchased from the income statement and the inventory assets from the balance sheet. The cost of goods purchased is the cost of all products sold to customers in the financial year. The inventory assets is the cost of the stock of products at hand, ready to be sold, at the end of the year. The average time products are stored is given by dividing the cost of goods purchased into the inventory of assets at year end then multiply the whole thing by 52 (the number of weeks in a year). The result is the number of weeks a product is stored on average. When reporting this figure it's good to take into account the accounting problems for the cost of goods sold expense and the cost of inventory. For example finding out how has depreciation of goods been taken into account can help explain the figures so check the footnotes of the financial statements for details.
* **How long, on average, does it take for a customer to pay for their purchase?** Take the inventory asset account again and the accounts payable liability, both in the balance sheet. The accounts payable liability is a short term non-interest-bearing liability arising from customers buying on credit. It is significant because the period where the goods have been purchased but no money is exchanged is financed from debt and stockholders equity. The time is calculated by dividing the accounts payable into the inventory and multiplying that by the length of time products are held (calculated above). The result is the time in weeks that it takes, on average, for a customer to pay after they have bought the product.

*This is just a quick introduction to some of the questions it is possible to answer using financial statements. Now see which ones of these you can find for your region.Recommended further reading is [How to read a financial report](http://books.google.co.uk/books/about/How_to_Read_a_Financial_Report.html?id=Xzd3-NojmkgC) by John A. Tracy.*
