---
title: Follow the money
---

Follow the money - A guide for journalists
------------------------------------------

Welcome to the OpenSpending guide for journalists who want to investigate money flows.

History is littered with awards and accolades for those tenacious journalists who have dutifully discovered money that was spent on something it shouldn't have been. Evidence of spending is often the ultimate proof of wrongdoing. These stories have ranged from [presidential campaigns spending money on surveillance](http://en.wikipedia.org/wiki/Watergate_scandal) to [Members of Parliament dipping into the public purse for their own benefit](http://en.wikipedia.org/wiki/United_Kingdom_parliamentary_expenses_scandal), with many variations in between.

### Spending data ###

From the point at which funds come into the government's possession to when they are spent, this money takes a journey. A journey of the kind this kind requires a guide book, and that's exactly what the Open Spending project aims to provide in the following weeks -- a series of guides for smart journalists who haven't yet had the stomach for all those government funds, policies, and that strange financial language, but do have an appetite for a good story.

Here are the guides we'll publish in the coming weeks:

- [A guide to tax avoidance and evasion](resources/tax-avoidance-evasion/) with a full set of choices of stories from shadow markets in Africa to big companies setting up overseas shell companies;
- [A guide to reading accounts both public and business](resources/reading-accounts/)
- The decisions for how to allocate public funds to different projects are often completely open. We provide a list of the allocation formulas and suggest what it would be sensible to correlate the allocation of funds with;
- A guide to the many ways of grouping spending in the U.K. and beyond to help you find what you're looking for;
- A guide to tax models. The U.K. uses a model called the General Computation Model -- we look at it in detail through contact with researchers involved;
- A guide to spending transactions in the U.K. and beyond;
- A guide to outsourcing services and how to judge if they are good value for money.

We'll let you know on the OpenSpending mailing list when new guides are published.
