---
title: Final Observations and Review
---


## Final Observations and Review


While this report demonstrates possible ways in which technology can contribute to fiscal transparency it should also be clear that technology is not a magic potion that will automatically resolve all barriers to fiscal transparency. 


The authors of this report were tasked with highlighting ‘cutting edge’ technology for fiscal transparency. While we have attempted to do so and to show some of the very best and most sophisticated work in this sphere , we would like to emphasise that simple solutions often yield the best results. 


In delivering on fiscal transparency, a combination of online and offline, technical and non-technical approaches will be required. In some cases, technology will be neither necessary nor appropriate: e.g. in participatory budgeting it will be crucial to engage citizens offline if the process is to be effective. In other cases, prioritising ICT over offline methods can lead to exclusion for poor and marginalised groups who have little access to the internet or low literacy levels. 


Nevertheless, the examples highlighted here do show that technology can be a very effective complement to existing processes in enhancing fiscal processes and transparency. These tools can work on numerous levels simultaneously, reducing barriers to participation and reaching out to groups who would otherwise not have the chance to participate. 


We have already highlighted specific recommendations in individual sections, and here we would like to pull together some of the most important. The report demonstrates that many actors need to be involved  in order to promote fiscal transparency: 


Below are numerous recommendations related to the role of all parties including governments, civil society organisations and multi-stakeholder initiatives such as GIFT. 


### Governments: 

* Promote the use of simple, machine-readable formats which can significantly increase the usefulness of data 
* Make sure that all fiscal data is released under a proper open license (i.e. one that conforms to [the Open Definition](http://opendefinition.org/))
* Support and partner with civil society projects to assess whether existing, open-source tools will serve the purpose desired, before looking to create new ones
* Organise structured feedback mechanisms and make sure teams within governments have the resources to deal with potentially large volumes of feedback 
* Crowdsource Problem Areas: Providing mechanisms for citizens to give feedback on problems as they experience them. Once an area of concern is identified e.g a particular department is  frequently flagged up as asking for bribes when issuing licences, the government would know to investigate further.
* Make sure technology does not become a substitute for face-to-face contact. Many important parts of the PB process happen offline. Technology is a useful complement to offline channels of communication and participation, but is not a substitute.
* Examine structured data formats for drafting legislation and tabling amendments

### Technical Specialists 
 
* Look into ways to make it easier for governments to make data available from the data management systems they already work with - do they have APIs? can they easily pull out reports from their accounting system (e.g. an ‘export report for press’ option)? 

### Civil Society Organisations & Private Sector

* Re-publish data they have derived and added value to. 
* Work on capacity building and data literacy: Are all necessary skills being fostered to maintain technical solutions? For example, is an intern relied on to load new data or do all members of staff know the standards and processes required to do it? 

### Foundations & Funders

* Many of the projects highlighted in this report are one-off solutions, tailored to an individual local problem. Funders may like to review existing projects (e.g. those listed in the appendix & in the participatory budgeting software census, and on sites such as the [Civic Commons Marketplace](http://civiccommons.org/apps)), to see whether any existing open-source solutions could be adapted to serve other or more general problems, before initiating another.
* Support platforms (as well as individual instances of a piece of software) which allow solutions to be scaled, promote inter-organisational data-sharing and communities of practice. 
* Collect resources for long-term archives of data and documents relating to fiscal activities. 

### GIFT: Recap

First and foremost, we see GIFT as being in a strong position to foster technical standards and best practices regarding fiscal transparency. It should be appreciated that especially the release of data, by its nature, is generative: it is nearly impossible and undesirable to predict what people will want or be able to build when data is made both available and usable. Such outcomes should be specific to each country, addressing its political and technical landscape.

Hence, in this report, we have attempted to highlight case studies which are experimental in their nature. We hope that GIFT will be instrumental in supporting further such experimental projects and promoting discourse between governments and civil society in this area.  

#### Promote Open Data as the Raw Fuel for Technology

* Members of GIFT should themselves ensure - whether they are national governments or international organisations - that they publish their fiscal and other financial information in full and in machine-readable formats.

* Promote publication of key budget information as machine-readable data. Work with organisations such as the International Budget Partnership to include a related criterion in the Open Budget Survey. Set up online webinars / workshops showing how data is used after its publication.

* GIFT should initiate the creation of a light-weight, demand-driven standard for the release of structured expenditure information to enable its comparability between countries. 

* Work closely with the Open Government Partnership to promote release of datasets which are key to contextualising financial data, such as economic indicators or procurement data.

* Promote the release of sub-national data, perhaps via local partners, as well as national level.

#### Technology Outreach and Idea Sharing

* Promote experience sharing between governments through workshops and forums in existing social media platforms. Governments need to share the lessons learned in using technology to promote transparency, accountability and participation across different countries.

* Involve civil society actors who use data and services provided by governments, to review and share ideas about existing and planned initiatives. Such actors could form advisory-panels on particular topics e.g. company data.

* Create a well-maintained index of existing initiatives both an the demand and supply side, including methods of data release, re-use and presentation, discussion or activism enabled by such information. 

#### Technology Review

* Review existing projects and and solutions from the point of view of both governments and civil society actors.[Civic Commons Marketplace](http://civiccommons.org/apps) as well as the [appendix](http://bit.ly/TTAPF-projects), but a larger-scale, community effort will be required to keep this up to date. 

* Based on feedback from the above refine and maintain an online, collaborative catalogue of technical and policy options (perhaps as a wiki) which can guide governments about existing solutions and experiences.

#### Technology Sharing

* Promote the use of promising projects from the Technology Review stage. Liaise with funding bodies to ensure open-source solutions are available for all. 

<div class="pull-right"><a class="btn btn-default btn-mini" href="../chapter10-intro">Next &raquo;</a></div>