---
title: Introductions
---

## What Can Governments Do to Help Social Auditors?

There are considerably fewer projects in this section than in the participatory budgeting section. The reasons for this are numerous, but projects often suffer from lack of timely and granular data from governments and the feedback mechanisms to enable citizens to make their voices heard. Promoting participation in government audits should not be perceived as a threat, but rather an opportunity: auditors and civil servants cannot be everywhere, but citizens can, and can provide feedback on issues as and when they perceive them, allowing the government to hone in on problem areas when they need to. A few suggestions:

1. Collaborate: Support and partner with civil society projects which have already developed auditing tools and use the generated feedback for decision-making and public administration oversight.
2. Implement Standards: Implement accepted data standards and formats in order to ensure the financial data can be categorised and connected back to specific entities and projects.
3. Allow Anonymous Feedback: Mechanisms by which citizens can anonymously submit information regarding conflict of interests regarding MPs, allowing for the disentanglement of the politicians’ interests, where personal benefits might influence the direction of public policy and public procurement: e.g websites such as [Inspector de Intereses in Chile](http://www.inspectordeintereses.cl/), encouraging mobile feedback, or employing official hotlines such as those used by Supreme Audit Institutions (SAIs). 
4. Organise Structured Feedback Mechanisms: Beside providing the framework for auditing tools, governments should ensure that the feedback is assessed and acted upon in a structured, timely and efficient manner. This makes it clear who is responsible for assessment and responding to feedback.
5. Provide Online Training and Support: Training classes and guidance materials about the audit processes for other governments, public officials, civil society and interested citizens could be also made available online with webinars, shared presentations and open training tools.
6. Ensure Collaborative and Participatory Process: Establish spaces for cooperation between the SAIs and the civil society organisations as they have mutually complementary roles and resources (Nino 2010).
7. Crowdsource Problem Areas: Providing mechanisms for citizens to give feedback on problems as they experience them. Once an area of concern is identified e.g a particular department is  frequently flagged up as asking for bribes when issuing licences, the government would know to investigate further. 
8. Lead a Transparent Process End to End: Clear communication and documentation about how the auditing information is used and acted upon.

<div class="pull-right"><a class="btn btn-default btn-mini" href="../chapter8-intro">Next &raquo;</a></div>
