---
title: Introductions
---

## From Fractions to Millions: Challenging corruption using mobile phones




<table class="iconmatrix">
  <tr class="icons">
    <th class="inner">Fiscal Scope</th>
    <th class="inner">Project Aims</th>
    <th>Technology</th>
  </tr>
    <tr class="iconbar">
    <td class="inner">
      <img src="../images/revenue.png" class="no" title="Revenue Side" />
      <img src="../images/spending.png" class="" title="Spending Side" />
      <img src="../images/invisible_money.png" class="" title="Off-Budget" />
    </td>
    <td class="inner">
      <img src="../images/upload.png" class="" title="Publish Better Data" />
      <img src="../images/educate.png" class="" title="Educate Citizens" />
      <img src="../images/citizen.png" class="no" title="Facilitate Direct Participation"/>
      <img src="../images/decision-maker.png" class="" title="Get Feedback to Policy Makers" />
      <img src="../images/data_analysis.png" class="" title="Analyse and Understand Data" />
    </td>
    <td>
      <img src="../images/mobile.png" class="" title="Mobile Technology" />
      <img src="../images/web.png" class="no" title="Web-based Technology" />
      <img src="../images/offline.png" class="no" title="Offline and Print on Demand" />
      <img src="../images/piechart.png" class="no" title="Data Visualisation and Maps" />
      <img src="../images/standards.png" class="no" title="Formats and Standards" />
      <img src="../images/social_media.png" class="no" title="Social Media" />
      <img src="../images/radio.png" class="no" title="Radio" />
    </td>
  </tr>
  <tr>
    <th class="inner">Geographical Coverage</th>
    <td colspan="2">India</td>
  </tr>
  <tr>
    <th class="inner">Scope</th>
    <td colspan="2">Local government</td>
  </tr>
  <tr>
    <th class="inner">URL</th>
    <td colspan="2"><a href="http://bit.ly/fractions-to-millions">bit.ly/fractions-to-millions</a> (Vivek Srinivasan's article). All quotes from Vivek Srinivasan’s article.</td>
  </tr>
  <tr>
    <th class="inner">Stage</th>
    <td colspan="2">Pilot Project</td>
  </tr>
  <tr>
    <th class="inner">Users/Audiences</th>
    <td colspan="2">Rural poor and beneficiaries of local government programs</td>
  </tr>


</table>



### Background

In recent years, India has been one of the leaders in FOI legislation, where in many aspects the Right to Information Act was seen as more progressive and powerful than legislation in other [developed countries](http://www.guardian.co.uk/society/2012/apr/10/india-freedom-of-information?newsfeed=true). The possibility of digitising public finance records has lead to a significant decrease in the per unit cost of accessing information. "Mazdoor Kisan Shakti Sangathan (MKSS) and other NGOs involved in India’s right to information movement realised that merely having access to government records was not enough given the sheer complexity of the records and people’s ability to understand them."

Social audits in India typically involve comparing the official records of government projects (e.g., cash books, muster rolls, measurement books, supply lists) and validating whether these projects actually existed in reality. This information verification takes place through door-to-door surveys, where actual records are compared against the locals' testimonies - where discrepancies indicate acts of corruption. "The power of this process is evident by the fact that even though very few convictions happen on the basis of the findings of a social audit, data shows that the levels of corruption have reduced appreciably in places where audits have been organized regularly."

The method of the social audit involves accessing the official record and verifying it with the person who should have received the goods or services. Yet understanding the particularities of the project requires training and expertise, and the actual survey requires considerable time and resources to conduct. Mobile phones could be used as a technological solution to social auditing. "Through basic mobile phone SMS technology, official records on basic individual entitlements such as pensions, subsidized food grain, and maternity entitlements could be delivered to individuals via monthly text messages."

“The project has now received the commitment of officials in the states of Bihar and Andhra Pradesh in India and a team that we helped organize is just starting to build the basic technology to store and disseminate public records. We will start with select programs such as the National Rural Employment Guarantee Act in India and expand the coverage over the next few years.”

### The Role of Technology

The Indian Census showed that around 50% of Indians have mobile phones even in rural communities, whereas access to the internet is limited, which highlights the potential of using mobile technology to reach out to households without Internet access. "The main benefit of using SMS technology is that it requires very limited skill, knowledge, or effort from the user. And, it eliminates costly and time-consuming in-person surveys and audits. By using this technology, official information can be disseminated on a regular basis, unlike in the current model where social audits are done sporadically."

### Scalability:

A planned elaborate survey would compare villages where the technology has been implemented to villages where it has not in order to measure the effect of mobile technology on combating corruption. The existing legal framework and the low cost of making public finance information available mean that more citizens and other organised groups will be able to combat corruption.

“At a later stage of the project, it may be possible to add other features that will enable the victims of corruption to take action using mobile phones. For example, the SMS could include the phone number of responsible officials, or an NGO could collect the complaints and initiate action on their behalf.”

### Successes

1. Using SMS technology will facilitate more widespread and more  frequent social audits, which are instrumental in tackling corruption’
2. “[it] arms individuals with precise information – something they never had before — that officials cannot argue or ignore.”
3. The resource could be used by people with limited skills or access to the Internet

### Limitations

"Like any technology tool, this of course has its limitations. One of the critical functions of social auditing in India has been its role in mobilizing the general public. The process of gathering people together face-to-face in a public meeting creates a collective energy, which can motivate people to fight corruption."

### Issues with the Data

Much of the data is in printed format and should be digitised in order to conduct the project.

## Project Resources

Estimated project cost: 400,000 USD (including an elaborate survey to measure corruption)

<p style="text-align: right">Thanks to Vivek Srinivasan</p>

<div class="pull-right"><a class="btn btn-default btn-mini" href="../chapter7-2">Next &raquo;</a></div>
