---
title: Mobile-Enhanced Participatory Budgeting - the World Bank
---

## Mobile-Enhanced Participatory Budgeting : the World Bank

<table class="iconmatrix">
    <tr class="icons">
        <th class="inner">Fiscal Scope</th>
        <th class="inner">Project Aims</th>
        <th>Technology</th>
    </tr>
    <tr class="iconbar">
        <td class="inner">
            <img src="../images/revenue.png" class="no" title="Revenue Side" />
            <img src="../images/spending.png" class="" title="Spending Side" />
            <img src="../images/invisible_money.png" class="no" title="Off-Budget" />
        </td>
        <td class="inner">
            <img src="../images/upload.png" class="no" title="Publish Better Data" />
            <img src="../images/educate.png" class="" title="Educate Citizens" />
            <img src="../images/citizen.png" class="" title="Facilitate Direct Participation"/>
            <img src="../images/decision-maker.png" class="" title="Get Feedback to Policy Makers" />
            <img src="../images/data_analysis.png" class="" title="Analyse and Understand Data" />
        </td>
        <td>
            <img src="../images/mobile.png" class="" title="Mobile Technology" />
            <img src="../images/web.png" class="no" title="Web-based Technology" />
            <img src="../images/offline.png" class="" title="Offline and Print on Demand" />
            <img src="../images/piechart.png" class="no" title="Data Visualisation and Maps" />
            <img src="../images/standards.png" class="no" title="Formats and Standards" />
            <img src="../images/social_media.png" class="no" title="Social Media" />
            <img src="../images/radio.png" class="no" title="Radio" />
        </td>
    </tr>
    <tr>
        <th class="inner">Geographical Coverage</th>
        <td colspan="2">Democratic Republic of Congo (also been done in Dominican Republic)
Mobile Voting has also taken place without the Bank in: Ipatinga Brazil, La Plata (Argentina), Belo Horizonte (Brazil)</td>
    </tr>
	<tr>
	        <th class="inner">Scope</th>
	        <td colspan="2">Local government</td>
	</tr>
    <tr>
        <th class="inner">Users/Audiences</th>
        <td colspan="2">Individual citizens</td>
    </tr>
</tr>
<tr>
    <th class="inner">Source Document</th>
    <td colspan="2">This section contains excerpts from <a href="http://bit.ly/ITseQN">Estefan and Weber’s short article</a></td>
</tr>

</table>

### Background

After years of conflict in the Democratic Republic of Congo, many are unable to access the most basic of public services. While many citizens in the province don’t have access to water or electricity in their homes, they do have mobile phones. The World Bank Institute’s ICT4Gov program has introduced[m] mobile technology to enhance participatory budgeting processes to help local authorities decide on the allocation of available resources according to citizens’ priorities. In a community-chest style process, the local government devotes a percentage of the local investment budget to the project deemed most important by the citizens.

The World Bank played the role of facilitator in a number of spheres for the project - they tailored software, negotiated with cellphone operators and built capacity to demonstrate to local populations how the technology works. In each use-case, the Bank provided the local community with a portfolio of options that technology could offer and allowed the community to decide for themselves which options to deploy. The Bank was also instrumental in other processes such as drafting the text messages which were used to contact constituents and building capacity in understanding the budget. In the case of the Democratic Republic of Congo, the Bank played a role in bringing local governments, civil society, universities etc. together to work out how to implement these projects.

### The Role of Technology

ICT4Gov is using mobile phones for four purposes:

* To invite citizens to participate offline in participatory budgeting assemblies through geo-targeted SMS messages. These messages, reaching all the phones receiving signal from a particular tower, announce the date, time and location of the assemblies.

Besides the blanket approach, the Bank is also experimenting with manually collecting phone numbers (this was done in the Dominican Republic). When collecting numbers, it is also possible to collect basic information about the person in question, such as their gender, and the neighbourhood they live in, so that targeted messages can be sent out (e.g. low attendance rates from women can be counteracted by sending invites just to women.) So far, the Bank have sent around 2000 messages this way compared to 300,000 through the blanket approach.

*  Mobile phones were also used for voting (DRC), allowing the citizens to send a text to identify which of the priorities they would like to see addressed in their community. This is being trialled in a controlled environment at the in-person meetings. This ensures that citizens are present throughout the discussions and so are able to make informed decisions. During meetings, the participants rank their priorities on a scale of 1-4. This makes meetings more efficient as counting is done electronically and feedback can be monitored. In the Dominican Republic participants had the option to vote remotely.

* As an announcement service to communities to broadcast the the result of the vote, making the process more transparent and inclusive.

* For feedback on the projects that were chosen. Through text messages, citizens are able to offer feedback and monitor the projects.

![Perception DR](http://farm8.staticflickr.com/7245/7272472242_28b8506119.jpg)
<p>
<small>Voters in the Dominican Republic were asked how they felt about having the option to vote remotely via SMS.</small>
</p>

### Project Resources

1. Knowledge of participatory design and community operation
2. Development knowledge in mobile telephony sector
3. Outreach skills
4. Cost of SMS: In the DRC one million messages were negotiated at 10,000 USD

### Timeframe

1. Training on PB: 8 cities - 2 months
2. Development: 2 months
3. Running a session: 2-4 hours


### Scalability

There are 1500 cities around the world where participatory budgeting already takes place, and this approach could be considered as an option in them. Using mobiles could be used to encourage citizens is an approach that could be used in other contexts to promote citizen participation, not just PB.  In some countries, such as Estonia, mobile voting has already been used in municipal elections and could be extended to other contexts.

###Successes

1. When the participants were asked what motivated them to take part in the meeting, the majority of respondents mentioned that the SMS had been the strongest deciding factor.
2. Since the beginning of the program, as the Provincial government sees an increase in the capacity of local government to allocate resources, communities involved have already seen an increase in transfer of funds from the Provincial to the local level.
3. The preliminary results of an external evaluation suggest that an increase of tax collection at the local level has been associated with the implementation of participatory budgeting. This is based upon testimonials offered by officials and numbers collected with the municipalities. However, given the high number of potential exogenous factors that could have contributed to this result, further assessment should be done before claiming a causal relationship. For the first time, communities such as Ibanda have gone from not having any investment budget to having 40% of their budget devoted to investments. In 2011, the Ministry of the Budget started the process of institutionalisation of Participatory Budgeting in the Province.
4. The increase in the transfer of funds from the provincial to the local level has benefited communities, which now have more resources to deliver public services to the poor. For instance, the process has made it possible to begin repairing 54 classrooms and a bridge in Luhindja, to create a health centre and repair the sewage system in Bagira, and to build a water fountain as well as toilets in local markets in Ibanda.

![Find out 1](http://farm9.staticflickr.com/8164/7272472560_e4338cbdd7.jpg)
![Find out 2](http://farm9.staticflickr.com/8017/7272472430_f6ee268408.jpg)
<p>
<small>Participants in the Dominican Republic were asked how they had found out about the meeting. </small>
</p>

### Challenges

1. Collecting numbers requires a lot of resources (Dominican Republic)
2. With some bulk message providers, some messages did not deliver until many hours later, some recipients received messages in the middle of the night!
3. More work needs to be done to help people monitor the execution of the projects. People are engaged in the process and feel empowered when they vote, but there is little follow-up and people could begin to become disillusioned with the project if they do not see results.

<div class="pull-right"><a class="btn btn-default btn-mini" href="../chapter7-intro">Next &raquo;</a></div>
