---
title: Balance your City's Budget - Citizen Budget, Open North
---

## Balance your City’s Budget : Citizen Budget, Open North

<table class="iconmatrix">
    <tr class="icons">
        <th class="inner">Fiscal Scope</th>
        <th class="inner">Project Aims</th>
        <th>Technology</th>
    </tr>
    <tr class="iconbar">
        <td class="inner">
            <img src="../images/revenue.png" class="" title="Revenue Side" />
            <img src="../images/spending.png" class="" title="Spending Side" />
            <img src="../images/invisible_money.png" class="no" title="Off-Budget" />
        </td>
        <td class="inner">
            <img src="../images/upload.png" class="no" title="Publish Better Data" />
            <img src="../images/educate.png" class="no" title="Educate Citizens" />
            <img src="../images/citizen.png" class="" title="Facilitate Direct Participation"/>
            <img src="../images/decision-maker.png" class="" title="Get Feedback to Policy Makers" />
            <img src="../images/data_analysis.png" class="" title="Analyse and Understand Data" />
        </td>
        <td>
            <img src="../images/mobile.png" class="no" title="Mobile Technology" />
            <img src="../images/web.png" class="" title="Web-based Technology" />
            <img src="../images/offline.png" class="no" title="Offline and Print on Demand" />
            <img src="../images/piechart.png" class="no" title="Data Visualisation and Maps" />
            <img src="../images/standards.png" class="no" title="Formats and Standards" />
            <img src="../images/social_media.png" class="" title="Social Media" />
            <img src="../images/radio.png" class="no" title="Radio" />
        </td>
    </tr>
    <tr>
        <th class="inner">Geographical Coverage</th>
        <td colspan="2">Canada</td>
    </tr>
	<tr>
	        <th class="inner">Scope</th>
	        <td colspan="2">Local government</td>
	</tr>
	    <tr>
        <th class="inner">URL</th>
        <td colspan="2"><a href="http://citizenbudget.com/">http://citizenbudget.com/</a></td>
    </tr>
    <tr>
        <th class="inner">Users/Audiences</th>
        <td colspan="2">All levels of government</td>
    </tr>
</table>

<img alt="Citizen Budget" src="http://farm8.staticflickr.com/7229/7272472996_6013c841d1_o.png" class="screenshot" />

### Background

Citizen Budget is a project of Open North, a Canadian non-profit that creates websites to increase government transparency and promote citizen participation. Open North sells Citizen Budget to municipalities as licensed software or as a service.

Citizen Budget is an online budget simulator that focuses on a local government's controllable operating expenses. The tool challenges citizens to re-balance the budget by increasing or decreasing the amounts allocated to municipal activities, local services and revenue sources. The municipality defines the list of activities and services and their associated amounts.

Once the online consultation is over, Open North prepares a report for policymakers at the municipality,  to allow them to better incorporate citizens' priorities in their budgetary decisions. This report evaluates how representative the participants are of the population, analyzes the data, and identifies trends, which it reinforces with data visualizations.
The goal is to consult citizens on their budget priorities, while educating them about the local budget and raising awareness of the difficult choices and trade-offs in balancing a budget. Other potential customers include police and fire authorities, school districts and labor unions.

Citizen Budget's first client was the borough of Plateau Mont-Royal in the City of Montreal, regarding their 2012 operating budget. Open North is now looking for municipalities who would like to consult citizens on their 2013 operating budget. This project can be tailored to allow citizens to submit input on printed forms or using their mobile devices.

### How it works

Unlike many of the applications in the census, which asked users to vote on abstract priorities e.g. increase health spending by X million (voting in amounts which, without specialist knowledge, do not mean an awful lot to the average citizen who (generally relate more easily to e.g. the scale of their household budget), citizen budget allows users to vote on concrete and tangible outcomes, which are aligned with decisions that councillors might have to make themselves (build more of these, agree to close libraries on Sundays to save money.) Citizens have to produce a balanced budget, so are forced to trade-off priorities against one-another. The voting system is incredibly simple and allows the user to understand the trade-offs and impacts of their given choice in context.

### How long did the project take to implement?

The project is constantly improving and so work is ongoing. The current iteration of the project took 10 days for the technical implementation, with another 10 days for data collection, meetings with government, etc.

### Successes

Online applications can reach a larger and more diverse group of citizens and can offer more personalized information than traditional offline methods. Unlike council meetings or face-to-face consultations, citizens can participate online anytime, from anywhere, using their favourite Internet device.

They can take the time to express themselves carefully without having to wait to be given the floor. In short, online solutions reduce many barriers to participation.

This project has so far been run in one city district, the borough of Plateau Mont-Royal in the City of Montreal. Out of an adult population of 89,000, 3,160 visited the budget simulator and 363 submitted balanced budgets that expressed their budget priorities. The local government used the major trends in residents' budget priorities to inform their budget decisions - principally, to allocate more money to make the borough greener and cleaner.

Residents expressed their appreciation for the consultation and gained a greater appreciation for the difficult choices and trade-offs that elected officials face when balancing a budget.

Many citizens from outside the borough expressed interest in having a similar initiative in their territory.

### Challenges

1. The project did not have government staff dedicated to the project's promotion, and so did not reach the greatest number of participants.
2. The government did not effectively communicate to citizens the way in which it used the input from the online consultation.
3. The major challenge is for the government to determine the actual cost of individual activities and services. Budgets do not tend to be organized per activity, and so a fair bit of work has to go into coming up with these numbers.

#### Do users require any special skills to use the platform?
The project requires citizens to have a basic level of competency in the following: Internet use, reading skills, budget literacy, and familiarity with municipal activities and local services.

#### What skills are required to implement the project?

The project requires a web developer and a designer to create the application and a statistician/analyst to prepare the report on the consultation for the government. Additional non-technical staff are needed to educate and interact with governments, to manage the other team members, to plan the promotion of the consultation, etc.

### Other comments

1. Consultations cost money. With many local governments facing significant budget constraints, many find it difficult to justify (to themselves and to residents) the cost of a consultation.

2. Politics. Some governments may worry about the consultation being a negative experience, especially if residents are already not showing support. They may worry that residents will support a policy or initiative that goes against the government’s promises, platform or beliefs. Finally, a particular consultation method may be seen as a vestige of a previous government, and therefore something to get rid of.

3. Many local governments would want an offline consultation in addition to any online consultation, e.g. to get input from harder-to-reach demographics. Even if Open North, as a service provider, makes the online consultation as easy-to-run as possible, some local governments will not use it due to the planning, preparation, operating and follow-up costs of an offline, face-to-face consultation.

4. It is difficult to get a local government to run a consultation year after year. Most will perform it as a one-off initiative. It is considered more in terms of its publicity, marketing or communications value, rather than its democratic value.

Such systems have the potential to better inform and educate citizens about decisions and processes. By sharing decisions with citizens, they can become more efficient and effective in the delivery of services. Governments provide much of the information for these initiatives. However, without government buy-in, these initiatives would not have the power to effect change.

<p style="text-align: right">Thanks to James McKinney (Open North)</p>

<div class="pull-right"><a class="btn btn-default btn-mini" href="../chapter6-6">Next &raquo;</a></div>
