---
title: Mini atlases for participatory budgeting - Solo Kota Kita (Solo, Our City)
---

## Mini atlases for participatory budgeting: Solo Kota Kita (English: Solo, Our City)

<table class="iconmatrix">
    <tr class="icons">
        <th class="inner">Fiscal Scope</th>
        <th class="inner">Project Aims</th>
        <th>Technology</th>
    </tr>
    <tr class="iconbar">
        <td class="inner">
            <img src="../images/revenue.png" class="" title="Revenue Side" />
            <img src="../images/spending.png" class="" title="Spending Side" />
            <img src="../images/invisible_money.png" class="no" title="Off-Budget" />
        </td>
        <td class="inner">
            <img src="../images/upload.png" class="" title="Publish Better Data" />
            <img src="../images/educate.png" class="" title="Educate Citizens" />
            <img src="../images/citizen.png" class="" title="Facilitate Direct Participation"/>
            <img src="../images/decision-maker.png" class="no" title="Get Feedback to Policy Makers" />
            <img src="../images/data_analysis.png" class="" title="Analyse and Understand Data" />
        </td>
        <td>
            <img src="../images/mobile.png" class="" title="Mobile Technology" />
            <img src="../images/web.png" class="" title="Web-based Technology" />
            <img src="../images/offline.png" class="" title="Offline and Print on Demand" />
            <img src="../images/piechart.png" class="no" title="Data Visualisation and Maps" />
            <img src="../images/standards.png" class="no" title="Formats and Standards" />
            <img src="../images/social_media.png" class="no" title="Social Media" />
            <img src="../images/radio.png" class="no" title="Radio" />
        </td>
    </tr>
    <tr>
        <th class="inner">Geographical Coverage</th>
        <td colspan="2">Indonesia</td>
    </tr>
	<tr>
	        <th class="inner">Scope</th>
	        <td colspan="2">Local government</td>
	</tr>
	    <tr>
        <th class="inner">URL</th>
        <td colspan="2"><a href="<http://solokotakita.org/en/"><http://solokotakita.org/en/</a></td>
    </tr>
    <tr>
        <th class="inner">Users/Audiences</th>
        <td colspan="2">Donors, recipient country governments, citizens, NGOs</td>
    </tr>
</table>

![SKK Image](http://farm8.staticflickr.com/7231/7295628522_e2dce3fc25_o.png)

### Background

In 2001, Indonesia underwent ambitious decentralization programs. The "big bang" reforms devolved political, administrative and economic power to smaller administrative units, and local actors took over management of municipal infrastructure and systems. Against this backdrop, the national as well as local governments developed and supported new planning processes that sought to increase community participation in government decision-making.

Participatory budgeting (known in Indonesia as Musrenbang) was piloted by a group of NGOs in Solo for the first time in 2001. In 2005 the national government mandated that every region and city in Indonesia implement an annual Musrenbang process. As part of the Musrenbang process, residents in a city or region meet to prioritise and propose short-term improvements they'd like local government to implement in their neighbourhoods.

While participatory processes such as Musrenbang are in place, in many cases local authorities and communities lack capacity or tools to maximize the collaborative decision-making opportunities these processes offer. For example, priorities set during Musrenbang meetings don't always correspond to the most urgent requirements of a given neighbourhood. SKK’s first project sought to tackle this issue in Solo by increasing awareness of urban issues to strengthen residents’ voices and their capacity to prioritise community issues during the Musrenbang process.

### Project Description

The tool, ‘the Mini-Atlas’, presents a map and thematic information about each neighbourhood in Solo. Each atlas includes a map of community facilities (responding to local feedback that often the participatory budgeting meetings happen without a map of the neighbourhood) and thematic data regarding education, water, sanitation, housing, poverty, and health, highlighting key assets and issues for residents to discuss.

After completing the mini-atlases, SKK, in coordination with the city government and Musrenbang facilitators in each neighbourhood post large copies of the mini-atlases in neighbourhood public spaces. Residents can also print-off this information themselves and use the maps whenever they like.

Data Collection and Analysis Methodology
Solo city government had never collected the information included in the mini-atlases, let alone aggregated it through GIS and disseminating it more widely, but the administrative organisation of all cities across Indonesia, including Solo, facilitates the collection of this data.

Each neighbourhood in Indonesian cities is formed of administrative units called RTs (roughly equivalent to a US Census Block). A “block captain” keeps track of how many people live on the block, how many poor families, etc. SKK put together a team of community facilitators that liaised with the 2,700 “block captains” in Solo to collect the information to populate the mini atlases. As such, each mini-atlas provides a highly detailed profile of each neighbourhood.

### Resources

*Data collection*: 6 months in total.

*Working with data*: GIS mapping and analysis, design of the mini-atlases, website with searchable information from the atlases. (local GIS consultants and a California-based firm to produce SKK website) - 6 months total over a six-month period.

Note that following the data collection, SKK found differences in the collected data compared to official statistics e.g. the official population estimate is lower than SKK’s count. Rather than SKK having over-estimated the population, it seems more likely that some people were not counted in the official census, perhaps due to dissemination problems, illiteracy, or inadequate follow-up procedures.  While such data discrepancies exist, they are generally not critical.

### Scalability

The experience with the data collection emphasises that this methodology is replicable. As discussed in ‘Follow up projects’ SKK will attempt to replicate the initiative in Solo and Makassar, adding an innovative SMS data collection approach.

### On the Ground Implementation: Using the Data

SKK trained all Solo Musrenbang facilitators in the use of the mini-atlas during the 2010-2011 Musrenbang process. Further, SKK staff collaborated closely with Musrenbang facilitators in 10 neighbourhoods to encourage and observe the utilization of the tool during that Musrenbang cycle.

During the 2011-2012 Musrenbang cycle, SKK staff conducted refresher training for Musrenbang facilitators. Unlike the previous rounds, in four of the 10 neighbourhoods, SKK staff worked with neighbourhood leaders and facilitators to develop a second-generation mini atlas. The latter, known as MA+, sought to amend/ augment the original neighbourhood mini atlas with information that community members noted would enhance the effectiveness of the tool. For example, in one neighbourhood, feedback included adding information about small businesses within the mini atlas.

### Follow-up Projects

SKK has begun a Musrenbang budget analysis initiative with the aim of increasing transparency and developing new planning tools related to the outputs of the Musrenbang process in Solo. To achieve this aim, SKK is reviewing and comparing the lists of proposals made at the RT levels to the respective final city budgets, to determine which projects proposed through Musrenbang were selected and implemented. Ultimately, this information could be utilised to develop maps that visually highlight what type of projects were proposed and where, as well as which were implemented in previous years.

Additionally, with funding from the Ford Foundation, SKK will begin collecting RT-level information from each neighbourhood utilising an innovative SMS data-capturing methodology. Specifically, instead of community facilitators and “block captains” filling out paper forms to aggregate data, SKK will pilot an approach by which the data collection can be conducted using an SMS based cell-phone application. In addition to conducting this work in Solo, SKK will also  implement the project in the city of Makassar.

### Successes

1. In some neighbourhoods the mini atlases served as a catalyst for communities to enhance their discussion of issues and prioritisation of Musrenbang funding requests.
2. The Solo government officially mandated and included future funding for the printing and use of the mini atlases as part of future Musrenbang cycles.
3. As part of a city-sponsored design competition, ‘Solo Eco Cultural City’, to create solutions for a sustainable city, student participants downloaded and used the mini atlases to do their planning.
4. Other city and NGO initiatives are utilising information from the mini atlas to help inform their work. For example, a current City-NGO initiative which will conduct a poverty assessment in a number of Solo neighbourhoods is utilising the mini atlases as an information baseline.
5. A critical characteristic of the mini atlases was providing clean, universally recognised graphics that could be understood by community members.
6. The mini-atlas is a tool with relevance beyond Musrenbang. Musrenbang is part of a continuum of planning activities in neighbourhoods that includes RPJMK planning, which is medium-term poverty alleviation planning; PNPM, a World Bank upgrading program, and others.

### Challenges

1. The willingness and ability of neighbourhood facilitators to effectively utilise the mini-atlases has a significant impact on whether they are used or serve their purpose. Some neighbourhoods resisted the use of new tools. In other neighbourhoods, facilitators were not as engaged as they should be with the Musrenbang process (for example, some do not show up to community meetings as they should). SKK is currently working on a set of recommendations to tackle this.
2. Feedback during RT and RW (groups of RTs) meetings suggests that in many communities the data presented in the mini atlases is too high level. In other words, the mini atlases do not provide sufficient nuance regarding the blocks since they are presented at the neighbourhood level. This issue was a key catalyst in SKKs 2011-2012 effort to develop a second-generation mini atlas.
3. Given the 18-month Musrenbang budget cycle and a lack of clarity regarding the projects selected and implemented during previous Musrenbang processes, there is a tendency for communities to recycle project proposals yearly. SKK’s ongoing Musrenbang budget analysis project seeks to shine light on this issue.

### Project Resources

Key Actors: A project director, 2 community facilitators, an urban designer, a GIS expert, a website developer,10 community facilitators to communicate with and collect data from RTs, student volunteers (local universities) as map makers/drafters.

Additionally, it is important to note that the project had the support of the Solo mayor. The government worked with SKK to engage the neighbourhood heads to support data collection.

<p style="text-align: right">Thanks to Hector Salazar Salame and Michael Haggerty (SKK)</p>

<div class="pull-right"><a class="btn btn-default btn-mini" href="../chapter6-5">Next &raquo;</a></div>
