---
title: Deciding where the money goes - Participatory Budgeting
---

## Deciding where the money goes: Participatory Budgeting

### e-participatory budgeting

Participatory budgeting (PB), put simply, gives citizens direct input into how government money is spent, for example via budget consultations or in-person meetings. PB occurs in over 1500 cities over the world, and there is a [Google map](http://bit.ly/IS8Skf), which shows (marked with red pointers) locations which have favoured a technical solution, referred to here as ‘e-PB’.

For government officials interested in e-PB, the Participatory Budgeting Unit have produced a useful paper including a list of considerations which governments [should take into account](http://bit.ly/PB-role_of_technology).
The collective knowledge of the [Participatory Budgeting Google Group](http://groups.google.com/group/participatorybudgeting?pli=1_) is another useful resource for anyone seeking advice on implementing PB, using technical methods or otherwise. Many members of the group develop e-PB systems, and the group has built a [census](http://bit.ly/PB-software-census) of existing technical solutions.

The census shows that there are a large number of competing software solutions (both proprietary and open-source) but no real consensus on a particular approach to implementation. When it comes to building a software tool for a process as complex as participatory budgeting, perhaps one size does not fit all. In what follows, we have sought to determine activities in the PB process for which the projects in the census may be able to provide solutions.

At the end of this section, we present three in-depth case studies of different technical solutions.

### PB Activities targeted by technology

The following bullet points highlight key activities in the PB cycle and outcomes which some of the case studies highlighted in this section seek to target:

1. **Outreach**: Encouraging the ‘hard to reach’ to participate, typically the disenfranchised, the busy and the apathetic. Targeted outreach is also important, being able to contact people who will be most affected by proposed policies or projects.
2. **Following projects and collecting feedback**: The ‘hard to reach’ could equally be defined as finance officers and decision makers in government who have little in-person contact with their citizens. Technology can offer them a way to connect with their citizens.
3. **Publicising progress**: To demonstrate clearly what effects the participatory voting system is having, e.g. which projects were funded in previous years by using this system, how many participants etc.
4. **Aiding deliberation and facilitating debate**: Structuring arguments and collecting ideas e.g. for potential new projects.
5. **Remote participation**: Some people who are unable or unwilling to participate in person may be willing to do so online or via mobile.
6. **Reducing costs**: Commonly incurred costs during a PB process are outreach, planning, running the meetings and collecting the feedback.
7. **Reducing workload**: Running the process can put a lot of stress on staff particularly around planning in the run up to and follow-up from meetings. In offline participatory budgeting, substantial amounts of outreach work and tasks such as translation for minority groups are often taken on by volunteers.
8. **Raising additional funds**: Governments are frequently strapped for the money to implement projects. If additional funds are required to get a project off the ground, some projects highlighted in this section turn to  citizens or businesses to make in-kind or cash contributions to get the project off the ground.
9. **Increasing budget literacy**: Simulators allow participants to explore how certain spending/revenue choices impact the budget and gain an appreciation for how much state projects cost. This allows citizens to explore trade-offs between different options.

### Possible solutions

This section highlights existing initiatives which take advantage of the opportunities highlighted in the section ‘PB Activities targeted by technology’ .


#### Outreach

**Using technology to invite people to take part in offline voting**

*  e.g. geo-targeted SMS (See the Mobile-Enhanced PB case study, where, when asked how they had heard about the participatory budgeting meeting, over 50% of respondents cited the SMS invites they received as the reason),
*  automatic phone-calls where the voice of the mayor encourages people to come out to vote (good for illiterate populations, and hearing the voice of an authority figure may help convince people to participate),

**Combining online and offline approaches**

1. e.g. putting e-voting stations outside churches and other places where large numbers of people congregate.


#### Following projects and providing feedback

<img alt="Gol App" src="http://farm8.staticflickr.com/7100/7272472352_2724487244_o.png" class="screenshot inline-image" />

**‘Problem-solving approaches’**

*  e.g. [Fix My Street](http://www.fixmystreet.com/) / [SeeClickFix](http://makehoustongreat.com/seeclickfix/) or Lichfield council’s [Fix My Tweet](http://www.fixmytweet.com/) - where citizens identify tangible problems e.g. potholes on the street and submit a request via their mobile / via Twitter to their local authority to have them fixed.

**Following the progress of projects**

*  e.g. [The Gol Mobile App](http://itunes.apple.com/us/app/porto-alegre/id479880903?mt=8) for Porto Allegre is a good example of an application which allows users to track the progress of a request and submit progress reports via their smartphone.

#### Publicising progress

*  Publicising information on the outcomes of previous rounds of participatory budgeting and what has become of the projects.
*  [Bürgerhaushalt Lichtenberg](http://bit.ly/yE7xGa) publishes updates on projects suggested by citizens, including implementation stage, relevant authorities overseeing the work and other comments regarding the projects.

#### Deliberation

**Online deliberation:**

*  Many projects allow citizens to submit their own project ideas. e.g.: The UK’s YourLocalBudget project, [‘Budget Ballot’](http://budgetballot.com/)
*  Allowing direct feedback into laws already in draft stages. e.g. [Adhocracy](https://adhocracy.de/), which allows users to cut, add to, reword and restructure proposed bills
*  Structuring argument. Example: The [MIT deliberatorium](http://cci.mit.edu/klein/deliberatorium.html), which requires users to ‘map’ their argument e.g. pro-contra a point made by another, follow-on questions, ideas for solutions to previously raised problems.

**Offline deliberation, aided by tools.**

*  Example: ‘America Speaks 21st century town-meetings’ are in-person meetings which use computers on every table to serve as “electronic flipcharts” to record general table agreements; table agreements are instantly transmitted to a “Theme Team”, which reads who read all the entries to identify the strongest themes. These overarching themes are displayed and quickly presented to all the participants; individuals use their individual voting keypads to vote on what they believe are the most important priorities.

#### Remote participation:

*  online voting and surveys (numerous examples in census. See also the Citizen Budget case study).

#### Cost reduction:

*  Outreach e.g. advertising meetings on social media
*  Email - usually cheaper than paper outreach.
*  Even SMS can be a relatively cost effective option. In the Dominican Republic, the World Bank negotiated with phone companies a rate of around $0.01 per message. A single callout on radio cost around $200 to advertise the meeting. Nonetheless, text messages appeared to be a more effective option in terms of the number of people motivated to join the meeting (see statistics in the Mobile-Enhance Participatory Budgeting case study).

#### Reduction of workload

* Systems which help to manage and direct volunteer efforts: e.g. collaborative editors, (Google Docs), Microtask management (Tasket), Translation ([Amara](http://www.universalsubtitles.org/en/), [Transifex](https://www.transifex.net/)).

#### Raising additional funds

* Very few [Kickstarter](http://www.kickstarter.com/)/[Pledgebank](http://www.pledgebank.com/)- style applications exist for publicly funded projects, however this approach has been incredibly successful in crowdsourcing support for non-governmental projects via the internet. One of the few attempts to do something similar is: [Leih Deiner Stadt Geld](https://www.leihdeinerstadtgeld.de/) in Germany, this works by encouraging people to invest in their city.

#### Increasing Budget Literacy

* Budget simulators: The Estonian site [Meieraha.eu](http://meieraha.eu/) allows people to visualise and explore the effect of different revenue and expenditure policies e.g. raising taxes.
* Personal Impact Calculators: One aspect which very few of the budget simulators dealt with was personal impact, where users are shown what the impact on them personally would be, e.g the effect that increasing spending above budget levels would have on the amount of tax that they as an individual would pay. Large numbers can be disorienting for the average citizen who may find it difficult to relate the numbers to more familiar measurements such as household budgets and their daily salary. An example attempting to solve this problem is [Budget Allocator](http://demo.budgetallocator.com/), which explains to users the impact of their choices: “Although you have balanced your budget, based on your current selections, we may still have to increase rates by 6.4%. Typically a 1% rates increase equates to 12 cents a week.”
* Research is currently in progress at the Ash Centre in Harvard into forcing people to watch an explanatory video before voting. This will obviously not work in all situations (e.g. places with bandwidth issues), however it does have the benefit over text that it ensures that information cannot be ‘skipped’.

### Concerns about using technology in PB

The concerns below were voiced about using technology in PB by those both inside and outside governments:

* “Possibilities for gaming the system” (e.g. with bad voting systems).
*  ‘Herding effects’ from special interest groups, which could be difficult to monitor if participation is remote.
*  Using technology as the ‘easy option’ and not dedicating enough time to face-to-face interaction.
* For both citizens and governments: Not having the right skills to be able to deal with such a system.
* Creating additional work for government officials by allowing torrents of unstructured, unmoderated and often duplicate comments to flood in, all expecting answers.
* Information cascades in online voting systems: Due to the volume of responses, participants often do not have time to review all of the proposed solutions, so if only the most recent comments and suggestions appear at the top, or only top ranked, they may gravitate towards selecting these.
* Who participates? Particularly, where remote participation is concerned: Ensuring that only relevant constituents are participating.
* Finding the right balance between a simple and usable application and an oversimplified solution.

### e-PB: What can policymakers do to help projects such as these succeed?

This section has dealt mainly with tools for direct participation, as opposed to indirect participation, where citizens choose their preferred policies via the proxy of an elected representative. In the latter case, there are also ways in which governments can help to promote informed decision-making in electing their preferred candidate. For example, by releasing structured information on voting records of a given candidate.  In countries such as Kenya, where individual politicians hold sway over a large discretionary fund (Constituency Development Funds), having access to information on an individual’s previous financial behaviour can be crucial to selecting the correct representative. See [this post](http://openspending.org/blog/2012/01/30/hakuna-my-data-nbo-data-bootcamp.html) on ‘Auto-generated campaign speeches’ for one suggestion of a project to compare candidates based on their financial track-record.

Many of the projects in this section are civil society led and are listed here to provide inspiration for some of the ways in which technology may be used to promote greater citizen participation around budgeting issues. However, these efforts can only go so far without support from governments. The following section highlights a couple of ways in which governments could promote such projects as these.

#### Promoting public participation in the annual budget cycle, and in the design and delivery of public services and public investment projects

1. Publish machine-readable schedules of key events in the budget cycle e.g. publication of key documents, consultation periods etc.
2. Make sure teams within governments have the resources to deal with potentially large volumes of feedback in order not to disappoint those in their constituencies by not being able to take suggestions into account.
3. Make sure technology does not become a substitute for face-to-face contact. Many important parts of the PB process happen offline. Technology is a useful complement to offline channels of communication and participation, but is not a substitute.

#### Promoting participation around legislation concerning budgeting issues

1. [Examine structured data formats for drafting legislation and tabling amendments](http://www.publicwhip.org.uk/project/liaison.php).
2. Be open and transparent about [how legislation is drafted](http://www.ictparliament.org/xmltraining_brussels2012). Progress was made recently when the European Parliament (EP) decided to [open-source At4am](http://bit.ly/KhOr13), software that helps staff at the EP write and table amendments. Such moves help those developing tools for deliberation and collaboration around ideas outside government understand workflows and adapt their tools to work with existing government workflows.
3. Note that while the European Parliament plans to release the At4am software, [it has not currently announced a plan to make the data from its own copy available](http://www.asktheeu.org/en/request/source_code_and_data_for_at4am_s_2), and doing so would represent a substantial increase in transparency around legislators’ activities.
4. Structured information on who in a department is responsible for [particular changes](http://pudo.org/2011/07/22/kleine-charta-der-beteiligten.html). It is unproductive to attempt to talk to an entire department about a proposed project or change, who are the people who can actually make a difference?

<div class="pull-right"><a class="btn btn-default btn-mini" href="../chapter6-4">Next &raquo;</a></div>

