---
title: The Media and Fiscal Data - How do we get fiscal data into the public eye?

---

## The Media and Fiscal Data: How do we get fiscal data into the public eye?

![Europe's Missing Millions from the Bureau of Investigative Journalism](http://farm9.staticflickr.com/8157/7295526880_5f5db8d268_o.png)


One of the key promises of open data is that it can be used by journalists to get a clear, evidence-based picture of government action, in particular by using fiscal information to track budgetary priorities, contractual commitments and patterns of spending. As part of the OpenSpending project, the Open Knowledge Foundation is working closely with journalists to develop tools which aim to make financial data released by governments accessible and usable in a journalistic context. We are regularly approached by journalists asking for advice on where to find information on a particular aspect of government spending. In this section, we highlight a couple of our experiences from building these tools, and document some anecdotes from other organisations who have had varying degrees of success with reaching out to the media.

As a part of this project (Spending Stories), we identified the following challenges:

1. Journalists are often not used to working with raw data, and don’t consider it a necessary foundation for their reporting. Sourcing stories from raw information is still a relatively new idea.
2. They also often do not possess the necessary literacy and technical skill to analyse the data and present their findings. This includes technical skill, but also statistical and design capacity.
3. Analyzing and understanding data is a time-intensive process, even with the necessary skills. Fitting this into a short-lived news cycle is hard, so data journalism is mostly used in longer-term, investigative projects. This is reflected in a statement by the Budapest Institute in Hungary: “One of the conclusions of the workshop with journalists and the following consultations with media representatives was that our initial idea [of building a tool that would be useful for journalists] turns to be a false hope. [...] We have learned that the Hungarian media is prone to get ready-made analytics and reports rather than to perform investigative projects on its own.”
4. The data released by governments is often incomplete or not up-to-date, making it harder to argue a story based on the available information. Very often, released databases cannot be used for investigative purposes without the addition of FOI-requested, more specific pieces of information.  In an article in the [Guardian Datablog](http://www.guardian.co.uk/society/datablog/2011/mar/18/public-finance-data-store) which followed the release of the UK Local Council spending data, Lisa Evans explained why, despite the impressive show of proactive transparency from the UK government, many barriers still prevent journalists from using the data to hold the government to account. The issues she identified include concerns about the completeness of the data; for example, the inability to see money which is allocated in [Private Finance Initiatives](http://www.guardian.co.uk/politics/pfi) (Public-Private Partnerships).

A couple of observations on Spending Stories as a tool:

1. We decided early on that we would not confine ourselves to providing journalists with technological solutions, but would also offer training sessions in the use of data and relevant tools. Feedback from participants indicates that this method training was useful. It has also helped us to gauge the level of skill which we can expect users of our technological solutions to have.
2. We started under the assumption that our tool would be aimed primarily at journalists, but have found it is more commonly used by advocacy groups, who have more time to dedicate to research. These advocacy groups then contact journalists with the story in order to gain publicity for the topic once an outline of the story has been researched and the bulk of the data work has been completed.

When we explored the specific information- and tool-requirements for journalists who wanted to work with spending data, the following needs were recurrent:

1. Heuristics for story-finding: This could include the automated calculation of statistical measures such as percentiles, scatterplots, standard deviations - but also very specific analysis such as measuring the size of firms in relation to the industry (Herfindahl- Hirschman Index).
2. Time-series visualisations of total spend to date by quarter: This would allow journalists to detect problematic practices such as those highlighted by Vivek Ramkumar’s report: “if the majority of expenses are incurred in the last quarter of the year, this could indicate that the agency was keen to spend money even if it meant wasting it so that it could apply for the next installment of funding in the subsequent year.”
3. Notification services for journalists: When an interesting dataset is published, journalists would get a notification directly to their inbox. When data is open, the determining factor is not who gets exclusive data, but who has the skills to quickly analyse and interpret the data.
4. Search options - how to check whether the datasets (or similar datasets) have been published anywhere)? Some journalists also asked for tools to identify hotspots - to let them see what the most common searches were so that they could get an idea of the topics readers were most interested in and target their stories around those.
5. Ability to call up structured data around the budgeting process is very important: Such information is required in order to follow debates and to see how different MPs voted, as well as to follow amendments, when appropriations were changed, and who was responsible for making the changes. This also includes easy reference to e.g. laws which affect certain spending patterns laws which affect certain spending patterns, ideally presented in a handbook or short glossary format.
6. Linking the numbers to people and organisations: Numbers can be offputting - journalists need to put faces to them in order to make them accessible. Other requests in this vein were a personality tracker - people are particularly interested in following particular high profile names, so it would be interesting if you could follow particular people. For example, having information which lets journalists say ‘here are all the laws undersigned by a particular politician- are there any patterns’?
7. Disaggregated data or more information to understand provenance of aggregates: What is the source of the data? What is the formula via which the end result is reached?

### Read more:

* <http://blog.openspending.org/2011/10/27/thoughts-from-the-global-investigative-journalism-conference/>
* <http://www.guardian.co.uk/society/datablog/2011/mar/18/public-finance-data-store>
* <http://www.guardian.co.uk/news/datablog/2012/mar/16/us-open-spending-data>
* [Sunlight Foundation: Reporting group](http://reporting.sunlightfoundation.com/SLRG/)

<div class="pull-right"><a class="btn btn-default btn-mini" href="../chapter6-3">Next &raquo;</a></div>

