---
Title: ClearSpending from the Sunlight Foundation
---

## ClearSpending from the Sunlight Foundation

<table class="iconmatrix">
    <tr class="icons">
        <th class="inner">Fiscal Scope</th>
        <th class="inner">Project Aims</th>
        <th>Technology</th>
    </tr>
    <tr class="iconbar">
        <td class="inner">
            <img src="../images/revenue.png" class="no" title="Revenue Side" />
            <img src="../images/spending.png" class="" title="Spending Side" />
            <img src="../images/invisible_money.png" class="no" title="Off-Budget" />
        </td>
        <td class="inner">
            <img src="../images/upload.png" class="no" title="Publish Better Data" />
            <img src="../images/educate.png" class="" title="Educate Citizens" />
            <img src="../images/citizen.png" class="no" title="Facilitate Direct Participation"/>
            <img src="../images/decision-maker.png" class="" title="Get Feedback to Policy Makers" />
            <img src="../images/data_analysis.png" class="" title="Analyse and Understand Data" />
        </td>
        <td>
            <img src="../images/mobile.png" class="no" title="Mobile Technology" />
            <img src="../images/web.png" class="" title="Web-based Technology" />
            <img src="../images/offline.png" class="no" title="Offline and Print on Demand" />
            <img src="../images/piechart.png" class="" title="Data Visualisation and Maps" />
            <img src="../images/standards.png" class="no" title="Formats and Standards" />
            <img src="../images/social_media.png" class="no" title="Social Media" />
            <img src="../images/radio.png" class="no" title="Radio" />
        </td>
    </tr>
    <tr>
        <th class="inner">Geographical Coverage</th>
        <td colspan="2">USA</td>
    </tr>
	<tr>
	        <th class="inner">Scope</th>
	        <td colspan="2">Federal level</td>
	</tr>
	    <tr>
        <th class="inner">URL</th>
        <td colspan="2"><a href="http://sunlightfoundation.com/clearspending/">http://sunlightfoundation.com/clearspending/</a></td>
    </tr>
    <tr>
        <th class="inner">Users/Audiences</th>
        <td colspan="2">Civil society, national governments, international institutions, researchers</td>
    </tr>
</table>


<img alt="Clearspending" src="http://farm8.staticflickr.com/7226/7272476246_5ba1cbc2e7_o.png" class="screenshot" />

### Background

Clearspending analyzes the data quality of the grants data in USASpending.gov, the cornerstone of President Obama's transparency platform even before he took office. He co-sponsored the bill that created it whilst he was a Senator, and oversaw part of its execution in the executive branch. Clearspending addresses three metrics: timeliness, completeness, and consistency with other government estimates. Over $1.3 trillion failed on at least one of these metrics. Users of Clearspending can view topline data quality measurements by agency, or drill down to a program level to view the performance of specific grant and loan programs. Essentially, Clearspending is an oversight tool that examines the compliance of each agency and program with grant and loan reporting requirements. The site also provides substantial background information on the evolution of the reporting systems that power it (some are decades old) and the overall picture of how spending is reported in different areas of the federal government. The original methodology of Clearspending stems from a Government Accountability Office report on the same topic, but the sample-based methodology has been expanded with an automated program to examine all transactions instead of only a sample percentage.

### Target users

The targeted users are anybody who uses USASpending.gov to get spending data on grant and loan programs. This usually includes, but is not limited to, journalists, academics, policy analysts, concerned citizens, and congressional staffers. For anyone looking at a particular grant or loan program, Clearspending can tell you how much of the program's actual spending data you can expect to find in USASpending.gov. You can also see how on time a particular program or agency is in reporting their spending. Many agencies and programs report far past the 30 day statutory requirement, so their spending can vary widely depending on when you view the data, even after the given fiscal year has passed. As an auxiliary use, Clearspending is also designed to be used by anyone who would want to investigate which agencies or programs are not fulfilling their legal mandate to publish spending information online in a complete and timely manner.

### Successes

The project saw considerable public success as an oversight tool. The House of Representatives Committee on Oversight and Government Reform convened two hearings where the Executive Director of the Sunlight Foundation, Ellen Miller, was invited to testify regarding Clearspending analysis, one on the subject of achieving fiscal transparency and one on evaluating open government initiatives. Agency CTOs with particularly poor examples of data quality were also invited to testify. Follow-up questions and reports from the Committee resulted in the correction of some of the most notable errors.

Most of the errors that were pointed out were related to non-reporting programs. Specifically, the Department of Agriculture had chosen not to report for several programs because they had misinterpreted the guidance. They later wrote to the Oversight Committee explaining this, and pledging to begin reporting the spending. Also, after demoing the beta version of Clearspending to the department of Health and Human services and showing them the gap in medicare/medicaid reporting that Clearspending highlighted, they began back reporting Medicare data.

### Challenges

The main challenges of the site stemmed from the complicated picture of the federal spending systems themselves. Sketching a broad view of how the system is designed to work and at what points it is failing proved difficult for most casual users, and even some very knowledgeable users. Federal spending data is nearly impossible to simplify without losing a good deal of information that is valuable to experts on the subject.

### Data Problems

The major problems with the data were programs that, for whatever reason, chose not to report their spending. Additionally, many programs reported their spending long after the 30 day window in which they were supposed to, and sometimes even an entire fiscal year later. Another counterintuitive problem was the issue of over reporting. Confusion on the reporting guidance led to student loans being reported in the $6-7 trillion range, instead of the actual $60-80 billion range.

### Future Plans

The Sunlight Foundation re-released Clearspending with new data in Fall of 2011, and there are plans to update the analysis each year with new data. More ambitious aims include expanding the analysis to contracting data, which is a more difficult task, due to the lack of the kind of comparison data that was present for grants. Several FOIA requests for information regarding contracts data were in progress at the time of the report.

<p style="text-align: right">Thanks to Kaitlin Lee</p>

<div class="pull-right"><a class="btn btn-default btn-mini" href="../chapter6-2">Next &raquo;</a></div>
