---
title: Revenues from Oil and Mining - Revenue Watch
---

## Revenues from Oil and Mining: Revenue Watch

<table class="iconmatrix">
    <tr class="icons">
        <th class="inner">Fiscal Scope</th>
        <th class="inner">Project Aims</th>
        <th>Technology</th>
    </tr>
    <tr class="iconbar">
        <td class="inner">
            <img src="../images/revenue.png" class="" title="Revenue Side" />
            <img src="../images/spending.png" class="" title="Spending Side" />
            <img src="../images/invisible_money.png" class="" title="Off-Budget" />
        </td>
        <td class="inner">
            <img src="../images/upload.png" class="" title="Publish Better Data" />
            <img src="../images/educate.png" class="" title="Educate Citizens" />
            <img src="../images/citizen.png" class="no" title="Facilitate Direct Participation"/>
            <img src="../images/decision-maker.png" class="" title="Get Feedback to Policy Makers" />
            <img src="../images/data_analysis.png" class="" title="Analyse and Understand Data" />
        </td>
        <td>
            <img src="../images/mobile.png" class="no" title="Mobile Technology" />
            <img src="../images/web.png" class="" title="Web-based Technology" />
            <img src="../images/offline.png" class="" title="Offline and Print on Demand" />
            <img src="../images/piechart.png" class="" title="Data Visualisation and Maps" />
            <img src="../images/standards.png" class="" title="Formats and Standards" />
            <img src="../images/social_media.png" class="no" title="Social Media" />
            <img src="../images/radio.png" class="no" title="Radio" />
        </td>
    </tr>
    <tr>
        <th class="inner">Geographical Coverage</th>
        <td colspan="2">Global-level</td>
    </tr>
	<tr>
	        <th class="inner">Scope</th>
	        <td colspan="2">National governments</td>
	</tr>
	    <tr>
        <th class="inner">URL</th>
        <td colspan="2"><a href="http://www.revenuewatch.org/ ">http://www.revenuewatch.org/</a></td>
    </tr>
    <tr>
        <th class="inner">Users/Audiences</th>
        <td colspan="2">Civil society, national governments, international institutions, researchers</td>
    </tr>
</table>

<img alt="RWI" src="http://farm9.staticflickr.com/8158/7272473162_226235031b_o.png" class="screenshot" />

### Background

New technologies and new trends in transparency have unlocked wide new streams of government data about oil and mineral wealth. But access to data does not guarantee access to knowledge. Like the raw materials that get converted to energy, disclosed information often needs refinement and a functioning infrastructure of expertise, analysis and advocacy before it becomes "combustible" fuel for change.

Revenue Watch tools are aimed at helping to "follow the money" and make sure that wealth in the ground translates into development and economic growth above the ground. RWI and partners work to make the management of resource wealth more responsible, more transparent, and easier to understand. New technology is an increasingly vital part of this effort.

Revenue Watch has spent more than seven years promoting access to information as an indispensable tool for improving resource management for the public good. Over the last two years, they have been working to define and pilot effective uses of web technology for the display, analysis and dissemination of oil, gas and mining governance data.

### An Overview of Tools and the Role of Technology

The [EITI report analysis tool](http://data.revenuewatch.org/eiti) is a tool built by Revenue Watch based on information extracted from over 50 national reports from the Extractive Industries Transparency Initiative (EITI), a voluntary standard in which governments, civil society and companies work together to report payments and government receipts from oil, gas and mining. RWI’s tool presents per-country analysis using RWI's own indicators of report quality, features for comparison of different country results, and easy tools for sharing and downloading data.

To demonstrate the significance of disclosure rules for international oil and mining companies, RWI launched an [interactive calculator](http://data.revenuewatch.org/listings) illustrating the number and value of extractive sector companies listed on the largest global stock exchanges. This research and the streamlined presentation by value, by exchange and by sector, allows non-experts to explore the data themselves, and better understand the high stakes in new US and proposed EU laws requiring companies to come clean about what they are paying to governments of resource-rich nations.

A core principle of Revenue Watch’s technical work is that gaps in strategy or in familiarity with online modalities are the main obstacles to better uses of tech for transparency, as opposed to gaps in technology investment. Revenue Watch believe that by developing not only digital tools, but also replicable approaches to data distribution, usability and user training, they can set a higher standard for the use of oil, gas and mining information by governments, companies, advocates, journalists and citizens.

In addition to these two data tools launched during 2011, Revenue Watch also recently created a simple, highly visual interactive for comparing oil company profits with oil producing economies, at the self-explanatory web address [OilvsWorld.com](http://www.revenuewatch.org/issues/dodd-frank/oilvsworld) (as well as OilvsAfrica.com, OilvsEurope.com, OilvsAsia.com, OilvsAmericas.com).

The [Revenue Watch Index](http://www.revenuewatch.org/rwindex), a pioneering measure of oil and mining disclosure practices in more than 40 countries, was launched in 2010 as a way to break down and assess transparency practices. The index, created in partnership with Transparency International, is an assessment and comparison of information published by governments about revenues, oil savings funds, sovereign wealth funds and state-owned enterprises, contract terms and other key data. It is an important tool for elected officials, policy makers, civil society and the media when seeking increased public disclosure about natural resource management and greater government accountability. The 2012 index will feature a much richer set of underlying data which will be available for breakdown and comparison by region, country and indicator. This new version of the index is supported by Global Integrity's research platform [Indaba](http://www.getindaba.org).

Revenue Watch is also currently collaborating with the Open Knowledge Foundation (OKFN) to release an interactive database of original research compiling fiscal rules and royalty practices for mining in African countries.

### Specific User Skills and Usability

To maximize not just usability, but “use” of the tools, Revenue Watch worked on design for less-web-savvy users, working in lower-bandwidth settings, possibly on older computers. To maximize dissemination across social networks, where personal connections ensure information shared is more relevant and thus more persuasive, Revenue Watch paid particular attention to tools for sharing the data, including custom links to share user-created views (building on the examples of the World Bank and Google, among others). And, given the reality that the most effective advocacy and analysis often happens "offline", particular emphasis was given to making custom views and full data sets easier to download or print for later use - particularly in the case of the EITI data.

As new tech approaches are adopted and integrated further across RWI programming, their tools and advocacy will prioritize easier adoption of technology and smarter integration of tech by all actors in the natural resource governance sector.

### Successes

RWI's analysis of EITI reports and the EITI data tool represent the first ever compilation of the numerous country level reports in one place and extraction of the report data into a sortable online database. Taken together, these tools helped to demonstrate the value of EITI reporting and provide the first one-stop destination for this data for users in the field, including, for instance, officials at the International Monetary Fund, who decided to use the tool as a resource rather than building their own EITI repository. EITI Chair Clare Short has often cited RWI's research and report tool since it debuted at EITI's 2011 global conference. Most importantly, the RWI tool has served as a model for EITI undertakes its own plan to harvest report data and offer the data online.

### Issues with the Data and Standardisation

One challenge within the EITI data has been issues of comparability and standardisation. RWI had to carry out additional calculations and make certain decisions in order to enable more meaningful comparisons to be drawn from the data. This is inevitable given the nature of EITI reporting itself.

One challenge especially illustrative of the difficulties of creating data sets for oil, gas and mining governance came whilst RWI were carrying out research into oil and mining companies on the largest international stock exchanges. A widespread practice by companies of listing the same securities on multiple exchanges made it difficult to accurately calculate the cumulative market capitalization of oil and mining companies across multiple exchanges. Even the data provider most commonly used as a source for securities data (Bloomberg) turned out to have data that was still full of "cross-listings" of the same securities. "Cleaning" the data to approach a more accurate estimate of market capitalization (a core statistic for the tool's presentation of oil and mining sector value) was a labor-intensive task that, while replicable, was not one that automation could solve due to the level of "noise" in the data. This basic statistic - How much is the sector worth on a given exchange? - is itself very difficult to determine. This is taken as a further sign that better practices in the industry are need in order to reach effective fiscal transparency.

A good dataset does not guarantee a good database or tool. Most importantly, even a working tool that offers simple access and downloadability of the data does not guarantee usability or "understandability" of the data. This step is the one most often short-changed in the open data activity cycle. Data is not always actionable simply because it is available. A simple interface designed according to user-centric principles, with tools that give the end user power to use the data according to their needs, and which has context and guidance to show what the data means instead of just what it ”is”, are all fundamental elements of the broader "accessibility" that make data leverageable for greater knowledge and further advocacy.

### Project resources

The two main data sites mentioned above required several steps to build: data collection, data analysis, tool creation and interface design. A total of only 4-5 people were involved across all phases, but it is important to note that the skill sets required for each of these elements are quite different. Good data collection does not guarantee good data modeling for comparability (or deduplication, as in the stock calculator example).

### User comments:

> “Of the sources you mention the only one I have regularly used is Revenue Watch's Stock Exchange Calculator. It's been very useful for comms purposes (as a place to source a fact/figure to support my [argument](http://publishwhatyoupay.org/newsroom/blog/why-dodd-frank-1504-won%E2%80%99t-undermine-competitiveness))”.


>“The Oil vs the World tool is good but could be even more useful with a different set of indicators (I'm not sure about the comparability (even if for the sake of the effect of contrast) between GDP and oil company profit. More effective could be to see revenues generated per country for their natural resources vs population living on less than 1 dollar; or oil company profit vs cost of compliance etc...)”.

<p style="text-align: right">Thanks to Jed Miller, RWI</p>

<div class="pull-right"><a class="btn btn-default btn-mini" href="../chapter6-intro">Next &raquo;</a></div>
