---
title: Government of Sierra Leone GoSL - Online Repository for Ministry of Mines and Mineral Resources
---

## Government of Sierra Leone GoSL: Online Repository for Ministry of Mines and Mineral Resources

<table class="iconmatrix">
    <tr class="icons">
        <th class="inner">Fiscal Scope</th>
        <th class="inner">Project Aims</th>
        <th>Technology</th>
    </tr>
    <tr class="iconbar">
        <td class="inner">
            <img src="../images/revenue.png" class="" title="Revenue Side" />
            <img src="../images/spending.png" class="no" title="Spending Side" />
            <img src="../images/invisible_money.png" class="" title="Off-Budget" />
        </td>
        <td class="inner">
            <img src="../images/upload.png" class="" title="Publish Better Data" />
            <img src="../images/educate.png" class="no" title="Educate Citizens" />
            <img src="../images/citizen.png" class="no" title="Facilitate Direct Participation"/>
            <img src="../images/decision-maker.png" class="" title="Get Feedback to Policy Makers" />
            <img src="../images/data_analysis.png" class="" title="Analyse and Understand Data" />
        </td>
        <td>
            <img src="../images/mobile.png" class="no" title="Mobile Technology" />
            <img src="../images/web.png" class="" title="Web-based Technology" />
            <img src="../images/offline.png" class="no" title="Offline and Print on Demand" />
            <img src="../images/piechart.png" class="no" title="Data Visualisation and Maps" />
            <img src="../images/standards.png" class="" title="Formats and Standards" />
            <img src="../images/social_media.png" class="no" title="Social Media" />
            <img src="../images/radio.png" class="no" title="Radio" />
        </td>
    </tr>
    <tr>
        <th class="inner">Geographical Coverage</th>
        <td colspan="2">Sierra Leone</td>
    </tr>
    <tr>
        <th class="inner">URL</th>
        <td colspan="2"><a href="http://sierraleone.revenuesystems.org/">http://sierraleone.revenuesystems.org/</a></td>
    </tr>
    <tr>
        <th class="inner">Costs</th>
        <td colspan="2">The mineral rights administrative system and the online repository have been implemented over a period of two years, costing approximately EUR 400,000 (including training, support and equipment for an administrative system)</td>
    </tr>
    <tr>
        <th class="inner">Project executed by</th>
        <td colspan="2">Revenue Development Foundation (RDF) </td>
    </tr>
</table>

<img alt="GoSL" src="http://farm8.staticflickr.com/7239/7272473284_c043da6810_o.png" class="screenshot" />

### Background

A system that allows governments to publish all mining licences and associated revenues directly from their administrative system. The system can also present other types of revenue data such as forestry concessions, fishing rights, property and land rights.

The system aims to increase government credibility and investor confidence in licenses issued by the government, and thereby increase foreign investments. The system currently has over 500 users, 65% of whom are mining companies and investors looking to verify government issued licenses and companies' good standing.

Data comes directly from government systems and supports the Extractive Industries Transparency Initiative (EITI) by making audits of government receipts easier and accessible to the public. This generates a close accountability cycle between the public and government, as compared to EITI audits, where audits of government-received payments usually only takes place 2-3 years after they are made.

The Sierra Leone government is in control of when and what to publish to the public and/or stakeholders, but typically publish updated data bi-monthly. The system contains all mining rights and license payments from 1 January 2010, as well as all exporters licenses and export taxes from 2008.

Developers behind the site have attempted to make integration with existing government database management systems as simple as possible. Data is imported using an XML schema, which most database systems are compatible with.

The online portal software can be provided for free and hosted by the Revenue Development Foundation to government institutions. However, it requires an administrative system to be in place from which the data can be extracted.

### Challenges and Lessons

Most government institutions in poor countries require extensive support to improve their administrative processes and systems in order to allow public scrutiny of their data. The GoSL Online Repository is the result of RDF support to the Ministry of Mines and Mineral Resources in Sierra Leone which has been given since 2009. RDF has seconded staff to their Mining Cadastre Office throughout the period, in order to change the administrative processes and improve data management. The Ministry use RDF's Minerals Cadastre Administration System (MCAS) to manage the mining licenses they issue, and the data is published to the online portal directly from this system.

While the initial expectations were that civil society organisations would be prime users of the online data, experience has shown that mining companies and investors are the primary users, alongside law enforcement agencies.

### Scalability and Future plans

The system has been designed to be as flexible and scalable as possible. The backend can import a range of government license-and revenue-related datasets.
The GoSL Online Repository was launched by the Government of Sierra Leone in January 2012. Similar systems are currently being deployed for Liberia and Gambia. Work is planned to start in Mali.

<p style="text-align: right">Thanks to Aasmund Andersen, RDF</p>

<div class="pull-right"><a class="btn btn-default btn-mini" href="../chapter5-2">Next &raquo;</a></div>
