---
title: XBRL
---

## International Financial Reporting Standards: XBRL

<table class="iconmatrix">
    <tr class="icons">
        <th class="inner">Fiscal Scope</th>
        <th class="inner">Project Aims</th>
        <th>Technology</th>
    </tr>
    <tr class="iconbar">
        <td class="inner">
            <img src="../images/revenue.png" class="" title="Revenue Side" />
            <img src="../images/spending.png" class="" title="Spending Side" />
            <img src="../images/invisible_money.png" class="no" title="Off-Budget" />
        </td>
        <td class="inner">
            <img src="../images/upload.png" class="" title="Publish Better Data" />
            <img src="../images/educate.png" class="no" title="Educate Citizens" />
            <img src="../images/citizen.png" class="no" title="Facilitate Direct Participation"/>
            <img src="../images/decision-maker.png" class="" title="Get Feedback to Policy Makers" />
            <img src="../images/data_analysis.png" class="" title="Analyse and Understand Data" />
        </td>
        <td>
            <img src="../images/mobile.png" class="no" title="Mobile Technology" />
            <img src="../images/web.png" class="" title="Web-based Technology" />
            <img src="../images/offline.png" class="no" title="Offline and Print on Demand" />
            <img src="../images/piechart.png" class="no" title="Data Visualisation and Maps" />
            <img src="../images/standards.png" class="" title="Formats and Standards" />
            <img src="../images/social_media.png" class="no" title="Social Media" />
            <img src="../images/radio.png" class="no" title="Radio" />
        </td>
    </tr>
</table>

The eXtensible Business Reporting Language (XBRL) is a data standard for financial reporting, most commonly used to cover accounting information. The goal of XBRL is to efficiently create and disseminate data in a standardized, XML-based format that lends itself to [analytics](http://www.sec.gov/spotlight/xbrl/what-is-idata.shtml). XBRL makes few assumptions about the semantics of the data expressed in it, instead standardizing a framework in which specific reporting types, such as US GAAP or IFRS can be expressed as [taxonomies](http://www.xbrl.org/FRTApproved), each with a specific set of tags to express the reporting elements which are necessary to comply with the standard. A growing number of such taxonomies are developed and maintained by the [XBRL community](http://www.xbrl.org/FRTAcknowledged).

XBRL has enjoyed widespread adoption as a reporting language for business accounting data across a number of countries, the most notable being the United States, where both the FDIC (2005) and the SEC (2009) have adopted the standard - by 2013 even international companies will have to file their reports to the SEC in XBRL/IRFS. There is little doubt that within a few years, XBRL will be the global lingua franca for accounting information. Going further, the [XBRL General Ledger](http://www.xbrl.org/GLTaxonomy) aims to make the standard usable within companies, storing detailed transactional and other operational information.

Of course, this comprehensive commitment raises this question: If XBRL is accepted by governments worldwide for receiving data, shouldn’t it also be used to report their own finances? While there is some discussion on the use of XBRL for fiscal information, no taxonomies exist for budget information or transactional government spending. One concern regarding the use of XBRL as a reporting standard for government information may be its complexity: the XML schema requires the implementation of extensive standards to be interpreted. This would run contrary to the goal of transparency by raising the barriers of entry to the analysis of government financial releases. The use of common taxonomies, on the other hand, is a very desirable property, as could also be seen in the IATI example.

<div class="pull-right"><a class="btn btn-default btn-mini" href="../chapter5-intro">Next &raquo;</a></div>
