---
title: IATI
---

## International Aid Transparency Initiative (IATI)

<table class="iconmatrix">
    <tr class="icons">
        <th class="inner">Fiscal Scope</th>
        <th class="inner">Project Aims</th>
        <th>Technology</th>
    </tr>
    <tr class="iconbar">
        <td class="inner">
            <img src="../images/revenue.png" class="" title="Revenue Side" />
            <img src="../images/spending.png" class="no" title="Spending Side" />
            <img src="../images/invisible_money.png" class="" title="Off-Budget" />
        </td>
        <td class="inner">
            <img src="../images/upload.png" class="" title="Publish Better Data" />
            <img src="../images/educate.png" class="no" title="Educate Citizens" />
            <img src="../images/citizen.png" class="no" title="Facilitate Direct Participation"/>
            <img src="../images/decision-maker.png" class="" title="Get Feedback to Policy Makers" />
            <img src="../images/data_analysis.png" class="" title="Analyse and Understand Data" />
        </td>
        <td>
            <img src="../images/mobile.png" class="no" title="Mobile Technology" />
            <img src="../images/web.png" class="" title="Web-based Technology" />
            <img src="../images/offline.png" class="no" title="Offline and Print on Demand" />
            <img src="../images/piechart.png" class="no" title="Data Visualisation and Maps" />
            <img src="../images/standards.png" class="" title="Formats and Standards" />
            <img src="../images/social_media.png" class="no" title="Social Media" />
            <img src="../images/radio.png" class="no" title="Radio" />
        </td>
    </tr>
    <tr>
        <th class="inner">Geographical Coverage</th>
        <td colspan="2">International</td>
    </tr>
    <tr>
        <th class="inner">URL</th>
        <td colspan="2"><a href="http://www.aidtransparency.net">http://www.aidtransparency.net</a></td>
    </tr>
    <tr>
        <th class="inner">Users/Audiences</th>
        <td colspan="2">Donors, parliaments of developing countries, private companies and foundations </td>
    </tr>
</table>

<img alt="IATI" src="http://farm8.staticflickr.com/7100/7272476346_0ae81268a5_o.png" class="screenshot" />


### Background
Building on around 20 years of previous work, the first version of the International Aid Transparency Initiative (IATI) standard was launched in early 2011 and aid donors around the world started publishing to it. The IATI standard documents data about both aid donors and aid activities, enabling comparison and encouraging good practice in data management. The IATI standard also includes space to attach relevant documents and details of project results, to allow the standard to build context around the data and become an end-to-end solution, tracking projects from inception to execution.

The IATI standard has seen far greater uptake than any previous effort in terms of organisations electing to publish their data in the standard. These successes are often attributed to the multi-stakeholder nature of the design process, including both policy makers and technical experts. From 2009 to 2010, IATI consulted with a wide range of stakeholders on the design of the technical standard, alongside a parallel process to secure donor support for publishing their aid information.

### The Role of Technology

In the past it was common to respond to information shortages by building a new database. But by working with open data principles, IATI allows a more distributed solution - where information can flow between organisations in many different ways, not just into a central database.

The benefits of this approach have already been demonstrated, with many NGOs and charities choosing to follow the IATI Standard, although it was developed primarily with governments in mind.

Donors publish aid information as a feed which can be read by many different applications; both those created by other donors, by the open data community, and - importantly - by software providers to developing country financial systems. By providing aid information in a standard format, many different users can access the data in the way they need to - and developing countries can see the resources, which are supposed to be flowing to them.

### Main User Groups:

1. Parliamentarians in developing countries gain a better oversight of the aid resources available. Knowing where to allocate resources in their own budgeting processes is vital to ensure that money is spent in the best way / most efficiently. Sometimes, there is a transparency-asymmetry between different parts of government. For example, a treasury may be very willing to open up the information it holds, but departments which benefit strongly from aid donations (e.g. departments of health) may be more reluctant to be transparent about aid revenues, as they will not want to 'lose out' from central government budgeting.
2. Donors: Know where their money is going and whether it is being spent correctly.
1. Private companies and foundations: e.g. [Akvo](http://www.akvo.org/), who are examining options for using IATI in their really simple reporting system (RSR).
Aid Info Labs has also done a more extensive series of profiles on potential users of [IATI data](http://www.aidinfolabs.org/archives/category/inspiration/people).

### Does the Project Require the Users to Have Specific Skills?

Right now, direct access to raw IATI data requires some technical skills, but tools are being created like spreadsheet export of the raw data and preview tools to lower the barriers to entry.

By working to improve the quality of the data and working with different infomediaries, from developers to researchers to activists on the ground, we can make sure that people can get access to the information they need.

### Project Resources

IATI centrally has needed both political and technical skills in the team - to facilitate a standard development process with a wide range of stakeholders. This involves being able to help people come together from across the world, which takes many resources.

There are many different donors publishing IATI data, so they’ve needed different skills and support. Big donors have had to adapt their existing databases to output IATI data. Small donors have had a range of tools available to help them create IATI data - like openaidregister or aidstream.

To use the data, some technical skills are needed, but also, importantly, skills to understand the complex aid infrastructure are important. AidInfo have been developing a one week course in understanding aid which will be piloted with NGOs in Nepal later this year, and which will be delivered alongside access to technical support to use IATI data provided by Young Innovations Nepal (YIPL).

### Successes:

1. The IATI registry now hosts links to hundreds of files of IATI standard data, covering thousands of aid activities. Over fifty percent of official Overseas Development Assistance will be covered by the IATI Standard now that commitments from major donors have been made to use the standard.
2. Previously, it was difficult even for the governments of recipient countries to know how much money the country was getting from external sources. This affected their ability to be able to effectively prioritise budgeting “[U]nderstanding what donors are estimating to give to our country, whatever sector, helps us [...] to avoid what most ministries may do if we are not on top of information, doubledipping. They come to the Ministry of Finance and request for things that are funded by a donor.” (Brookings Institution Proceedings 2010).
3. Proactive transparency: Lots of Charities (and not only those asked to do so by DFID) are looking at publishing IATI data, as the existence of the standard encourages more organisations to open up what they are doing. The drivers here may in part be around accountability, but also link to motivations of showing donors/public what the charities does, and finding opportunities for collaboration between organisations.
4. The standard has made it worthwhile to build tools that make it easier to publish data in the correct format: such as [openaidregister](http://www.openaidregister.org/) and [Aidstream](http://aidstream.com/public/).
5. The existence of this standard has sparked interest in mapping aid onto other types of financial data such as budgets. When budgets also conform to a standard, such as COFOG, tools can be built to do this work automatically. ‘Interfacing aid information with budgets needs to be tackled at the country level to make information relevant for a specific recipient country, and at donor headquarters level to facilitate the interface at country level. Country aid management systems need to be enhanced to deliver such functionality’ (Mills and Moon 2010).

### Challenges

1. There are still simple technical issues - not using the right XML field names, or the wrong format for dates. Initially this was a challenge, but the technical team have been developing tools to help assess data, and working with data publishers on data quality. This can't just be an automated process, as there are differences in data across the world which need human assessment.
2. It is still difficult to cross-reference with other published figures such as budgets and expenditure (particularly when they do not balance).
3. Adoption: While there have been many early uptakers, more work is needed to ensure that other donors and recipients are encouraged to implement the standard.

### What is Needed to Address These Issues

1. Quality-assurance tools to automatically check to see that a standard is being used well. Without these, downstream users of the data suffer technical problems.
2. Grass-roots level trainers and community building: Working co-operatively with data publishers as far upstream as possible to check that the content of data is reliable. If this only happens when data comes to be used, lots of people have to duplicate the effort to make the data consistent.
3. Data-management and merging systems: Publishers generating data in the IATI format might have data for different parts of the IATI Standard in different systems: e.g. project financials in one system, results in another, and mapping in another. If IATI data is generated from the projects system only, other content is missing from the IATI form. Having tools to allow merging of data, or allowing anyone to apply annotations to the data, would be valuable.
4. Auxiliary information: A lot of information is locked up in the documents that IATI files can refer to (projects can have related documents), better linkage between them would be helpful.
5. Tools for entity/concept extraction: Entity extraction tools allow the users to identify which individuals, organisations, projects etc. (i.e. entities) are present in a document, allowing them to understand relationships and which documents are related to which transactions and projects. If systems for visualising and presenting data throw the links to these documents away early on, then users’ transparency needs are not well served.
6. The promotion of a standard for transactional level spending data could be useful. This would enable tools to be built which could automatically map aid data onto other budgetary information.

AidInfo Labs documents plans, prototypes and products which make use of and build on IATI data. These can be found on their website, under the inspiration tab.

### Learning Points:

Getting organizations to share their aid data in a sustainable manner and to institutionalize the sharing of aid data through IATI takes time. IATI is already tremendously successful, but it is a long-term project and initial estimates number of donors publishing with IATI could be seen as somewhat optimistic.

Adapting organisational processes to cope with change management,  and system adaptation to enable organisations to start publishing fluid, planning stage information, was difficult for organisations that were accustomed to more statistical reporting (DAC and CRS) and required more work than was initially expected.

<p style="text-align: right">Thanks for input from Tim Davies, Michael Roberts and Mark Brough </p>

<div class="pull-right"><a class="btn btn-default btn-mini" href="../chapter4-2">Next &raquo;</a></div>
