---
title: Introductions
---

## Testimonials: User Perspectives on using Government Fiscal Data

The statements below all come from re-users of fiscal data outside of government. Each person talks about what fiscal data they required, what they wanted to do with it, and importantly, how easy it was to obtain and use

### Canada: DataBC and tools for non-developers

> “Another nice thing about the data.gov.bc.ca website is that it provides tools for non-developers, so that they can play with, and learn from, some of the data.”

### Republic of Korea: Perspectives on D-Brain 

> “D-Brain is only open to government officials viewing data. I cannot imagine getting data of my taste (say using SQL to select variables, and do simple analysis on it) from D-Brain. It only shows numbers of each categories by keyword searching.” 

### Albania: Providing datasets to advocacy NGOs to challenge commonly accepted facts 

> “In Albania, every governmental agency has to provide activity data, but the data is not being analytically used for different reasons. Sometimes the process of the data generation in these agencies is neglected, [...] and sometimes these data are erased after a short period. [...] The Albanian government has a statistical office, the Institute of Statistics (INSTAT), which works directly under the authority of Council of Ministers. There is a limited amount of the available data being published and the credibility of INSTAT is questionable - has been accused many times (on) of hiding important data or providing ambiguous data in favour of the government.” 

### Australia: Monitoring industry influence on government 

> Problems with the Data: 
>
> 1. Not openly licensed by default 
>
> 2. Not good data access - we have to get weekly exports every Sunday in CSV and after 2 years they disappear from the data store, so if a project was starting today they could not get all the data. There is no programmable API to access these exports, just a web page. 
> 3. No validation/verification - having to build up the database week by week means we could lose transactions and not notice 
> 4. Company data is closed - In Australia, the company register is pay-per-use so we cannot afford to find out who the directors of 300,000 different records are.

### Bulgaria: Developing a visualisation of the Bulgarian budget using OpenSpending.org 

> Interesting Documents: 
>
> 1. State Budget - Published as a PDF containing the budget law - very ugly. For the OpenSpending budget visualization I made, I had to parse the consolidated financial framework. [Level of detail is not sufficient] I would like to dig down to each expense. 
> 2. Public Procurement Information - Published on a website - can be parsed. [Data is very timely] no more than a day or two delay. 
> 3. State Audit Agency reports - Published on a website - can be parsed. Financial data on various topics of interest like: election financing, property of the public figures, political donations, party finances and other very, very interesting datasets. [Regarding timeliness] Periodic, they are ok with the terms. 
> 4. Company register - Detailed information about all companies in Bulgaria way more detailed than is public in UK. [Unfortunately] Data is behind paywall - 15 000 euros/year, there is an API included in the same 15 000 euros/year cost. [Information is] very timely, updated every moment. 

### Croatia: Institute of Public Finance 

> “MoF ([Ministry of Finance](http://www.mfin.hr/)) web has a lot of interesting data [...] probably too rich, more fit for experts than for citizens or journalists. [...] [State Auditing Office](http://www. revizija.hr/hr/) claims that it puts all their reports on their web, but they don’t keep them there.” 

### Estonia: Making budgets understandable for citizens 

>“When published, the budget structure is too complicated, even for specialists in any policy field. The format is not machine-readable. So there is access to information but barriers for its usability and re-use by non-government groups.” 

### Georgia: Increasing fact-based dialogue 

>“One of our goals was to begin to make an online interactive interface which brings Tbilisi’s expenditures down to earth in a way a larger audience can understand.[...] The data, unfortunately, only covered the first two levels of the COFOG classification system, and so lacked the detail to allow me to understand in reality how Tbilisi City Hall spent funds. The reason I did not use a government transparency portal was because at that time it did not exist. Apparently, one exists now, but it was never advertised and nobody knew about it." 

> “...it would make sense that the financial system used to create and implement Tbilisi City Hall’s budget and keep track of expenditures have a public API that would allow for real time queries that provided comprehensive, detailed, up-to-date and machine-readable results.” 

### Greece: [Visualising the Greek Annual Budget](http://projects.thodoris.net/budget/ )

> “We collected data by extracting them from PDFs [...] it would be ideal , if they made them available online in open - machine readable formats , either as digital files or through a web service. A similar problem occurred while we tried to collect financial figures for public debt and deficit” 

### Mexico: Applied Research into public policy 

> “The TP portal has visualizations and graphics that are useful to understand the budget process and it also has a citizen’s budget, but it lacks most of the raw [disaggregated] data you can find in the SHCP portal. The “Analíticos Presupuestarios” is a fairly good source of data but it lacks details such as the classification by “partida” (the most specific economic classification that the Mexican government use). It will be very useful if all the main budget documents have the same data structure (know it is not possible to follow some classifications in the in-year reports for example). Tools such as the [Peruvian “Transparencia Económica](http://ofi.mef.gob.pe/transparencia/Navegador/default.aspx)” are very useful to systematize specific information.” 

### Nigeria: Building a budget-cut and crowd-sourcing oversight app 

> “For sub-national data who have no defined government portal, we have been able to use our informal contacts to [get] data from two states out of thirty six states. We need to reach out to the states as most of them are not used to providing their budget data to the public. Our short term goal is to drive transparency within these states” 

<div class="pull-right"><a class="btn btn-default btn-mini" href="../chapter4-intro">Next &raquo;</a></div>
