---
title: Brazilian Transparency Portal - Access to Information and Citizen Oversight
---

## Brazilian Transparency Portal: Access to Information and Citizen Oversight

<table class="iconmatrix">
    <tr class="icons">
        <th class="inner">Fiscal Scope</th>
        <th class="inner">Project Aims</th>
        <th>Technology</th>
    </tr>
    <tr class="iconbar">
        <td class="inner">
            <img src="../images/revenue.png" class="" title="Revenue Side" />
            <img src="../images/spending.png" class="" title="Spending Side" />
            <img src="../images/invisible_money.png" class="" title="Off-Budget" />
        </td>
        <td class="inner">
            <img src="../images/upload.png" class="" title="Publish Better Data" />
            <img src="../images/educate.png" class="" title="Educate Citizens" />
            <img src="../images/citizen.png" class="no" title="Facilitate Direct Participation"/>
            <img src="../images/decision-maker.png" class="" title="Get Feedback to Policy Makers" />
            <img src="../images/data_analysis.png" class="no" title="Analyse and Understand Data" />
        </td>
        <td>
            <img src="../images/mobile.png" class="no" title="Mobile Technology" />
            <img src="../images/web.png" class="" title="Web-based Technology" />
            <img src="../images/offline.png" class="no" title="Offline and Print on Demand" />
            <img src="../images/piechart.png" class="no" title="Data Visualisation and Maps" />
            <img src="../images/standards.png" class="no" title="Formats and Standards" />
            <img src="../images/social_media.png" class="" title="Social Media" />
            <img src="../images/radio.png" class="no" title="Radio" />
        </td>
    </tr>
    <tr>
        <th class="inner">Country</th>
        <td colspan="2">Brazil</td>
    </tr>
    <tr>
        <th class="inner">URL</th>
        <td colspan="2"><a href="http://www.portaltransparencia.gov.br">http://www.portaltransparencia.gov.br/</a></td>
    </tr>
</table>


<img alt="Brazilian Transparency Portal" src="http://farm9.staticflickr.com/8007/7274151266_0ab15698f5_o.png" class="screenshot" />

### Background


In 2004, the Brazilian Office of the Comptroller General (CGU) created the Transparency Portal, a tool that aims at increasing fiscal transparency of the Brazilian Federal Government. Developed in partnership with the Federal Data Processing Service – SERPRO, the Transparency Portal relied on the collaboration of diverse Ministries and bodies of the Federal Public Administration to advance the transparency of information on the application of federal public resources and to offer a tool that can stimulate citizen participation. The Portal brings, in simple language, detailed information about how public resources are spent. It is known as one of the most important tools of e-government in regard to public spending control.

### Available Fiscal Data

#### Expenses:
1. Daily Information: Budget and financial execution data with daily updating of the acts performed by administrators,
2. Transfer of Resources: To states, municipalities, companies, transfers made in foreign land, or directly to an individual,
3. Direct Expenses by the Federal Government: Construction contracts, government purchases, per diems paid and expenses on government credit cards, indicating the person that expensed any of the financial operations above

#### Revenue:

1. Budget and financial execution data with daily updates of the estimated government revenue.

#### Other

1. 2014 World Cup and Rio 2016 Olympic Games Expenses

### Overview of Other Resources and Features

1. Agreements: Register of Covenants, government partnerships  sealed in the past years
2. CEIS: List of companies sanctioned by public entities
3. Public Officials: List of public officials, including information about position, function and functional position, with a link to a schedule of remuneration and government positions
4. Other links: List of all institutions of the federal government that have their own transparency websites
5. Other information and Services: Guidelines about public participation and citizen control, including a section “saiba mais” (know more about it) about government programs and how to police/audit them,
6. Download of queries
7. Data in graphs and other visualizations

### User Groups and Audiences

The Portal registers an average of 410 000 monthly visits. The number of citizens accessing the Transparency Portal has grown from 10 000 to 336 512 per month, between 2004 and 2012. A total of 44 640 citizens are registered and receive information about resource transfer in government partnerships with 5 561 municipalities. Information is sent to registered users via email.

### Successes and Outcomes

There have been a number of concrete cases where the Transparency Portal has supported direct social control of government activities. At the beginning of 2008, Brazil’s domestic media published numerous reports about “suspect” expenditure made using federal government Payment Cards. In one case the reports led to the resignation of one federal minister. In other cases the portal’s data has given rise to unsubstantiated media reports.

The Transparency Portal will only be successful if a variety of stakeholders are engaged in anti-corruption efforts. Citizens, non-governmental organizations, press, private sector, academic institutions, think tanks and other civil society actors have an indispensable role to achieve the project’s effectiveness. To improve the interaction between government and civil society, the Transparency Portal discloses a communication channel: “Contact us”. Through this channel, the Portal users can elucidate any doubts related to the accessibility or to its own content, as well as praise or make suggestions. Through this channel the Portal also receives many suggestions for improvement and denounces of misuse of public money.

### Challenges

Monitoring and evaluating the impact of the Transparency Portal is an evolving area. The Office of the Comptroller General of the Union measures the average time spent on the website, as well as its bounce rates, pages per visit, visitors, most demanded searches, among other data. Access numbers have been used to identify demands for different queries and the depth of information researched by users. This analysis allows web managers to prioritise the most requested information in the layout. Bounce rates can be used to improve e.g. the frequently asked question section.

### Project Resources

The Portal is administered by a Management Group and a Working Group (operational), composed of representatives of the areas of Corruption Prevention and Strategic Information, Internal Control and Information Systems, approximately 12 public officials (including Managers and operating team, most of them part time). In addition, there is a Technical Technology Group in total approximately 10 public officials working directly to Portal. This makes use of Public budget resources of the Federal Government.

Approximately 137 000 USD was invested for the initial stage of the Portal’s development, from the Office of the Comptroller-General regular budget. Nowadays, the Office of the Comptroller-General of Brazil (CGU) controls the program’s database and the maintenance cost is relatively low.

<p style="text-align: right">Thanks for input from Izabela Moreira Correa, CGU</p>

<div class="pull-right"><a class="btn btn-default btn-mini" href="../chapter3-intro">Next &raquo;</a></div>
