---
title: Introductions
---

## D-Brain in Korea: Digital budgeting and accounting system

<table class="iconmatrix">
    <tr class="icons">
        <th class="inner">Fiscal Scope</th>
        <th class="inner">Project Aims</th>
        <th>Technology</th>
    </tr>
    <tr class="iconbar">
        <td class="inner">
            <img src="../images/revenue.png" class="no" title="Revenue Side" />
            <img src="../images/spending.png" class="" title="Spending Side" />
            <img src="../images/invisible_money.png" class="no" title="Off-Budget" />
        </td>
        <td class="inner">
            <img src="../images/upload.png" class="" title="Publish Better Data" />
            <img src="../images/educate.png" class="no" title="Educate Citizens" />
            <img src="../images/citizen.png" class="" title="Facilitate Direct Participation"/>
            <img src="../images/decision-maker.png" class="no" title="Get Feedback to Policy Makers" />
            <img src="../images/data_analysis.png" class="no" title="Analyse and Understand Data" />
        </td>
        <td>
            <img src="../images/mobile.png" class="no" title="Mobile Technology" />
            <img src="../images/web.png" class="" title="Web-based Technology" />
            <img src="../images/offline.png" class="no" title="Offline and Print on Demand" />
            <img src="../images/piechart.png" class="no" title="Data Visualisation and Maps" />
            <img src="../images/standards.png" class="no" title="Formats and Standards" />
            <img src="../images/social_media.png" class="no" title="Social Media" />
            <img src="../images/radio.png" class="no" title="Radio" />
        </td>
    </tr>
    <tr>
        <th class="inner">Country</th>
        <td colspan="2">Republic of Korea</td>
    </tr>
    <tr>
        <th class="inner">URL</th>
        <td colspan="2"><a href="http://www.digitalbrain.go.kr">www.digitalbrain.go.kr</a></td>
    </tr>
    <tr>
        <th class="inner">Vital Statistics</th>
        <td colspan="2">Total 77,000 registrations of central and local government officials and public agency users. 200,000 transactions by 15,000 users per day. Payment of about 3.6 trillion won ($3billion) on daily average (Korea’s 2010 budget : 292.8 trillion won). Connected to 55 related information systems.</td>
    </tr>
</table>

<img alt="D-Brain" src="http://farm8.staticflickr.com/7100/7274122142_d489a01d58_o.png" class="screenshot" />

The top-ranking e-Government nation according to the e-Government Development Index and UN Global [E-Government Survey](http://www2.unpan.org/egovkb/global_reports/12report.htm) was the Republic of Korea. Korea’s solution for a public facing Digital Budget & Accounting System (DBAS - or nicknamed D-brain), adopted in 2007, has also been making waves as a leading model of innovative digital budgeting.

More than a data portal, D-Brain is a web-based participatory budgeting system, which ensures citizens’ participation throughout the entire budget cycle from budget preparation to audit. D-Brain was covered in detail by Gigler et al. (2011) in their report ‘Technologies for Transparency and Accountability: Implications for ICT Policy and Administration’ and as such, we will not replicate the same research. A couple of key points from their research are highlighted below.

### Overview of Features (see [Gigler et al.](http://scr.bi/wb-report-draft))

1. Integrated web-based system providing the public with real time analysis on government’s fiscal activities including budget formulation, execution, account settlement and performance management.
2. Participatory budgeting where the central government, local governments, public institutions and the public collaboratively decide on the allocation of resources and participate in nationwide fiscal decision making.
3. Citizen participation is enabled throughout the budgeting process through internet surveys, an online bulletin board, online bidding, a cyber forum, d-budget participation corner and public hearings to name but a few. Furthermore, there is a Budget Waste Report Center which offers a hotline and on-line system for citizens to prevent central government agencies and local government offices from misbehaving. Citizens are encouraged to report alleged misappropriations of government funds and are incentivised to do so with a ‘budget saving incentive bonus’, at most $30,000 which can be awarded to a citizen reporter if allegations are found to be true.

### Benefits for Government

1. System enables a better use of the national budget by reducing duplicative expenditure, leading the nation towards a more efficient fiscal policy. Oversight led by both policy makers and the public, who all have access to the necessary budget information to validate the accuracy and reliability of the budgeting records.
2. Before the existence of d-Brain, Korea had experienced budgeting and accounting difficulties and no feedback mechanisms to monitor inefficiency. These difficulties included no ability to strategically distribute national resources, as information was not efficiently shared even within government departments.

### Successes and Outcomes

1. For the congress, it has become easier than ever to review budgeting and payment information for the different sub-ministries
2. The budget authority is also able to make accurate budgeting decisions, due to their increased ability to review financial statements of previous projects in detail. They are able to better predict each expenditure line item of a future project, by which means it can also systematically manage the financial risk of the project.

### Challenges

1. The government needs to assess new areas that can be linked to the system and reflect it in the system to continuously maintain the efficiency of the system.
2. Although the public participation rate has increased, it has shown that they have the tendency to remain as a passive user only making electronic payments and transfers. The public institutions will have to devise a way for them to become more active participants in the fiscal decision making process.

### Scalability

Some of the reasons for the success of the project are:

1. ‘The nationwide ICT infrastructure and high ICT literacy’ - ICT training is subsidised by governments (Gigler et al.). Korea achieved the world’s second largest broadband penetration in early 2000 thanks, in part, to the active role of government in promoting it and according to the ‘Ten Million People Internet Education Project’, South Korea has the highest internet user rate as a percentage of the population. Computer literacy is also a requirement of entering college in South Korea.
2. Web-participation is common in Korea, which provides most services over the Web. The approach may seem more alien and be less successful in countries where this is not the case.
3. The initiative is supported by both the private and public sector. The Korean government steered the project, with cutting edge ICT technology provided by Samsung and LG CNS - this approach can be explored in other countries.
4. D-Brain streamlines information exchange between central government, local government and public agencies, providing real time processing between agencies and facilitating payment collection.
5. People are interested in fiscal activities, as more efficient use of funds by the government is directly linked to lowering their taxation.

### Resources

Total cost: $63 million

<div class="pull-right"><a class="btn btn-default btn-mini" href="../chapter2-4">Next &raquo;</a></div>
