---
title: DataBC Open Data Portal of British Columbia
---

## DataBC Open Data Portal of British Columbia

<table class="iconmatrix">
    <tr class="icons">
        <th class="inner">Fiscal Scope</th>
        <th class="inner">Project Aims</th>
        <th>Technology</th>
    </tr>
    <tr class="iconbar">
        <td class="inner">
            <img src="../images/revenue.png" class="no" title="Revenue Side" />
            <img src="../images/spending.png" class="" title="Spending Side" />
            <img src="../images/invisible_money.png" class="no" title="Off-Budget" />
        </td>
        <td class="inner">
            <img src="../images/upload.png" class="" title="Publish Better Data" />
            <img src="../images/educate.png" class="no" title="Educate Citizens" />
            <img src="../images/citizen.png" class="no" title="Facilitate Direct Participation"/>
            <img src="../images/decision-maker.png" class="" title="Get Feedback to Policy Makers" />
            <img src="../images/data_analysis.png" class="no" title="Analyse and Understand Data" />
        </td>
        <td>
            <img src="../images/mobile.png" class="no" title="Mobile Technology" />
            <img src="../images/web.png" class="" title="Web-based Technology" />
            <img src="../images/offline.png" class="no" title="Offline and Print on Demand" />
            <img src="../images/piechart.png" class="no" title="Data Visualisation and Maps" />
            <img src="../images/standards.png" class="no" title="Formats and Standards" />
            <img src="../images/social_media.png" class="" title="Social Media" />
            <img src="../images/radio.png" class="no" title="Radio" />
        </td>
    </tr>
    <tr>
        <th class="inner">Country</th>
        <td colspan="2">Canada</td>
    </tr>
    <tr>
        <th class="inner">URL</th>
        <td colspan="2"><a href="http://www.data.gov.bc.ca/">www.data.gov.bc.ca</a></td>
    </tr>
</table>

<img alt="DataBC" src="http://farm8.staticflickr.com/7240/7272465600_0b9d7f60f5_o.png" class="screenshot" />

### Background
When the Province of British Columbia decided to launch the first Canadian provincial level data portal offering access to more than 2,500 datasets of local and province level data, it followed the need to address both the needs of the community and to transform and civil service system. With a large part of the workforce retiring, the accumulated knowledge and skills had to be transferred and new technology harnessed for realising three main aims:

1. Citizen participation and supporting a community around open data,
2. Data self-service - transforming the way government is present on the web and providing automated access to information
3. Business innovation - encouraging the use and re-use of data for fostering innovation through better information and certainly in government policy.


### Available Fiscal Data
revenue side of public finance, pre-budget statements (projected budget), data from quasi-fiscal activities, economic indicators, executive budget proposal, enacted budget, supplementary budget


### Overview of Features
The BC open data portal contains data across a broad spectrum of subjects; access to tools to visualise and analyse the data; and a blog with posts related to the data. The contextualisation of the original document is accomplished through the possibility to “follow” the document, tracing its progression, and the source document link is provided alongside the dataset. The contact form encourages users to ask questions, to enquire about more data when needed, as well as to provide general or specific feedback.


DataBC is also trying to balance between servicing the data and supporting the already existing open data community in British Columbia, from whom they received valuable feedback for the project. They are an active Twitter user with a growing number of followers. Organising hackathons also aids developers in using the data and creating data visualisations and apps which present different ideas and communicate messages around data.


### Standards, Licenses and Formats

Having used the example of the UK Government’s Open License for Public Sector Information, most of the BC data can be freely reused for commercial purposes, advocacy or personal use.

As the portal provides access to many different types of data, the underlying format and standards vary. There is a need to separate the final format from the file structure - e.g. it could be data in CSV format but the data could be poorly-structured. DataBC had to resolve problems related to the integration of the existing data management systems within the government as no mechanisms for data sharing existed previously.

### Successes and Outcomes

Probably one of the less-expected impacts was seeing how civil servants themselves are using the portal, as about one third of all the traffic originates from government IPs. Technology enables faster access to relevant data within the government departments, contributing to better interconnections between people working e.g. on labour policies and requiring fiscal data on income tax revenues and unemployment benefits. The most popular data turned out to be the financial data of the government, which signals the importance of transparent public finance based on the demand for information. There was also about 20% increase in the number of Freedom of Information (FOI) requests, showing that releasing a small amount of data fuelled wider interest in data.

<div class="well homework">
<strong> Transparency within government </strong>
Transparency is not just about allowing civil society access to information. Governments also need information transparency internally and civil servants often suffer from lag times in waiting for data from other departments. Probably one of the less-expected impacts of creating the BC data portal was seeing how civil servants themselves are using the portal: about one third of all the traffic originates from government IPs.
</div>

### Challenges

Probably the “Holy Grail question” of government data portals is how the data is being used and re-used and what value it generates. As there is no authentication for datasets download and privacy policies only allows the tracking of institutional use, it is difficult to know where the data goes and how it is being used.

It was difficult to switch from a closed system in which data publication was produced in closed formats such as PDFs to one in which the importance of data management, useful metadata etc., is prioritised. Those working on the project experienced an asymmetry in the readiness of various departments to open up their data, for example, those in geospatial data already had much experience with opening up their data, whereas to those in finance, it was the first time that they had been asked to think about their data as ‘open data’ and progress was slower. For DataBC the project was not a compliance exercise, but an attempt to integrate governance, policy-making and citizen participation.

### Project Resources (approximate):

<table border="1" padding="1em">
    <tr>
        <td><strong>Phase,</strong></td>
        <td><strong>Duration</strong></td>
        <td><strong>Full-time human resources</strong></td>
    </tr>
    <tr>
        <td>Planning and data-collection</td>
        <td>3 months</td>
        <td>3</td>
    </tr>
    <tr>
        <td>Design and implementation</td>
        <td>2 months</td>
        <td>12-20</td>
    </tr>
    <tr>
        <td>Ongoing</td>
        <td>Since July 2011</td>
        <td>8</td>
    </tr>
</table>

### User comments and feedback:

#### Herb Lainchbury, open systems developer:

> “The main things I would like to see are:

> * more raw data - right now in DataBC we see a lot of small aggregated data tables which are not all that useful,
> * more interesting data - there are easy ways to tell what data is interesting but so far BC is not releasing much of it [...]
> * license - I would also like to see them use a license that conforms to the open definition...”

<p style="text-align: right">Thanks for input from David Wrate, DataBC</p>

<div class="pull-right"><a class="btn btn-default btn-mini" href="../chapter2-3">Next &raquo;</a></div>
