---
title: Introductions
---

## Chapter 1: Introductions and Methodology

### Introduction

This report, “Technology for Transparent and Accountable Public Finance”, was commissioned by the Global Initiative for Fiscal Transparency (GIFT) in February 2012 in order to assist the GIFT in assessing the potential of technology to aid transparency and accountability in relation to governments’ fiscal activities. 

This reports provides examples of projects around the world that are using technology (web, mobile or otherwise) to further aims of fiscal transparency. We focused on projects which: 

* Publish more or better data related to fiscal processes (aid, revenues, budgets, audits, etc. — see below), 
* Help understand this data through the creation of better visualisation and data analysis tools, 
* Educate citizens about fiscal processes, and assist civil society organisations in promoting accountable governance, 
* Facilitate direct participation in fiscal matters through participatory budgeting, citizen auditing, etc.,
* Provide policymakers with complete and reliable data relevant to their work, enabling them to make better decisions. 

We have sought to find projects which reflect all stages of the fiscal process: 

* Looking at [where the money comes from](../chapter5-intro): both getting more data released and building analysis and visualisation tools in the context of revenue processes e.g. taxation, extractive industries, etc., [c]
* Monitoring [where the money goes](../chapter6-intro): presenting data about the budgeting process and getting citizens involved in fiscal processes e.g. through participatory budgeting and comparisons of planned and retrospective budgets,
* [The invisible money](../chapter7-intro): improving public understanding of state-owned or semi-state owned enterprises, off-budget information and social audit projects which verify whether official money is being concealed or is not being spent according to official plans – information which often is not published as part of current budgeting practices.

In each case, we considered questions such as:

* Who are the users and audiences of the project?
* What are their motivations and what skills are required?
* What are the successes, failures and limitations?

For each project, we have highlighted strengths and weaknesses based both on our own experience of developing tools, and also by seeking feedback from civil society organisations and the technical community. This report also aims to highlight the gaps: In some instances, cutting-edge technology is being used in fields besides public finance, which may merit further exploration; in other cases, we highlight points in the budgeting cycle which are currently underserved by technical tools.

### Methodology:

We have selected case studies that are appropriate across:

* Different levels of literacy and access to technology
* Different budgets
* Government-led, civil society led and citizen led initiatives

The research was a combination of qualitative interviews and direct inputs from case study representatives through online questionnaires. 

### Overview of Projects

![Project Overview](http://farm8.staticflickr.com/7237/7273947644_4799a7e720_o.png)

<div class="pull-right"><a class="btn btn-default btn-mini" href="../chapter1-2">Next &raquo;</a></div>