---
title: Highlights, Gaps & Recommendations
---

## Highlights, Gaps and Recommendations


> “There’s a really interesting dynamic interaction between work on data availability and quality, and on building tools, visualisations etc. that work with it. Without good data it’s hard to use it for transparency and accountability, and to build good tools. But without tools to start using the data, it’s hard to discover where it needs to improve.”

> <small>Tim Davies - Practical Participation</small>

In this section, we summarise the key highlights from the various sections of the report. The highlights are arranged by section of the report and followed by a few notes on the ‘gaps’: areas which, in our opinion, merit further investigation or have thus far lacked resources or coordination to make happen. Each section concludes with ‘recommendations’: We have tried to stagger these suggestions, ranging from first steps, easily obtainable goals which are likely to be feasible in the short term, to ideal scenarios, desirable end goals, which will take more commitment and longer term planning.

### Data Portals

In [this section](../chapter2-intro) we examine four government data portals from across the globe. The aim is to highlight government perspectives of making fiscal data available to the public. We focus on motivations for creating the service in the first instance, what features and data are offered, successes and outcomes, challenges and areas for improvement and what resources are needed to assemble and maintain such a site.

#### Highlights

* Data portals help address a fundamental requirement to make data accessible and discoverable once it has been made available: If data is spread across hundreds of websites and is difficult for people or machines to find, much of its value will be lost.
* The reason many government catalogues are link sites rather than data stores is often political, not just technical: Departments want to remain in charge of their data. Local departments often have to be encouraged to give up their data and be persuaded of the value of holding data centralised resource.
* Data portals can be useful both within and outside of government. Lack of information sharing affects civil servants and policy-makers -- not just those outside of government. This was highlighted in the OpenDataBC case study, where approximately one third of traffic to the citizen-facing data portal came from IP addresses within government.
* Keep it simple: A portal can be very simple initially and developed in response to user and government demands. Moreover, today exist off-the-shelf open-source solutions: Governments are increasingly learning the benefits of open-source solutions, (flexibility, adaptability, auditability etc.) but further work needs to be done to [encourage more widespread adoption](http://open-source.gbdirect.co.uk/migration/benefit.html
).
* An explicit open data policy is not needed to start an open data portal: One can begin with datasets that are already open or which are “voluntarily” donated by departments. In the UK’s case the portal preceded, and helped catalyse, development of a formal open data policy.
* Data portals could become of the most important technological tools of the government with regard to public spending monitoring and control.


#### Gaps

* Greater promotion of open-source tools for open data
* More explicit opportunities for citizen participation. Some projects highlight good examples of how participation can fit within existing government workflows. See participation section for more, largely civil-society driven projects, which may provide inspiration - or source code - for some government-led initiatives promoting direct participation.

#### Recommendations

<div class="well homework">
    <strong>GIFT Actions: Promoting Open Data as the Raw Fuel for Technology</strong>
    <br></br>
    <ul>
        <li>Members of GIFT should themselves ensure - whether they are national governments or international organisations - that they publish their fiscal and other financial information in full and in machine-readable formats.</li>
        <li>Promote publication of key budget information as machine-readable data. Work with organisations such as the International Budget Partnership to include a related criterion in the Open Budget Survey. Set up online webinars / workshops showing how data is used after its publication.</li> 
        <li>GIFT should initiate the creation of a light-weight, demand-driven standard for the release of structured expenditure information to enable its comparability between countries.</li>
        <li>Work closely with the Open Government Partnership to promote release of datasets which are key to contextualising financial data, such as economic indicators or procurement data.</li>
        <li>Promote the release of sub-national data, perhaps via local partners, as well as national level.</li>
    </ul>
</div>

**First Steps**

* Fiscal data must be openly licensed and available in machine readable format in bulk. Be strict about licensing: make sure that all datasets on the portal are released under a proper [open license](http://OpenDefinition.org/).
* Engage with your user community both within and outside government. What data do they want, in what form? How can they report issues effectively and easily? Have explicit and prominent contact links so that citizens can report issues. Even better, allow them to browse past issues or see the clarification which others have received in answer to other questions e.g. through online discussion forums.
* Engage with your provider community: civil servants and others working inside government who will be publishing data using the site. What can be done to make this process as easy and rewarding as possible?
* Be timely: particularly for financial information, having current data is key to enabling re-use with an impact.
* Open tools for open data: use free and open-source tools wherever possible.

**Next Steps**

* Monitor data release, quality and usage and reporting this to relevant decision-makers becomes increasingly important as the project matures.


### Finding and Using Data

In [this section](../chapter3-intro) we asked the open spending data community - who come from a variety of backgrounds; research, technical, media etc., what fiscal data they require, what they want to do with it, and importantly, how easy it is to obtain and use. Through a series of structured surveys, we established the following:

#### Highlights

* Fiscal transparency is about more than budgets: Users will often require more than just basic budget information to hold governments to account. Fiscal transparency should therefore not be limited to making these key budget documents accessible. Company and procurement data are common requests, as are audit reports and sub-national budget information.
* We received responses to the questionnaire from eighteen countries, spread around the globe. Six respondents mentioned that they used a government transparency portal to get their data, three used FOI requests, seven collected the data themselves from various sources and two said they had not been able to acquire the data.
* ‘The current status of open data’: Feedback was mixed. Some respondents praised the ease with which they acquired the data, but in the majority of cases, it was not easy to use the data that they had obtained. Barriers included:
* Machine readability: The most common complaint was non machine-readability of data - usually the complaint was about PDFs.
* Poor quality: Frequently there are problems with the data such as lack of care for the process of creating the data, poor structure, too aggregated and inconsistencies in structures between years.
* Disappearing data or hidden data: Several users mentioned that historic data disappeared from government websites and two could not get access to the data because of paywalls. A couple of more technical users of the data said an API for the data would be useful.
* There is often a lack of supporting documentation to complement data releases, meaning that users cannot find out what is actually contained within a dataset.

#### Gaps

* Machine-readable data
* Data-management systems which ensure good-quality, consistent data
* Preservation of historical data

#### Recommendations

<div class="well homework">
    <strong>GIFT Actions: Technology Outreach and Idea Sharing</strong>
    <br></br>
    <ul><li>Promote experience sharing between governments through workshops and forums in existing social media platforms. Governments need to share the lessons learned in using technology to promote transparency, accountability and participation across different countries.</li>
        <li>Involve civil society actors who use data and services provided by governments, to review and share ideas about existing and planned initiatives. Such actors could form advisory-panels on particular topics e.g. company data.</li>
        <li>Create a well-maintained index of existing initiatives both an the demand and supply side, including methods of data release, re-use and presentation, discussion or activism enabled by such information.</li>
        </ul>
</div>

**First Steps**

* Make data available in a machine-readable, fully disaggregated form
* Provide some adequate basic information about the released data

**Next steps**

* Provide of machine-readable forms of important datasets such as companies registries, contract awards and underlying tender specifications
* Provide structured, machine-readable information on budgeting process, e.g. important dates (publication dates, points in the process where feedback is possible), amendments and information on “who does what” in budgeting issues
* Provide comprehensive documentation to accompany the documents i.e. read-me files explaining what a given dataset, data-dictionaries, glossaries
* Capacity-building, connecting policy and data processing/analysis expertise
* Promote data sharing of intermediate results e.g. integrated datasets produced by researchers, journalists, advocacy organisations and developers and the creation of data commons for processed output of re-use applications

**Ideal scenario**

* Open-source tools used within government for production and consumption of data
* Long-term archives of data on “neutral ground” i.e. not run by states nor advocacy groups, something like the Internet Archive for data
* Integration of budget, procurement, companies and contracts, metrics/evaluation and spending information.
* Real-time access to data via an API: Note that this is not relevant in all cases, e.g. for budget information that only changes once per year.


### Standards for Fiscal Data

[This section](../chapter4-intro) examined whether having standards for fiscal data could provide a solution to some of the usability issues described by the users of the data in the previous section, by looking at two internationally recognised standards, IATI and XBRL.

#### Highlights

* Standards enable a distributed rather than a centralised approach in data publication and use. No or very limited general fiscal data standards are currently in existence and in use.
* XBRL is establishing itself as a worldwide standard for accounting information and may grow into a standard for general ledger data. It is however complex and focused on the traditional accounting domain - especially around balance sheets - which may limit its relevance and benefits as a format for transparency purposes.

#### Gaps

* A standard for transaction level spending data.
* Lack of widely-adopted standards for entity identifiers, which would greatly facilitate merging and matching
* Tools to merge and annotate the data
* Training and quality assurance (validation) tools


#### Recommendations

<div class="well homework">
    <strong>GIFT Actions: Technology Review</strong>
    <br></br>
    <ul><li>Review existing projects and and solutions from the point of view of both governments and civil society actors. <a href="http://civiccommons.org/apps">Civic Commons Marketplace</a> as well as the <a href="http://bit.ly/TTAPF-projects">appendix</a>, but a larger-scale, community effort will be required to keep this up to date.</li>
        <li>Based on feedback from the above refine and maintain an online, collaborative catalogue of technical and policy options (perhaps as a wiki) which can guide governments about existing solutions and experiences. 
        </li></ul>
</div>

**First Steps**

* Use well-known, commonly used formats such as CSV, XLS or XML for the release of data.
* Adopt existing coding conventions for shared entities, such as countries e.g. ISO-3166 and EU NUTS codes. Publish information on the identifiers used for companies and make sure they are not entangled in IP e.g. DUNS numbers or behind a paywall.
* Publish additional information on the coding schemes used, such as functional or economic classifications, charts of account.

**Next Steps**

* Enter standardisation process, beginning with core taxonomies. Additional work on aligning ‘spines’ of data e.g. mapping IATI data onto COFOG compliant budgets.
* Geocode data using re-usable, openly licensed coding services to avoid inclusion of proprietary IP.
* Begin using globally unique URIs for companies and other organisations, government bodies, and projects.
* Critically evaluate the options for re-using IATI or XBRL formats rather than creating new standards specifically for transaction level spending data. Explore options for format convertibility.

**Ideal Scenario**

* A global spending data registry which lists spending data from around the world in a standard format - similar to the IATI registry for aid information.


### Where Does the Money Come From? Where Does the Money Go? and The Invisible Money

#### Highlights: Tools for Data

* Civil society is often cited as the target users for transparency portals, as was the case for the Sierra Leone Mining Repository. However, in reality, 65 % of the users of this platform are investors, donors and other governments, who have knowledge of complex legal terminology and sector-specifics. The level of technical knowledge required to understand this data means that similar audiences may be the main user groups for other such tools.
* Design of tools for end-users are most effective when they bear in mind less-web-savvy users or users who will have to work in lower bandwidth or with older computers. Options such as saving and printing user-generated reports could be very useful for these purposes.
* “Data is not always actionable simply because it is available.” Having the possibility to download the data does not guarantee that one would be able to use it or understand its structure and source.
* Open source tools allow rapid dissemination of approaches and the adaptation of tools to different contexts internationally. For example, the visualizations from OpenSpending have been widely and independently re-used (e.g. to power the Hungarian site [“A mi Penzünk”](http://amipenzunk.hu/) and the Czech site [BudováníStátu.cz](http://budovanistatu.cz/)).
* Information to hold individual politicians personally accountable for their financial choices is highly desirable, particularly for journalists, and could have a great impact, particularly in situations where individual politicians wield choice over discretionary funds.

#### Highlights: Participation

* Technology can add additional channels for participation to reach out to people who might otherwise be hard to reach, or make it easier for those who already do participate. Yet technology is not a substitute for face-to-face contact.
* Technology is not a fix-all. If a tool is to be successful, it will most likely target a specific aspect of the Participatory Budgeting-cycle. A strategy can target a particular part of the PB process rather than being a super-app that will work at every stage.
* Conversations should be tightly facilitated in the idea collection and deliberation phases to ensure that the conversation remains structured and duplicate or irrelevant ideas do not distort its clarity. Governments should also ensure that they have the response capacity to be able to deal with the potentially large amounts of feedback, which could ensue before implementing a technical solution to idea collection.

#### Highlights: Social Auditing

* Social audits using technology offer a possibility of close to real-time feedback and reporting.
* Technology, e.g. mobile, can help transform traditional labour-intensive social auditing practices, which gives a possibility to scale-up corruption monitoring.
* SMS technology has the possibility of reaching out to rural areas with limited Internet access.
* Many of the projects featured in this section rely on sub-national level data to function: It is at local and regional level that many of the services from which citizens benefit most tangibly  are delivered e.g. infrastructure, healthcare, schooling.
* Another type of data, which could be key for stimulating citizen feedback on an individual level, is data on personal entitlements, which might motivate citizens to provide feedback on whether they received their personal allowance.

#### Gaps

* Raw, machine-readable data is vital.  Having to extract structured data from unstructured documents (e.g. PDFs and Word documents) prior to use creates work, could introduce errors (e.g. from manual transcription) and can lead to supply-side data-quality issues, e.g. if the government faces bad data management practices.
* Very few projects are currently able to trace the difference between planned and actual expenditure. Sunlight’s work in the United States is one of the few examples of success in this area.
* Good, open-source tools for doing entity matching and extraction
* Sub-national level spending data
* Data on citizens’ personal entitlements

#### Recommendations

<div class="well homework">
    <strong>GIFT Actions: Technology Sharing</strong>
    <br></br>
    <ul>
        <li>Promote the use of promising projects from the Technology Review stage. Liaise with funding bodies to ensure open-source solutions are available for all. </li>
    </ul>
</div>  
        
**First Steps**

* Build public-facing tools, targeted at enabling expert oversight, e.g. by investors and other governments, who have both incentives to scrutinise this data and pre-existing knowledge to enable them to do so.
* Promote use of these tools  to infomediaries, who perform the role of translating complex information for the benefit of the public
* Related datasets: Fiscal data is most useful when related core datasets (e.g. reference identifiers, geospatial information) are  also available
* More and better data: Access to good quality sub-national transaction-level data on expenditure; access to data on personal entitlements

**Next Steps**

* Contextualise the data in a way that is suitable for a layman audience - how was it generated? What is and is not covered?
* Build tools using the data that has been released as part of the ‘first steps’, in order to allow greater understanding of information for a layman audience. For example, citable, pre-computed statistics (as long as the methodology behind generating them is clear), which have been generated by experts are extremely attractive for those looking to use them in reports and for the press.
* Closer collaboration between advocacy NGOs and journalists.

**Ideal Scenario**

* Finishing off the great work done so far in this area in compiling country-level reports into one place and building a sortable online database.
* Extensive capacity-building for journalists to enable them to analyze and present data.
* Social Audit Portals similar to Andhra Pradesh with near real-time access to financial data.

<div class="pull-right"><a class="btn btn-default btn-mini" href="../chapter1-4">Next &raquo;</a></div>
