---
title: How Transparent is the EU Budget?
---

Overall Fiscal Transparency
---------------------------

Most of the data and documentation for the budget process and its implementation are available online. The Cohesion Policy even has its own [open data website](https://cohesiondata.ec.europa.eu) offering aggregated budget data. However, there is not a unique and primary access point where all budget documents and data are centralised or federated in as standardised way. Being able to obtain a joined-up picture of EU public finances is essential for democratic accountability. For example, journalists collaborating around the EU Farm subsidy project were initially unable to determine the total agricultural subsidies going to large multi-national corporations from the EU, as the data sources were scattered across hundreds of different local, regional and national government websites, in different formats and the European Commission denied an access for documents request for the centralised dataset.[^ftnt21]

Indeed, even though the Commission has [a central budget section](http://ec.europa.eu/budget/index_en.cfm) on its website, this report has evidenced that is was necessary to consult many websites or webpages not referenced under the Commission website in order to understand the basic principles related to the EU budget functioning and to collect related figures.

There are also some inconsistencies between the terms and figures published in the budget documents from different EU institutions websites.[^ftnt22] As a result, accessing, analysing and understanding the whole EU Budget is a complex task which hampers EU Budget transparency.

One of the main issues is the missing link between the two major EU budgetary instruments (the  seven years framework and the annual budget regulation) and the funds themselves. The funds set up by the multiannual framework and the budget are implemented, directly or not, by the Directorate-Generals and Agencies of the Commission, and specific information related to these funds is therefore to be found on their respective websites. But the information and data they provide are not presented in a harmonised way, making it difficult and extremely burdensome to gather the same level of information for each of the funds. 

In addition, whereas the Commission provides a unique website to link the beneficiaries of its spending under centralised direct management (the FTS), there is no such system for the vast majority of funds spent under shared management.[^ftnt23] Diversity of languages for the different websites of the Member States also adds complexity to find and analyse the information on beneficiaries. The lack of distinction from EU and other co-funding for a project is also an issue. Lastly, datasets on beneficiaries do not use a unique European identifier for legal entities. This  hampers the capacity of investigation and other data analysis across Europe.[^ftnt24]

Transparency Regulations
------------------------

According to Article 15 of the TFUE, *“the Union’s institutions , bodies, offices and agencies shall conduct their work as openly as possible. (...) Any citizen of the Union, and any natural or legal person residing or having its registered office in a Member State, shall have a right to access to documents of the Union’s institutions, bodies, offices and agencies, whatever their medium, subject to the principles and conditions to be defined in accordance with this paragraph”*.

To implement this principle of transparency, specific obligations were defined in successive legal instruments called “Financial regulations”. The last financial regulation, adopted in 2012, established an obligation of publication of accounts, budgets and reports through means such as the Official Journal of the European Union. There is also an obligation of publication of information on recipients of EU funds. It is stated in the financial regulation that *“where natural persons are concerned, the publication shall be limited to the name and locality of the recipient, the amount awarded and the purpose of the award”*.[^ftnt25]

Therefore, this principle of transparency is not an absolute one, as it is the subject of *“principles and conditions”*. This was evidenced in 2010, when the Court of Justice of the European Union delivered [a judgment](http://curia.europa.eu/juris/document/document.jsf;jsessionid=9ea7d0f130de9fa4dec2274b4c12a176e3a592620a2c.e34KaxiLc3eQc40LaxqMbN4ObxaSe0?text=&docid=79001&pageIndex=0&doclang=en&mode=lst&dir=&occ=first&part=1&cid=583202) in which it rules that publishing personal data on the beneficiaries of funds deriving from the two financial pillars of the CAP was not proportionate when it comes to natural persons who are the beneficiaries of these funds. As a consequence, for a two-years period, the obligation to publish information on the beneficiaries of CAP payments was limited to **only** legal persons. In 2013, [a new regulation](http://eur-lex.europa.eu/legal-content/EN/TXT/HTML/?uri=CELEX:32013R1306&from=en) was adopted, which re-established the obligation to publish information on the beneficiaries of CAP payments, except when it comes to small amounts of money received by natural persons (per default less than €1250 received in one year).[^ftnt26] 

The 2010 ruling of the Court certainly influenced the drafting of the 2012 financial regulations. In [the Commission Delegated regulation of 29 October 2012](http://eur-lex.europa.eu/legal-content/EN/TXT/HTML/?uri=OJ:L:2012:362:FULL&from=EN), it is stated that *“as far as personal data referring to natural persons are concerned, the information published shall be removed two years after the end of the financial year in which the funds were awarded. The same shall apply to personal data referring to legal persons for whom the official title identifies one or more natural persons”*. This limitation is applicable to recipients of EU funds awarded under direct and indirect management.

For each sector or fund, more specific and detailed rules can be adopted. For example, for the 5 ESIF, [the Common Provisions regulation](http://eur-lex.europa.eu/legal-content/EN/TXT/PDF/?uri=CELEX:32013R1303&:PDF)states that: *“Member States or managing authorities shall, in order to ensure transparency concerning support from the  Funds, maintain a list of operations by operational programme and by fund in a spreadsheet data format, which allows data to be sorted, searched, extracted, compared and easily published on the internet, for instance in CSV or XML format. The list of operations shall be accessible through the single website or the single website portal providing a list and summary of all operational programmes in that Member State. (...) The list of operations shall be updated at least every six months”.*

****

Beneficiaries of EU Funds

To find information on the beneficiaries of EU funds, it is necessary to look at the type of management involved, as this has a direct implication on the place where the data will be found and on which authority (the EU itself, the Member States, etc.) will manage the publication of this data.

****

**Centralised Direct Management**

For funds awarded under centralised direct management, the financial regulation provides that the information on the beneficiary shall be published on an internet site of the EU institutions. Information shall contain the name of the recipient; the locality of the recipient; the amount awarded; the nature and purpose of the measure.

Some rules and exceptions apply as regard to data privacy. Any information identifying a natural person shall be removed two years after the end of the financial year in which the funds were awarded, and the following information should not be released:

-   Public procurement contracts worth under a certain amount (currently €15000);
-   Scholarships or other direct support paid to natural person.

In order to comply with the financial regulation, the European Commission has set up the [Financial Transparency System (FTS)](http://ec.europa.eu/budget/fts/index_en.htm). In this public database are included data on beneficiaries of EU funds from 2007 onwards, as well as data on beneficiaries of the European Development Fund (EDF) from 2010 onwards. The financial information contained in the FTS is expressed in commitments and not in payments - it corresponds to the amounts awarded (“committed”) to beneficiaries in a given year. The data is updated at least in June the year following the financial year concerned. For example, data on the year 2014 will be published in June 2015.

**Centralised Indirect Management**

****

When the management of the fund is delegated to an executive, decentralised or national agency (indirect management), it is the responsibility of this authority to publish beneficiaries data on its website. In case the information is not published directly, the website of the authority should at least contain a link to the website where the information can be found.

The same rules apply to the publication of data on beneficiaries under centralised direct and indirect management.

****

**Shared Management**

For information on beneficiaries under shared management, it the responsibility of Member States to make the data publicly available.

For the 5 ESIF and according to [the Common Provisions regulation](http://eur-lex.europa.eu/legal-content/EN/TXT/?uri=celex:32013R1303), Member States must publish data on the name of the beneficiaries, the activity and the amount of public funding allocated. For these funds and the European Agricultural Guarantee Fund, the European Commission provides on its own website links to the websites of Member States with information of beneficiaries under shared management. This concerns beneficiaries of:

-   [the Common Agricultural Policy](http://ec.europa.eu/agriculture/cap-funding/beneficiaries/shared/index_en.htm);
-   [the European Regional Development Fund and the Cohesion Fund](http://ec.europa.eu/regional_policy/index.cfm/en/atlas/beneficiaries/?lan=en);
-   [the European Social Fund](http://ec.europa.eu/esf/main.jsp?catId=46&langId=en&list=0);
-   [the European Maritime and Fisheries Fund](http://ec.europa.eu/fisheries/contracts_and_funding/the_european_transparency_initiative/index_en.htm). 

**Development and Humanitarian Aid to Non-EU Countries**

****

Data is published directly by the European Commission on:

-   Agreements and contracts signed in the field of humanitarian aid during the year concerned, whether financed under the EU budget or the European Development Fund (for ACP countries only): [http://ec.europa.eu/echo/node/2190](http://ec.europa.eu/echo/node/2190);
-   The beneficiaries of grants and contracts awarded by EuropeAid in the field of development and cooperation: [http://ec.europa.eu/europeaid/work/funding/beneficiaries](http://ec.europa.eu/europeaid/work/funding/beneficiaries). 

* * * * *

- [Return to Beginning](../)
- [Prev: Where Does the Money Go?](../funds/)
- [Next: Journalistic Investigations and Transparency Projects to Follow the Money](../research/)

{% include_relative footnotes.md %}
