---
title: Where Does the Money Come From?
---

The sources of the EU revenue are called the EU’s “own resources”. A Council Decision on Own Resources, setting up the rules applying to their calculation, is usually negotiated at the same time as the MFF regulation. Resources are then provided on an annual basis.

The difference with the MFF regulation is that the Council Decision has to be approved by all the Member States before it comes into force - usually through a vote in national parliaments. This explains why, as of April 2015, the Council Decision on the EU’s own resources dates back from 2007[^ftnt11] and continues to apply until the new Council Decision, adopted in May 2014 by the Council, comes into force.[^ftnt12] When the 2014 Decision will be approved by all the Member States, it will apply retroactively as of 1 January 2014.

The EU’s own resources are divided into several categories:

-   **C****ustoms duties on EU imports**: they arise from the application of the common customs tariffs and are collected on imports from third countries at the external borders of the EU.
-   **A****gricultural duties and sugar levies**: they consist mainly of customs duties on imports from non-EU countries of agricultural products subject to the common organisation of the markets and levies on sugar, isoglucose and insulin syrup.

Customs duties, agricultural duties and sugar levies are also referred as the **EU “traditional” own resources**.

-   **The VAT-based own resources:** these are national contributions based on harmonised VAT bases for Member States.
-   **The GNI-based own resources:** this revenue is based on an uniform call rate applied to the Gross National Income (GNI) of each Member State.
-   **Other revenues:**it includes taxes on EU staff; contributions from non-Member States and fines imposed on companies.

The collection of revenues does not apply uniformly to all EU Member States, as rather *ad-hoc* **correction mechanisms** also exist. The three main correction mechanisms are:

-   **The UK rebate**: the UK is reimbursed a percentage of the difference between its contribution and what it receives back from the EU budget (as of today, 66% of the difference). To compensate this loss, all other Member States have to make an additional contribution to the budget in proportion to the share they contribute to the EU’s GNI. Although controversial, the UK rebate has been maintained by the 2014 Council Decision on the EU own resources;
-   **Lump-sum payments**: some countries (Denmark, the Netherlands and Sweden) benefit from gross reductions in their annual GNI contributions;
-   **Reduced VAT call rates**for Germany, the Netherlands and Sweden.[^ftnt13]

As previously noted, the European Development Fund is not concerned by these rules, as it is financed directly by the Member States and has its own financial regulations.[^ftnt14]

* * * * *

**Figure 2: EU own resources contribution per Member States (Budget 2013)**

Source of the data: [European Commission](http://ec.europa.eu/budget/figures/interactive/index_en.cfm) - Made with raw.densitydesign.org![](../img/image06.png)![](images/image06.png)

* * * * *

- [Return to Beginning](../)
- [Prev: How is the EU Budget Set Up?](../budget/)
- [Next: Who Manages and Spends the Money, and How?](../expenditure/)

{% include_relative footnotes.md %}
