---
title: Journalistic Investigations and Transparency Projects to Follow the Money
---

There is a growing network of investigative journalists in Europe, supported by initiatives such as the JournalismFund.eu, who are acquiring skills to work on complex data projects. In parallel, a number of data-savvy analysts, activists and developers, are supporting investigations efforts by extracting (scraping), gathering and releasing EU budget data in a more useful way and developing dedicated tools and platforms. Those practices are often described as data journalism.[^ftnt27] Investigations can also be conducted or initiated by EU public authorities which have the mandate to control the EU Budget. The following sections present a brief and illustrative overview of a selection of recent work.[^ftnt28]

Investigations into EU Funds
----------------------------

**EUobserver**

The EUobserver is a non-profit independent online newspaper established in Brussels. It regularly covers [EU funds attribution, fraud and misuses](https://euobserver.com/search?q=EU+funds). In 2013, the EUobserver investigated [EU funds attribution to regions](https://euobserver.com/regions/119867). The result was that the poorer and more mismanaged a region was, the less it was profiting from EU funds, therefore raising the point that there is a relationship between administrative capacity and good and effective use of funds.

**EU Transparency**

EU Transparency is a non-profit organisation based in the UK and working to improve transparency of the European Institutions. EU transparency was behind the project FishSubsidy (see next section) and host of the Farmsubsidy.org project for some years.

**European Research Centre for Anti-Corruption and State-Building**

The European Research Centre for Anti-Corruption and State-Building (ERCAS) is an academic research center located at the [Hertie School of Governance](http://www.hertie-school.org/) in Berlin, Germany.** **ERCAS** **has** **notably established the [anti-corruption project database](http://www.againstcorruption.eu/?post_type=projects), where anti-corruption initiatives are documented and promoted through a database of projects, impact analysis and diagnosis reports. ERCAS also investigates itself EU funds abuse and [conducted a project in Bulgaria](http://www.againstcorruption.eu/projects/effective-investigation-of-european-union-funds-abuse-in-bulgaria/).

**Financial Times**

The online version of the Financial Times has [a dedicated section](http://www.ft.com/intl/topics/themes/EU_Structural_Funds) on investigations and articles on the EU Structural Funds where it reports about EU funds management issues, frauds and funds misuse. The last article raised the issue of UK local councils, London excepted, not being allowed to independently manage their share of the ESIF funds. The Financial Times has also worked with the Bureau of Investigative Journalism to make EU Structural Funds more public. (see The Bureau of Investigative Journalism and data project description in next section).

**JournalismFund.eu**

The [JournalismFund.eu](http://journalismfund.eu/) was founded in 2008 on the model of the [Belgian Pascal Decroos Fund](http://www.fondspascaldecroos.org/en) and is the only European fund providing working grants for journalism investigation across the EU. The fund also supports the [Dataharvest - European Investigative Journalism Conference](http://www.journalismfund.eu/dataharvest-conferences) which has become the main annual conference for journalists to share best practices and story ideas related to EU data. 

**The Bureau of Investigative Journalism**

The Bureau of Investigative Journalism (TBIJ) is a non-for-profit news organisation based in London. It has worked with the Financial Times on the [EuFunds project](https://www.thebureauinvestigates.com/category/projects/eu-structural-funds/) to investigate EU Structural Funds. One of the main findings from that investigation is that [only 5% (54) of 1046 leaks](https://www.thebureauinvestigates.com/2012/07/07/eu-member-states-fail-to-report-corruption-but-bureau-investigation-hits-home/) relating to corruption in 2011 came from Member States authorities, raising concerns over the shared management of EU funds.

**The International Consortium of Investigative Journalists**

[The International Consortium of Investigative Journalists (ICIJ)](http://www.icij.org/) is a global network of about 200 investigative journalists who collaborate on investigative stories across the globe. The ICIJ was launched as a project of the Center for Public Integrity. In 2012, the ICIJ published *“*[Looting the seas II](http://www.icij.org/projects/looting-seas-ii)*”*, an in-depth investigation into EU subsidies supporting Spanish fisheries. The investigation evidences that *"decades of overfishing have left Europe’s fish stocks in peril and its fishermen in poverty. It’s an impasse paid for by EU taxpayers."* Among the key findings, it has been found that one Spanish ship owner received more than €8.2 million in subsidies even while his company or its affiliates faced more than 40 accusations of illegal fishing and US\$5 million in fines.[^ftnt29] ICIJ used various data sources for its investigation, including data from FishSubsidy.org (see section below) but also had to requests additional information to the EU and the national and regional governments in Spain.[^ftnt30]

**Transparency International EU Office**

As part of the global Transparency International, the Transparency International EU Office (TI-EU) focuses on EU advocacy. It promotes accountability, transparency and integrity at the EU level. TI-EU recognised that the shared management system of a large number of EU funds makes it very difficult to access data, and is therefore [calling](http://www.transparencyinternational.eu/focus_areas/eu-budget/) for all EU funds to be available on a single, citizen-friendly website.

Investigations can also be conducted or initiated at the EU level by dedicated authorities.

**European Anti-Fraud Office (OLAF)**

[OLAF](http://ec.europa.eu/anti_fraud/index_en.htm)is  charged by the [E](http://en.wikipedia.org/wiki/European_Union)U of the protection of the financial interests of the EU budget. It investigates fraud, corruption and serious misconduct within the European institutions, and develops an anti-fraud policy for the European Commission. OLAF's mandate covers all EU expenditures and it cooperates with national authorities for funds under shared management. OLAF publishes an annual report containing statistics on fraud and examples of cases investigated. According to [the 2013 repor](http://ec.europa.eu/anti_fraud/about-us/reports/olaf-report/index_en.htm)t, the main amounts of fraud were in structural funds (€111.7 million), external aid (€100.4 million), customs and trade (€84.9 million), new financial instruments (€66.3 million) and agricultural funds (€34.4 million).

**European Ombudsman**

The [Ombudsman](http://www.ombudsman.europa.eu/atyourservice/whocanhelpyou.faces#/page/4) is an independent watchdog with the power to investigate EU institutions. It regularly conducts investigation into EU funds. For instance, on 21 May 2014, the European Ombudsman has launched [an investigation](http://www.ombudsman.europa.eu/en/press/release.faces/en/54420/html.bookmark)on the EU [Cohesion Policy](http://ec.europa.eu/regional_policy/what/future/index_en.cfm), following concerns that substantial funding is being used to breach the fundamental rights of EU citizens with disabilities.

**The European Court of Auditors**

[The European Court of Auditors](http://www.eca.europa.eu/) is the independent external auditor of the EU institutions. Its role is to check that EU funds are correctly and efficiently managed and raised and spent in accordance with the relevant rules and regulations. In particular, the court checks if projects funded through direct and shared management are in line with EU priorities.

**Project ARACHNE** 

[ARACHNE](http://admin.interact-eu.net/downloads/7857/Presentation_) is a project from the European Commission which aims at providing Member State authorities involved in the management of the structural funds with an operational tool to identify potentially risky projects. The application collects and process data from Members States EU-funded projects, together with financial data on companies (data retrieved from [ORBIS](http://www.bvdinfo.com/en-gb/our-products/company-information/international-products/orbis?gclid=CPq2-d_am8UCFeoSwwodZVcACg)), compliance data such as list of fraudsters (data from [World Compliance, Lexis Nexis](http://www.lexisnexis.com/risk/intl/en/)) and web mining data from news articles (data retrieved from [Moreover](http://www.moreover.com/)). The project managed by DG EMPL is already in operation Bulgaria, Czech Republic, Hungary, Poland, Portugal, Romania and Slovakia. The tool's dashboard is available to Member States authorities and the Commission. However, there are as yet no plans to make the data publicly available.

Tools for EU Funds Data Investigation
-------------------------------------

**AsktheEU.org**

Ask the EU is a portal managed by [Access Info Europe](http://www.access-info.org/)  which assists any citizen requesting an information from the EU institutions under the access to information right. The portal makes every request and response publicly available online, allowing for an analysis of information request on EU budget and spending. For example there are [150 requests related to “spending](http://www.asktheeu.org/en/search/spending/all?commit=Search&utf8=%E2%9C%93)[” data](http://www.asktheeu.org/en/search/spending/all?commit=Search&utf8=%E2%9C%93) and [393 requests related to “budget](http://www.asktheeu.org/en/search/budget/all?commit=Search&utf8=%E2%9C%93)[” data](http://www.asktheeu.org/en/search/budget/all?commit=Search&utf8=%E2%9C%93).

**FarmSubsidy.org** 

[FarmSubsidy](http://farmsubsidy.openspending.org/) seeks to obtain detailed data relating to payments and recipients of farm subsidies in every EU member state and make this data available in a way that is useful to European citizens. This is a  project of [JournalismFund.eu](http://journalismfund.eu/), a non-profit organisation. The website is powered by OpenSpending of Open Knowledge and has previously been run by EU Transparency and DICAR (Danish International Center for Analytical Reporting). The website [lists](http://farmsubsidy.openspending.org/news/media/) over 120 stories which came out from the FarmSubsidy database.

**FishSubsidy.org**

Similar to FarmSubsidy, FishSubsidy was a website providing detailed data related to payments and recipients of fish subsidies in every EU Member State. The website was closed down due to lack of funding. However, [related datasets are still available online](https://docs.google.com/spreadsheets/d/1NZ9tc_JN8psXXOhCHmdzsVqhvGWsE7igDf004gHgfgQ/edit?hl=en_US#gid=4) and their T[witter account](https://twitter.com/fishsubsidy) is still active. A report of the European Parliament from 2012 on investigative journalism estimated that around 40 stories came out from the FishSubsidy data.[^ftnt31] 

**EuFunds**

[EuFunds](http://eufunds.ftdata.co.uk/) is an initiative from the Financial Times and [The Bureau of Investigative Journalists](http://www.thebureauinvestigates.com/) (TBIJ) to collect data on beneficiaries from EU Structural Funds. The application, still online, provides a search engine to query EU structural funds data. The data were extracted between April 2010 and September 2010 and represent a snapshot of projects that have been allocated EU funds from the start of the current funding phase in 2007 onwards. The underlying database is also available as a [MySQL](http://dl.dropbox.com/u/39827429/EU_Structural_Funds/sql/euFunds.sql) and [CSV file](http://dl.dropbox.com/u/39827429/EU_Structural_Funds/csv/euFunds.csv).

**OpenTED**

[OpenTED](http://ted.openspending.org/) is an initiative which aims to make information from the joint European procurement system more easily accessible to journalists and researchers. The initiative was developed in the frame of the Dataharvest.eu conference in collaboration between independent journalists, developers and researchers. The dataset contains procurement data from 2013 to 2015, including contracts from EU funds.

**OpenInterests.eu**

[OpenInterests.eu](http://openinterests.eu/) is a catalogue of political and commercial actors related to the European Union. The project combines different sets of information including data from the FTS into a search engine, which can be used to quickly retrieve information about the activities of companies, people and institutions in a European context.

**Wobbing.eu**

[Wobbing.eu](http://www.google.com/url?q=http%3A%2F%2Fwobbing.eu%2F&sa=D&sntz=1&usg=AFQjCNHVQsTSB9R-DYHnv2lPmOoxuKJPgw) is a network of journalists interested in using the EU’s freedom of information legislation at national and European levels to obtain documents. The network members exchange information on developments on national and European level and assist each other with requests when necessary. Annual meetings in the Wobbing.eu network have been merged into the annual Dataharvest.eu conference.

* * * * *

- [Return to Beginning](../)
- [Prev: How Transparent is the EU Budget?](../transparency/)
- [Next: Recommendations and Next Steps](../recommendations/)

{% include_relative footnotes.md %}
