---
title: Recommendations and Next Steps
---

As this report has evidenced, the level of transparency of EU funds is not consistent and depends on who manages the fund. **The result is a two-sided system where best practices in terms of transparency stand alongside closed data.** On one hand, the FTS of the European Commission delivers access to real expenditures information following open data standards, but it only concerns about 20% of EU spending. On the other hand, data on money spent through Members States is often unavailable to the public, and if available, not accessible in different languages. Furthermore, the release of EU Budget data as open data is still not a default practice.

The European Union has now entered a new MFF for 2014 -2020, with the adoption of a new financial regulation, defining new funds and transparency rules. However, structural barriers still remain, preventing an effective transparency of all EU funds and public accountability of all managing authorities.

Therefore, based on the EU budget mechanisms analysis, related transparency rules, and a preliminary assessment of effective EU budget and funds data availability, this report recommend the following actions to improve EU budget transparency and accountability:

1.  **Establish a single central point of reference**** ****for EU Budget information** and ensure all up to date documents and data are linked under this domain (e.g. at a website such as [ec.europa.eu/budget](http://ec.europa.eu/budget)). In the same time, **e****nsure all EU Budget data are available from the EU open data portal as open data.**

1.  **Set up a unique dataset of EU funds available as open data to improve the overall transparency of the EU budget.**The dataset could include the following information: name of the fund, heading, policy, type of management, implementing authorities, link to information on beneficiaries, link to legal basis in Eur-Lex and link to regulation in Eur-Lex.

1.  **Extend the Financial Transparency System to all EU funds by centralising or federating detailed data expenditures from Members States, non-EU Members and international organisations.** Data on beneficiaries should include, when relevant, a unique European identifier of company, and when the project is co-financed, the exact amount of EU funding received, the total amount of the project and all other co-financing sources.

1.  **Clarify the legal framework regarding the rules applicable to the transparency of beneficiaries of EU funds and ensure its consistency across the European Union.** Although this report did not conduct a comprehensive legal review of EU budget transparency, it has found that: (i) the differences of transparency rules applying to the beneficiaries of funds managed under centralised and shared management are preventing the establishment of a common transparency standard for all EU expenditures. This should concern also the publication, by the European institutions and in open data format, of more detailed expenditure information under the “Administration” heading; (ii) the differences between data protection law and effective enforcement within each Member State are also preventing a high level of EU funds transparency across Europe; (iii) the interpretation of the principle of proportionality regarding data protection is still subject to discussion; (iv) the transparency rules adopted by third countries and international organisations managing EU funds may also differ from the ones adopted by the EU and its Member States and prevent the establishment of a common transparency framework.

1.  **Support and strengthen civil society and journalists capacities on EU funds, together with the development of common data and investigation tools.** Newsrooms are too often reticent to launch long data investigations without the guarantee that these will pay off with good stories. In the wake of JournalismFund.eu, there is a need to support funding for data skills and relevant tools to develop data journalism and investigation projects related to EU funds.[^ftnt32] This should include not only literacy with datasets, but also literacy with data infrastructures, institutions and policies. Projects of interest in this area may include issues such as contracts/tenders financed or co-financed through the EU budget, in order to determine what are the regulations governing their functioning, what level of information is currently open to public scrutiny and what are the loopholes which may eventually be corrected in this system both to facilitate access to the data and to prevent fraud or misuse of the funds.

1.  **Conduct an assessment of EU funds beneficiary data availability (Open Data audit of EU funds).**** **Data on EU funds beneficiaries are spread into multiple data system managed by various implementing authorities such as EU institutions, Member States and international organisations. The open data audit of EU funds seeks to map all this data management system, the data they contain (from which EU funds), and their level of openness against a specific set of criteria such as the ones used in the [Open Data Index](http://index.okfn.org/). The Open Data audit of EU funds would be an essential tool for any further investigation into EU funds data as well as a powerful benchmark for any advocacy effort towards greater transparency in Europe and to assist official accountability initiatives and public institutions in identifying transparency gaps.

1.  **Build a stronger central base of evidence about the uses and users of EU fiscal data - including data projects, investigative journalism projects and data users in the media and civil society.**As well as contributing to a richer empirical picture of how fiscal data is actually used, we would like to see this work informing the development of a framework to highlight how information about EU public finances can be used to improve democratic accountability - including the different “accountability paths” through which this information can be put to work in society.

* * * * *

- [Return to Beginning](../)
- [Prev: Journalistic Investigations and Transparency Projects to Follow the Money](../research/)
- [Next: Annex - The Open Data Audit of EU Funds](../datasets/)

{% include_relative footnotes.md %}
