---
title: Glossary
---

Most of these definitions are taken from the [EU Glossary](http://ec.europa.eu/budget/explained/glossary/glossary_en.cfm) and from the publication [How the European Union works.](http://bookshop.europa.eu/en/how-the-european-union-works-pbNA3212336/)

****

**Budget**         Annual financial plan, drawn up according to budgetary principles, that provides forecasts and authorises, for each financial year, an estimate of future costs and revenue and expenditures and their detailed description and justification. In the EU, it takes the form of a **regulation**.

**Budget Data        **Information used in the budgetary cycle - including planning, revenues and expenditures.

**Ceiling        **Limits of expenditure or revenue fixed by law or by **regulation** such as in the own resources decision or in the** multiannual financial framework**.

**Commitment        **Legal pledges to provide finance, provided that certain conditions are fulfilled.

**Consent Procedure        **Through this procedure, the** Council** has to obtain the **European Parliament**’s assent before certain decisions are taken. The Parliament may accept or reject the **Council** proposal but cannot amend it.

**Council        **The institution where ministers of EU Member States meet to discuss EU matters, take decisions and pass laws. Which ministers attend which council meeting depends on the subject on the agenda. The Council adopts the **budget** jointly with the **European Parliament**. It should not be confused with the European Council, which brings together Heads of States or Governments.

**Discharge (Granting Discharge)        **The decision by which the **European Parliament**, on the basis of the recommendation from the **Council** and the declaration of assurance provided by the **European Court of Auditors**, closes the life of an annual budget exercise.

**European Commission        **Politically independent executive arm of the European Union that proposes legislation, policies and programmes of actions and is responsible for implementing the decisions of the **European** **Parliament** and of the **Council**.

**European Court of Auditors        **Independent external audit institution of the European Union. It checks that the EU **budget** is correctly implemented.

**European Parliament        **Directly elected legislative arm of the European Union. It shares authority with the **Council** over the budget. At the end of the budget procedure, it adopts or rejects the **budget** in its entirety (“**discharge**”).

**Financial Transparency System        **Database of beneficiaries of **grants** and other aids paid out each year by the **European** **Commission**.

**Fiscal Transparency        **The International Monetary Fund (IMF) defines fiscal transparency as the comprehensiveness, clarity, reliability, timeliness, and relevance of public reporting on the past, present, and future state of public finances.

**Grants        **Direct financial contributions, by way of donations, from the **budget** in order to finance either an action intended to help achieve an objective part of a EU policy or the functioning of a body which pursues an aim of general European interest or has an objective forming part of a EU policy.

**Headings        **In the Multiannual Financial Framework, they are groups of EU activities in broad categories of expenditure.

****

**Multiannual Financial Framework        **Multiannual spending plan that translates into financial terms the EU policy priorities. It sets (a) limits on EU expenditure over a fixed period and thus imposes budgetary discipline; (b) annual maximum amounts (**ceilings**) of **commitments** for the main categories of expenditures (**headings**) and an overall **payments** ceilings.

**Open Data        **Data is considered to be open if anyone can freely use, reuse and redistribute them, for any purpose, without restrictions (as per OpenDefinition.org). This includes being both technically open - the data can be downloaded online in open formats and read by software - and legally open - users have a legal right to reuse the data.

**Open Budget Data        **Public financial information used in the budget cycle that is freely available in a machine-­readable format to use, modify and share (as per opendefinition.org).

**Open Spending Data        **Information about public expenditure that is freely available in a machine­-readable format to use, modify and share (as per opendefinition.org)

**Open Fiscal Data**        Information about public finance that is freely available in a machine-­readable format to use, modify and share (as per opendefinition.org).

**Ordinary Legislative Procedure        **Main legislative procedure by which directives and **regulations** are adopted. It gives an equal weight to the **European Parliament** and to the **Council**in the decision procedure.

**Own Resources        **Revenue flowing automatically to the European Union **budget**, pursuant to the Treaties and implementing legislation, without the need for any subsequent decision by national authorities.

**Payment        **Cash or bank transfer to the beneficiaries.

**Regulation**        Normative act, of general application, binding in its entirety and directly applicable in all EU Member States.

**Spending Data        **Spending data is information about public expenditures - and crucially includes transaction level data, e.g. data about individual financial transactions. Ideally spending data should contain information on amount, payer, beneficiary, date and purpose of the transaction (e.g. a project or service).

**Sugar Levies        **Mainly customs duties on imports of certain agricultural products from non-EU countries as well as levies paid by producers on sugar, isoglucose and insulin syrup.

- [Return to Beginning](../)
- [Prev: Acronyms](../acronyms/)
- [Next: The EU Budget at a Glance](../overview/)

{% include_relative footnotes.md %}
