---
title: Where Does the Money Go?
---

The European Union has a budget to pay for policies carried out at the European level and for the institutions deciding, managing and implementing these policies (the Commission and its Directorates-General, the Parliament, the agencies, the Council, etc.).

The spending priorities are set in the MFF when defining the amount of the funds under its headings. For the 2014-2020 MFF, the priorities are creating growth and jobs and reducing economic gaps between the EU's various regions.[^ftnt16] Agriculture, rural development, fisheries and environmental protection account for a major share of the budget.

Each heading is then split into programmes and funds which finance the implementation of EU policies. The final beneficiaries can be any person or organisation (company, research organisation, local council, etc.) from the EU Member States and beyond.

As the programmes and funds are managed by various entities belonging or not to the EU institutions, **there is currently no central database of all the EU spending beneficiaries.** 

**The European Structural and Investment Funds (ESIF)**

A very large amount of the EU budget is spent through 5 funds known as the **European Structural and Investment Funds (ESIF).**Indeed, with a total of 366.9 billion euros for the 2014-2020 period, the ESIF make up more than one third of the EU’s budget. To these funds, in addition to the specific regulations regarding their implementation, applies a single set of common rules defined in the [Common Provisions regulation](http://eur-lex.europa.eu/legal-content/EN/TXT/?uri=uriserv:OJ.L_.2013.347.01.0320.01.ENG), with the objectives of:

-   Establishing a clear link with the Europe 2020 Strategy;[^ftnt17]
-   Improving coordination;
-   Ensuring consistent implementation;
-   Making access to the funds as straightforward as possible for those who may benefit from them.[^ftnt18]

The ESIF are managed under the shared management mechanism, which provides that Members States are co-responsible for the funds and, as such, must comply with specific control and audit procedures.

In 2014, Member States had to prepare and negotiate with the Commission so-called Partnership Agreements (strategic plans with their investment priorities covering the five ESIF). Then, they adopted Operational Programmes, which break down the investment priorities and objectives of the Partnership Agreements into concrete actions. The Operational Programmes are managed by the managing/national authorities appointed by each Member State. Applications for funding are then submitted to the national or regional authority managing the relevant programme.

The  5 ESIF  for the 2014-2020 period are:

-   The Cohesion Fund (CF);
-   The European Agricultural Fund for Rural Development (EARDF);
-   The European Maritime and Fisheries Fund (EMFF)
-   The European Regional Development Fund (ERDF);
-   The European Social Fund (ESF).

Below are details for each of the 5 ESIF.

The Cohesion Fund (CF)
----------------------

****



<table>
<col width="50%" />
<col width="50%" />
<tbody>
<tr class="odd">
<td align="left"><p>MFF heading</p></td>
<td align="left"><p>Smart and Inclusive Growth - Economic, Social and Territorial Cohesion</p></td>
</tr>
<tr class="even">
<td align="left"><p>Funds</p></td>
<td align="left"><p>Cohesion Fund</p></td>
</tr>
<tr class="odd">
<td align="left"><p>Policy supported</p></td>
<td align="left"><p>Regional and Urban Policy</p></td>
</tr>
<tr class="even">
<td align="left"><p>2014-2020 MFF ceiling</p></td>
<td align="left"><p>€63 399 million<sup><a href="#ftnt19">[19]</a></sup></p></td>
</tr>
<tr class="odd">
<td align="left"><p>Managing Member States</p></td>
<td align="left"><p>Bulgaria, Croatia, Cyprus, Czech Republic, Estonia, Greece, Hungary, Latvia, Lithuania, Malta, Poland, Portugal, Romania, Slovakia, Slovenia</p></td>
</tr>
<tr class="even">
<td align="left"><p>Managing Directorate-General</p></td>
<td align="left"><p>Directorate-General for Regional and Urban Policy (DG REGIO)</p></td>
</tr>
<tr class="odd">
<td align="left"><p>Website</p></td>
<td align="left"><p><a href="http://ec.europa.eu/regional_policy/en/funding/cohesion-fund/">http://ec.europa.eu/regional_policy/en/funding/cohesion-fund/</a></p></td>
</tr>
</tbody>
</table>

The aim of the CF is to reduce economic and social disparities and to promote sustainable development in Member States whose GNI per inhabitant is less than 90% of the EU average. The funding goes to activities supporting the establishment of trans-European transport networks or to projects related to energy or transport as long as they clearly benefit the environment.

Beneficiaries: 

-   **For funds under shared management**, DG REGIO manages a website with a map providing direct links to lists of beneficiaries provided by EU Member States, but the page does not make a clear distinction between the beneficiaries of spending under the CF or under the European Regional Development Fund (ERDF): [http://ec.europa.eu/regional\_policy/en/atlas/beneficiaries/](http://ec.europa.eu/regional_policy/en/atlas/beneficiaries/)
-   **For funds under centralised direct management**, a list of beneficiaries until 2013 is available in the FTS, under the heading “Cohesion Funds”: [http://ec.europa.eu/budget/fts/index\_en.htm](http://ec.europa.eu/budget/fts/index_en.htm)

The European Agricultural Fund for Rural Development (EAFRD)
------------------------------------------------------------

****



<table>
<col width="50%" />
<col width="50%" />
<tbody>
<tr class="odd">
<td align="left"><p>MFF heading</p></td>
<td align="left"><p>Sustainable Growth: Natural Resources</p></td>
</tr>
<tr class="even">
<td align="left"><p><strong>Funds</strong></p></td>
<td align="left"><p>European Agricultural Fund for Rural Development (EAFRD)</p></td>
</tr>
<tr class="odd">
<td align="left"><p>Policy supported</p></td>
<td align="left"><p>Agriculture and Rural Development</p></td>
</tr>
<tr class="even">
<td align="left"><p>2014-2020 MFF ceiling</p></td>
<td align="left"><p>€95 577.052 million</p></td>
</tr>
<tr class="odd">
<td align="left"><p>Managing Member States</p></td>
<td align="left"><p>EU28</p></td>
</tr>
<tr class="even">
<td align="left"><p>Managing Directorate-General</p></td>
<td align="left"><p>Directorate-General for Agriculture and Rural Development (DG AGRI)</p></td>
</tr>
<tr class="odd">
<td align="left"><p>Website</p></td>
<td align="left"><p><a href="http://ec.europa.eu/agriculture/cap-funding/index_en.htm">http://ec.europa.eu/agriculture/cap-funding/index_en.htm</a></p></td>
</tr>
</tbody>
</table>

The EAFRD is one of the two EU funds which finance the Common Agricultural Policy (CAP), the other one being the European Agricultural Guarantee Fund (EAGF), which is not an ESIF.[^ftnt20] The CAP, the agricultural policy of the EU, was established in 1962 and last reformed in 2013 to focus on 3 priorities: (i) viable food production; (ii) sustainable management of natural resources; (iii) balanced development of rural areas throughout the EU. In this context, the EAFRD focuses on the EU’s contribution to rural development programmes and is implemented through shared management with EU Member States.

The overall CAP budget has decreased over the years, but still represents a significant share of the EU budget: from 71% in 1984 to 39% in 2013.

Beneficiaries:

-   **For funds under shared management,**DG AGRI manages a website with links to Member States websites providing information on beneficiaries of CAP payments (although there is no clear distinction between beneficiaries of the EAFRD and the EAGF): [http://ec.europa.eu/agriculture/cap-funding/beneficiaries/shared/index\_en.htm](http://ec.europa.eu/agriculture/cap-funding/beneficiaries/shared/index_en.htm)
-   **For funds under centralised direct management,**a list of beneficiaries until 2013 is available in the FTS: [http://ec.europa.eu/budget/fts/index\_en.htm](http://ec.europa.eu/budget/fts/index_en.htm)

The European Maritime and Fisheries Fund (EMFF)
-----------------------------------------------

****



<table>
<col width="50%" />
<col width="50%" />
<tbody>
<tr class="odd">
<td align="left"><p>MFF heading</p></td>
<td align="left"><p>Sustainable Growth: Natural Resources</p></td>
</tr>
<tr class="even">
<td align="left"><p><strong>Funds</strong></p></td>
<td align="left"><p>European Maritime and Fisheries Fund (EMFF). Previously called the Financial Instrument for Fisheries Guidance (FIFG - for the period 1996-2006) and the European Fisheries Fund (EFF - for the period 2007-2013)</p></td>
</tr>
<tr class="odd">
<td align="left"><p>Policy supported</p></td>
<td align="left"><p>Maritime Affairs and Fisheries</p></td>
</tr>
<tr class="even">
<td align="left"><p>2014-2020 MFF ceiling</p></td>
<td align="left"><p>€7 404.84 million</p></td>
</tr>
<tr class="odd">
<td align="left"><p>Managing Member States</p></td>
<td align="left"><p>EU28, Luxembourg excepted</p></td>
</tr>
<tr class="even">
<td align="left"><p>Managing Directorate-General</p></td>
<td align="left"><p>Directorate-General for Maritime Affairs and Fisheries (DG MARE)</p></td>
</tr>
<tr class="odd">
<td align="left"><p>Website</p></td>
<td align="left"><p><a href="http://ec.europa.eu/fisheries/cfp/emff/index_en.htm">http://ec.europa.eu/fisheries/cfp/emff/index_en.htm</a></p></td>
</tr>
</tbody>
</table>

The EMFF supports the implementation of the European Common Fisheries Policy (CFP) and of the EU Integrated Maritime Policy (IMP) for the period 2014-2020. The objectives of the EMFF are: i) to help fishermen in the transition to sustainable fishing; ii) to support coastal communities in diversifying their economies; iii) to finance projects that create new jobs and improve quality of life along European coasts. In order to reach this objective, 11% of the fund is managed directly by the European Commission to support EU-wide objectives in maritime and coastal affairs, whereas the remaining 89% are managed by EU Member States on the basis of co-financing. In the last case, each country is allocated a share of the total fund budget, based on the size of its fishing industry - this makes Spain the biggest beneficiary of the EMFF.

A part of the MFF ceiling dedicated to the EMFF (€900 million) has been attributed to the establishment and management of sustainable fisheries partnership agreements with third countries. Very often criticised, these partnership agreements obey to different financial rules than the general rules applicable to the EMFF (see: [http://ec.europa.eu/fisheries/cfp/international/agreements/index\_en.htm](http://ec.europa.eu/fisheries/cfp/international/agreements/index_en.htm)).

Beneficiaries:

-   **For funds under shared management,**DG MARE maintains a website with links to the websites of Member States providing information on beneficiaries of EMFF payments (although, for some countries, the information presented seems to be outdated): [http://ec.europa.eu/fisheries/contracts\_and\_funding/the\_european\_transparency\_initiative/index\_en.htm](http://ec.europa.eu/fisheries/contracts_and_funding/the_european_transparency_initiative/index_en.htm) 
-   **For funds under centralised direct management,** a list of beneficiaries until 2013 is available in the FTS: [http://ec.europa.eu/budget/fts/index\_en.htm](http://ec.europa.eu/budget/fts/index_en.htm)

The European Regional Development Fund (ERDF)
---------------------------------------------



<table>
<col width="50%" />
<col width="50%" />
<tbody>
<tr class="odd">
<td align="left"><p>MFF heading</p></td>
<td align="left"><p>Smart and Inclusive Growth - Economic, Social and Territorial Cohesion</p></td>
</tr>
<tr class="even">
<td align="left"><p><strong>Funds</strong></p></td>
<td align="left"><p>Less-developed regions; More developed regions; Outermost and sparsely populated regions; Transition regions; Territorial cooperation.</p></td>
</tr>
<tr class="odd">
<td align="left"><p>Policy supported</p></td>
<td align="left"><p>Regional and Urban Policy</p></td>
</tr>
<tr class="even">
<td align="left"><p>2014-2020 MFF ceiling</p></td>
<td align="left"><p>€187.4 million</p></td>
</tr>
<tr class="odd">
<td align="left"><p>Managing Member States</p></td>
<td align="left"><p>EU28</p></td>
</tr>
<tr class="even">
<td align="left"><p>Managing Directorate-General</p></td>
<td align="left"><p>Directorate-General for Regional and Urban Policy (DG REGIO)</p></td>
</tr>
<tr class="odd">
<td align="left"><p>Website</p></td>
<td align="left"><p><a href="http://ec.europa.eu/regional_policy/en/funding/erdf/">http://ec.europa.eu/regional_policy/en/funding/erdf/</a> </p></td>
</tr>
</tbody>
</table>

The ERDF was established in 1975. For the 2014-2020 period, its objectives are to strengthen economic and social cohesion in the EU by correcting imbalances between its regions. To do so, it focuses on several key priority areas: (i) innovation and research; (ii) the digital agenda; (iii) support for small and medium-sized enterprises; (iv) the low-carbon economy.

EU regions are classified into several categories (see [the map presenting this classification](http://ec.europa.eu/regional_policy/en/policy/how/is-my-region-covered/)). Depending on this classification, different rules apply:

-   In more developed regions, at least 80% of the funds must focus on at least two of the key priorities;
-   This is 60% of the funds in transition regions;
-   And 50% in less-developed regions.

Implementation of the ERDF is made at the regional and national levels through the principles of shared management and of co-financing. The Commission retains a supervisory role.

The ERDF is not established as such in the MFF and in the annual budget regulations. The money channeled through this fund comes from different budget lines, such as “Less-developed regions”, “More developed regions” or “Transition regions”. These budget lines are also used to finance other funds such as the European Social Fund (ESF), making it difficult for the public to determine the exact amount of money invested in the ERDF.

Beneficiaries:

-   **For funds under shared management,** DG REGIO maintains a website with links to the websites of Member States providing information on beneficiaries of ERDF payments (although the data is mixed up with the one provided for the Cohesion Fund): [http://ec.europa.eu/regional\_policy/en/atlas/beneficiaries/](http://ec.europa.eu/regional_policy/en/atlas/beneficiaries/)
-   **For funds under centralised direct management,**a list of beneficiaries until 2013 is available in the FTS: [http://ec.europa.eu/budget/fts/index\_en.htm](http://ec.europa.eu/budget/fts/index_en.htm)

The European Social Fund (ESF)
------------------------------



<table>
<col width="50%" />
<col width="50%" />
<tbody>
<tr class="odd">
<td align="left"><p>MFF heading</p></td>
<td align="left"><p>Smart and Inclusive Growth - Economic, Social and Territorial Cohesion</p></td>
</tr>
<tr class="even">
<td align="left"><p><strong>Funds</strong></p></td>
<td align="left"><p>Less-developed regions; More-developed regions; Transition regions; Youth Employment Initiative</p></td>
</tr>
<tr class="odd">
<td align="left"><p>Policy supported</p></td>
<td align="left"><p>Employment, Social Affairs and Inclusion</p></td>
</tr>
<tr class="even">
<td align="left"><p>2014-2020 MFF ceiling</p></td>
<td align="left"><p>€86.4 million</p></td>
</tr>
<tr class="odd">
<td align="left"><p>Managing Member States</p></td>
<td align="left"><p>EU28</p></td>
</tr>
<tr class="even">
<td align="left"><p>Managing Directorate-General</p></td>
<td align="left"><p>Directorate-General for Employment, Social Affairs and Inclusion (DG EMPL)</p></td>
</tr>
<tr class="odd">
<td align="left"><p>Website</p></td>
<td align="left"><p><a href="http://ec.europa.eu/esf/home.jsp?langId=en">http://ec.europa.eu/esf/home.jsp?langId=en</a></p></td>
</tr>
</tbody>
</table>

The ESF is the EU’s main instrument for supporting jobs, helping people to get better jobs and ensuring fairer job opportunities. For the 2014-2020 period, priorities are to boost the adaptability of workers; improving access to employment and helping people from disadvantaged groups to get jobs.

The ESF is implemented through the system of shared management, together with EU Member States, and according to the co-financing principle. Co-financing rates vary between 50% and 85% of the total project costs depending on the relative wealth of the region (see [the map](http://ec.europa.eu/esf/main.jsp?catId=525&langId=en) presenting the classification of the EU regions into different categories).

The ESF is not established as such in the MFF and in the annual budget regulations. The money channeled through this fund comes from different budget lines, such as “Less-developed regions”, “More developed regions” or “Transition regions”. These budget lines are also used to finance other funds such as the European Regional Development Fund (ERDF), making it difficult for the public to determine the exact amount of money invested in the ESF. In addition, and even if it is included under a different budget heading, the Youth Employment Initiative appears to be managed under the framework of the ESF.

Beneficiaries:

-   **For funds under shared management,** DG EMPL maintains a website with links to the websites of Member States providing information on beneficiaries of ESF payments: [http://ec.europa.eu/esf/main.jsp?catId=45&langId=en](http://ec.europa.eu/esf/main.jsp?catId=45&langId=en) 
-   **For funds under centralised direct management,**a list of beneficiaries until 2013 is available in the FTS: [http://ec.europa.eu/budget/fts/index\_en.htm](http://ec.europa.eu/budget/fts/index_en.htm)

****

* * * * *

****

**Figure 5: Share of the EU budget per headings and funds (2015 Appropriation Commitments)**

****

![](../img/image02.png)

Source of the data: [European Commission](http://ec.europa.eu/budget/figures/interactive/index_en.cfm) -  Made with Many Eyes (IBM)

****

* * * * *

****

**Figure 4: Members States contributors vs. beneficiaries (budget 2013)**

![](../img/image04.png)

Source of the data: [European Commission](http://ec.europa.eu/budget/figures/interactive/index_en.cfm) - Made with raw.densitydesign.org

* * * * *

All Funds
---------

{% for fund in site.eu_funds %}
[{{fund.title}}]({{ fund.url }}) *{{ fund.objectives }}*
{% endfor %}

- [Return to Beginning](../)
- [Prev: Who Manages and Spends the Money, and How?](../expenditure/)
- [Next: How Transparent is the EU Budget?](../transparency/)

{% include_relative footnotes.md %}
