---
title: Who Manages and Spends the Money, and How?
---

The European Commission has the overall responsibility of the implementation of the EU budget, but does not directly manage all EU funds. Indeed, these funds can be spent in several different ways:

-   Through **centralised management**: the money is managed directly by the European Commission (e.g. through the selection of contractors or the award of grants) - this is **centralised direct management** - or indirectly by EU executive agencies, decentralised agencies or national agencies - this is **centralised indirect management**;
-   Through **shared management** (this method accounts for around 80% of the EU budget): there is a delegation of budget implementation to EU Member States;
-   Through **decentralised management**: there is a delegation of budget implementation to non-EU countries;
-   Through **joint management**: there is a delegation of budget implementation to intergovernmental and international organisations.

One fund can be spent in different ways (for example, through centralised and shared management). **For each fund, a specific regulation is adopted which defines the rules related to its implementation.**

****

**Figure 3****. Budget Management Overview**

****

![](../img/image05.png)

Source: [European Commission](http://ec.europa.eu/budget/explained/management/managt_who/who_en.cfm)

Ultimately, a large number of entities are involved in the spending of the EU budget.

-   **The Commission itself and its agencies.**In that case, money will be directly spent through grants, contracts, or administrative expenditures.
-   **National and regional authorities in EU Member States;**
-   **Authorities in non-EU countries** which receive financial support from the EU;
-   **International organisations** such as the United Nations or the World Bank.

As a general rule, the co-financing principle usually applies to EU spending, especially when it comes to shared management. Through this rule, part of the cost of an action or the running costs of an entity is borne by the beneficiary of the grant or by contributors other than the European Commission, with the aim to make beneficiaries responsible for the operational and financial viability of their projects. Some flexibility nevertheless exists to allow for the full financing of some projects with EU funds.

Other rules usually applicable to funding projects with EU money are: the non-profit rule; the non-retroactivity rule and the non-cumulative rule.[^ftnt15]

* * * * *

- [Return to Beginning](../)
- [Prev: Where Does the Money Come From?](../revenue/)
- [Next: Where Does the Money Go?](../funds/)

{% include_relative footnotes.md %}
