---
title: How is the EU Budget Set Up?
---

Unlike most national budgets which are only set up on an annual basis, the EU budget is set up through two main instruments: the Multiannual Financial Framework (MFF) for the long term, and a more standard annual budget regulation.

The Multiannual Financial Framework
-----------------------------------

The MFF is an instrument which sets the maximum annual amounts - or “ceilings” - which the EU may spend in different political fields - or “headings” - for a period of at least 5 years. In practice, the MFF is adopted for a period of 7 years and the current one is applicable for the years 2014-2020.[^ftnt2]

The MFF takes the form of a Council regulation, adopted following a special legislative procedure called the consent procedure:

1.  The European Commission submits a proposal for an MFF regulation;
2.  The European Parliament accepts or rejects the proposal by an absolute majority vote - but it cannot amend the proposal;
3.  After the approval of the European Parliament, the Council adopts the MFF Regulation by a unanimous vote.

Through the MFF regulation, ceilings for each year concerning commitment appropriations and payment appropriations are determined for each of the MFF headings. Headings change from one MFF to the other, making comparisons difficult over the years.

For the period 2014/2020, the headings are:

-   Smart and inclusive growth including:
-   Competitiveness for growth and jobs;
-   Economic, social and territorial cohesion;
-   Sustainable growth: natural resources;
-   Security and citizenship;
-   Global Europe;
-   Administration;
-   Compensation.

The framework also sets up ceilings for a number of instruments established outside the general headings and known as the Flexibility and Special Instruments, such as (1) the Emergency Aid Reserve; (2) the European Union Solidarity Fund; (3) the Flexibility Instrument;[^ftnt3] (4) the European Globalisation Adjustment Fund; (5) the Contingency Margin; (6) the Global Margin for commitments for growth and employment, in particular youth employment. These instruments enable the EU to mobilise the necessary funds to react to unforeseen events (financial crisis, emergency situations).

One specific instrument, the European Development Fund (EDF) is managed outside the framework of the MFF and governed by its own set of rules. The EDF provides development aid to African, Caribbean and Pacific (ACP) countries, as well as to Overseas Countries and Territories (OCTs). It is based on an ACP-EU Partnership Agreement known as the “Cotonou Agreement”, which is revised every five years, and it is financed by direct contributions from EU Member States. The resources for the current EDF amount to €30.5 billion for the period 2014 - 2020.

### What are Commitment and Payment Appropriations?

In the EU annual budget and in the MFF regulations, authorised expenditure amounts are expressed in both **commitment** and **payment appropriations**.

-   **Commitments** are legal pledges to provide finance, provided that certain conditions are fulfilled. The EU commits itself to reimburse its share of the costs of an EU-funded project when the project is completed.
-   **Payments** are cash or bank transfers to beneficiaries. Today’s commitments are tomorrow’s payments.[^ftnt4]

This means for instance that 2015 payments are actually 2014 commitments. In practice, this implies that the EU does not finance a project in advance. Someone, a Member State in most of the cases, would have to provide the funds beforehand before being reimbursed by the EU.

The ceilings of the 2014-2020 MFF are **€959 988 million** in commitment appropriations and **€908 400 million** in payment appropriations. This represents a decrease compared to the 2007-2013 MFF, whose ceiling in commitment appropriations was up to €994 176 million. The main areas concerned by this decrease are the Cohesion Policy, under the heading Smart and Inclusive Growth (-8%) and the Agriculture and Rural Development Policy, under the heading Sustainable Growth: Natural Resources (-11%).[^ftnt5]

The EU Annual Budget
--------------------

Every year, a regulation is adopted to set up the annual budget of the EU. This budget is based on the MFF and the procedure followed is the ordinary legislative procedure.[^ftnt6] One of the guiding principles for establishing the annual budget is that *“the revenue and expenditure shown in the budget must be in balance”*.[^ftnt7]

**Figure 1: EU annual budget regulation adoption procedure**![Annual Budget.png](../img/image08.png)

Source: European Commission | [SVG version available here](https://drive.google.com/open?id=0BxUOTiQczyxHaDBqSmdDR0FTRlE&authuser=0)

The annual budget regulation is divided into several sections detailing, for each of the EU institutions, the relevant revenue, expenditure and staff allocated. The largest section of the regulation concerns the European Commission, which is responsible for managing the EU policies.

For the year 2015, the budget amounts to:

-   €145 321 million in commitment appropriations;
-   €141 214 million in payment appropriations (this represents an increase of 1,57% compared to the 2014 EU annual budget);
-   €141 214 million in budgetary revenue.[^ftnt8]

It is possible to amend the budget after its adoption.

[Annual activity reports](http://ec.europa.eu/atwork/synthesis/aar/index_en.htm) are prepared every year by each Directorate-General (DG) and contain the DG’s annual accounts and financial reports. These reports are summarised in a synthesis report, sent to the European Parliament, the Council and the European Court of Auditors (ECA).

In addition, an annual report on budgetary and financial management is published every year by the Commission.[^ftnt9] 

In November every year, the Court of Auditors publishes public reports on the implementation of the EU budget and the EDF by the Commission. Based on these reports, the European Parliament expresses an opinion on the implementation of the budget by the European Commission. If this opinion is positive, it means that the Parliament has granted discharge to the Commission for this financial year.[^ftnt10]

* * * * *

- [Return to Beginning](../)
- [Prev: The EU Budget at a Glance](../overview/)
- [Next: Where Does the Money Come From?](../revenue/)

{% include_relative footnotes.md %}
