---
title: Help
authors:
- Anders Pedersen
redirect_to: "/get-involved/"
---

Are you looking to get started using OpenSpending? Have a look at some
of our guides and get rolling! If you have questions,
[get in touch](../about/contact).

The OpenSpending Guide is available in multiple languages:

* [English](./help/guide/en)
* [French](./help/guide/fr)
* [Italian](./help/guide/it)
* [Nepali](./help/guide/npl)
* [Romanian](./help/guide/rom)
* [Spanish](./help/guide/esp)

Many other translations are under development. Check back for new
translations or
[help add your language](https://trello.com/c/abfAVgBC/14-permanent-openspending-guide-translation).

#### Video guides

* [OpenSpending Upload, Step 1](http://vimeo.com/43259079#): adding a dataset
* [OpenSpending Upload, Step 2](http://vimeo.com/43760979): data modelling
* [How to Fix Errors in OpenSpending](http://vimeo.com/43762097)
* [Introduction to Spending Stories](http://webtv.journalismfestival.com/doc/1311/raccontare-la-spesa-pubblica.htm)
* [Talk from "The Big Clean", Prague 2012](http://www.youtube.com/watch?v=ofzU43g5ZpY)

#### Tutorials

* [D3.js Sankey diagrams with the OpenSpending API](http://blog.openspending.org/2013/08/28/d3-sankey/)

#### OpenSpending API

OpenSpending aims to be a simple-to-use platform for developers by
offering a variety of APIs that can be used to create visualizations,
reports, and other applications. These help pages describe the APIs
and provide examples of their use.

* [API conventions](./conventions)
* [Aggregate API](./aggregate)
* [REST resources](./rest)
* [Full-text search API](./search)
* [Personal tax API](./tax)
* [Dataset loading API](./loading)
