# How to contribute

OpenSpending is a project that aims to make public financial data more accessible, understandable, and usable. It is powered by PortalJS, a framework for building data portals that are fast, secure, and easy to customize.

If you have any questions, the best place to get answers is to reach to us on [Discord](https://discord.gg/xJrxCbkP)

We welcome contributions from anyone who is interested in improving OpenSpending and making it more useful for the public. There are many ways you can contribute to the project, such as:

- Submitting datasets for evaluation and inclusion in OpenSpending
- Reporting bugs or issues with the website or the data
- Suggesting new features or enhancements
- Providing feedback or ideas
- Helping other users or answering questions

## Submitting a contribution

The main platform for communication and collaboration for OpenSpending is Github, if you want to interact with us you can o so by submitting an issue.

**Repo for issues:** [https://github.com/os-data/registry/issues](https://github.com/os-data/registry/issues)

If you want to submit a dataset for evaluation and inclusion in OpenSpending, you will need to create an issue on Github using this template:

```markdown
Title: [Dataset Submission] Name of the dataset (This will be the name of the repo where your datasets will be stored)
Readme: A description of your data to include in the new repo that will be created
Datapackage: All our datasets require a datapackage following the [frictionless spec](https://specs.frictionlessdata.io/) more specific the [fiscal version](https://specs.frictionlessdata.io/fiscal-data-package/)
```

Please make sure that the dataset meets the following criteria before submitting it:

- The dataset contains public financial data (e.g., budgets, expenditures, revenues, contracts)
- The dataset is open and free to use (e.g., no restrictions on access or reuse)
- The dataset is structured and machine-readable (e.g., no scanned images or PDFs)
- The dataset has a datapackage containing metadata and documentation (e.g., descriptions, definitions, schemas)

If you have any questions or doubts about submitting a dataset, please contact us on Github or join our [Discord server](https://discord.gg/xJrxCbkP), where you can chat with other contributors and get support from the OpenSpending team.

We appreciate your interest and involvement in OpenSpending, and we look forward to working with you on making public financial data more open and transparent. Thank you for your contribution! 😊
