---
authors:
- Friedrich Lindenberg
- Rufus Pollock
title: "OpenSpending Next + SpenDB = <3"
---

*This is a post by [Friedrich Lindenberg](https://discuss.okfn.org/users/pudo/activity) and [Rufus Pollock](https://discuss.okfn.org/users/rufuspollock/activity). Friedrich and Rufus have both been major and ongoing contributors to the OpenSpending project. Friedrich was the creator of [OffenerHaushalt](http://db.offenerhaushalt.de/), the technical lead of OpenSpending 2011-2013, and the developer of [SpenDB](http://spendb.org/). Rufus is Founder of [Open Knowledge](https://okfn.org/) and original project lead on [WhereDoesMyMoneyGo](http://wheredoesmymoneygo.org/) and OpenSpending and has continued to play an active role.*

![Next + SpenDB](/img/next-and-spendb.png)

This post sets out some of our shared thinking about OpenSpending and our shared commitment to collaborate together and with the community going forwards. We are committed to creating a project that is open, impactful and exciting. There is huge need for OpenSpending at both a technical and a community level. We're excited about both achievements to date and the plans for the future. We want to do everything *we* can to contribute to that future.

Since OpenSpending evolved from the "[Where Does My Money Go?](http://wheredoesmymoneygo.org/)" project in late 2011, data-driven approaches to fiscal analysis have made incredible progress. 

In areas like international aid, payments around extractives and procurement, governments have adopted data publication as a path towards transparency and accountability. Amazing groups like [Global Witness](https://www.globalwitness.org/en-gb/) and others have adopted data as a means to explore corruption, social injustice and failed government policies.

At the same time, there's a still a large, unsatisfied need to the right tools to do this work: open source software that allows activists, journalists, and policy wonks to easily explore fiscal data, share it with others and present their findings. OpenSpending, since it's beginning, has been focussed on creating such tools.

Going forward, we're excited to see both branches of OpenSpending develop: on the one hand [the platform and suite of open source tools and standards](https://github.com/openspending/); on the other hand, [the community and the conversations](https://discuss.okfn.org/c/openspending) that have always made OpenSpending a special and welcoming place for anyone interested in fiscal transparency.

Within the community, our goal is to make OpenSpending a meeting point for anyone interested in understanding how government manages and distributes public money. This is not a conversation about tools and widgets, but one about how open data can be used in the service of public education, accountability and wider engagement with public finances. 

At the same time, this is an exciting moment for the technologies surrounding OpenSpending: the [main software platform](http://openspending.org/) is about to get a [major upgrade with a more flexible architecture, a new standard and the latest technologies](/next/). This will provide the platform with a new and much improved level of usability, scalability and robustness. 

The [Fiscal Data Package (FDP)](http://fiscal.dataprotocols.org/) is a light-weight, descriptive data model that can be used to describe and compare a wide variety of fiscal data - it will act as a backbone to connect many of the applications in the OpenSpending technology stack.

We're also excited to combine components from the [OpenSpending Next](/next/) and [SpenDB](http://spendb.org/) development paths of OpenSpending into a group of lightweight tools that can be used to drive both the existing OS budget sites (like [Spending.jp](http://spending.jp/), [OffenerHaushalt](http://db.offenerhaushalt.de/), [Cameroon's Explorateur budgétaire](http://cameroon.openspending.org/fr/), etc.), but also lend themselves to more analytical exploration of the data and custom visualisations in the context of advocacy, data journalism and policy analysis.

Lastly, we want to talk about our own roles. We've both contributed much to the development of OpenSpending and the community around it. And we intend to keep doing so. At the same time, the project has grown and neither of us are working on OpenSpending full-time. As such, we want to define our roles more clearly. In particular, technical leadership of the project now sits with the technical team and, ultimately, with the current technical lead [Paul Walsh](https://discuss.okfn.org/users/pwalsh/activity). We will both be part of the technical team and Friedrich will be taking a leading role in the development of the visualization component whilst Rufus will be helping oversee the development of [Fiscal Data Package](http://fiscal.dataprotocols.org/). 
