---
redirect_from: /2014/08/in-cameroon-budget-transparency-one-council-at-a-time-2/
title: In Cameroon, budget transparency one council at a time
authors:
- pierre chrzanowski
---
<em>How a tool like OpenSpending can help to better channel public spending into basic services in Cameroon.</em>

<a href="http://community.openspending.org/2014/08/au-cameroun-la-transparence-budgetaire-village-par-village/" target="_blank">Version française</a>

<p dir="ltr">In Cameroon, forest exploitation yield lots of money. Wood is indeed the third largest source of exports of the country, <a href="http://atlas.media.mit.edu/explore/tree_map/hs/export/cmr/all/show/2010/" target="_blank">following oil and cocoa</a>. In return, every logging company must pay a tax whose a part goes to local communities living near the concession. <a href="http://www.droit-afrique.com/images/textes/Cameroun/Cameroun%20-%20Loi%20foret.pdf" target="_blank">By law</a>, this money must be allocated to local development projects (schools, electrification, water access). Dedicated local committees are responsible for the budgets.

<a href="{{ site.baseurl }}/img/blog/2014/08/Yokadouma.jpg"><img title="Are forest revenues of Yokadouma, a council in the East region of Cameroon, invested in basic services? Image credit: Courtesy of Paolo Scoppola - www.paoloscoppola.com" alt="Are forest revenues of Yokadouma, a council in the East region of Cameroon, invested in basic services? Image credit: Courtesy of Paolo Scoppola - www.paoloscoppola.com" src="{{ site.baseurl }}/img/blog/2014/08/Yokadouma.jpg" width="800" height="515" /></a>

<p dir="ltr">In a country where access to basic services is still insufficient for many rural populations, the <em>forest tax</em> appears as a potential leverage for local development. But what is it real impact? This is difficult to say when you cannot access even basic council's budget data. Yet, beneficiaries, the citizen, should be able to check if taxes are effectively perceived, redistributed and efficiently allocated. This is what budget transparency is all about.

<p dir="ltr">As part of World Bank's <a href="http://www.worldbank.org/en/topic/socialdevelopment/publication/budget-transparency-initiative" target="_blank">Budget Transparency Initiative in Cameroon</a>, the OpenSpending team developed in 2012 the website <a href="http://cameroon.openspending.org/fr/" target="_blank">cameroon.openspending.org</a>, a tool to explore and follow budget data. The website enables everyone to navigate through the different administrative levels of the country and to visualize related planned and executed public spending.

<p dir="ltr"><a href="http://cameroon.openspending.org/en/contribute.html" target="_blank">Anyone can contribute to the database and publish budget data from its council.</a> The technical requirements for contribution were however still significant. Therefore Open Knowledge teamed up with the local civil society organisation <a href="http://www.assoal.org/" target="_blank">ASSOAL</a> and its partners in June 2014 to make contribution and dissemination of local budget data more accessible. The objective was to transfer skills and tools between participants and enable ASSOAL and local partners to steer the entire process: from data collection to online publication of councils budget data.

<p dir="ltr"><a href="{{ site.baseurl }}/img/blog/2014/08/OpenSpendingCameroon.png"><img title="The aim of the workshop was to transform budget papers into easy-to-understand online information. " alt="The aim of the workshop was to transform budget papers into easy-to-understand online information. " src="{{ site.baseurl }}/img/blog/2014/08/OpenSpendingCameroon.png" width="800" height="400" /></a>

<p dir="ltr">ASSOAL aims to promote and demonstrate the benefits of transparency on local development. Information published by the NGO are available to every connected citizen but can also be used for participatory budgets, citizen radio programs or even murals to inform every citizen. Eventually, ASSOAL aims to publish every budget of the 336 councils of Cameroon online. This will require collaboration with public authorities, such as  Cameroon’s municipal bank (FEICOM), in charge of cross-councils investments, but also new budget data methodologies. The workshop with ASSOAL was indeed an opportunity to discuss the importance of getting budget data online in digital and reusable format - not only in paper or PDF.

<p dir="ltr">Currently, ASSOAL's members are entering or transcribing budget data manually on their computers from paper versions. This is a tedious process, and also a great source of errors, but the only current way to get the data released openly on websites such as OpenSpending.

<p dir="ltr">The workshop enabled the participants to learn how to clean, correct, and format datasets by using simple tools such as Excel, LibreOffice or OpenRefine. Participants were also able to train on how to collaborate and share data online with applications like <a href="https://pad.okfn.org/p/OpenSpendingCameroon">Etherpad</a> or <a href="http://datahub.io/organization/openspending-cameroon" target="_blank">Datahub.io</a>. The workshop was also an opportunity to review the process of data collection. At the end, the team revised its methodology by adopting a new data model and using some OpenSpending's <a href="https://github.com/openspending/budget-data-package/blob/master/specification.md" target="_blank">Budget Data Package</a> specifications. Following the 4 days training, the participants were able to publish 40 budgets in one month. The target is to double this number by the end of the year.

<p dir="ltr"><a href="{{ site.baseurl }}/img/blog/2014/08/redevanceforet.jpg"><img title="Explore how much a council earns from forest tax and how much it spends in basic services on cameroon.openspending.org." alt="Explore how much a council earns from forest tax and how much it spends in basic services on cameroon.openspending.org." src="{{ site.baseurl }}/img/blog/2014/08/redevanceforet-1024x683.jpg" width="591" height="394" /></a>

<p dir="ltr">Thanks to the efforts of the civil society and the use of tools like OpenSpending, budget transparency is slowly taking off in Cameroon from bottom up, starting at council level. This is an encouraging effort and we hope this will lead the Government to do the same with national Public Investment data. The population should be able to know their rights, follow the decisions of the ones who represent them and hold them accountable. Budget transparency is essential here, as is the right to access legal information, and in this precise case, the right to access information on forest exploitations and revenues. In the challenge of improving the standard of living for communities across councils access to budget information is key for enabling citizens to contribute and decide on the development.

&nbsp;

&nbsp;

&nbsp;

&nbsp;

