---
redirect_from: /2014/08/au-cameroun-la-transparence-budgetaire-village-par-village/
title: Au Cameroun, la transparence budgétaire, village par village
authors:
- pierre chrzanowski
---
<p dir="ltr"><em>Comment un outil comme OpenSpending peut aider à mieux orienter les dépenses publiques vers les services de base au Cameroun.</em>

<p dir="ltr"><a href="http://openspending.okblogfarm.org/?p=1888" target="_blank">English version here</a>

<p dir="ltr">Au Cameroun, l'exploitation des forêts rapporte beaucoup d'argent. Le bois est ainsi la troisième source d'exportation du pays, <a href="http://atlas.media.mit.edu/explore/tree_map/hs/export/cmr/all/show/2010/" target="_blank">après le pétrole et le cacao</a>. En contrepartie, chaque entreprise du secteur doit s'acquitter d'une redevance dont une partie revient aux communautés vivant en bordure des concessions. <a href="http://www.droit-afrique.com/images/textes/Cameroun/Cameroun%20-%20Loi%20foret.pdf" target="_blank">Selon la loi</a>, cette redevance doit être allouée à des projets de développement local (électrification, accès en eau potable, écoles). Des comités communaux en ont la charge.

<a href="{{ site.baseurl }}/img/blog/2014/08/Yokadouma.jpg"><img title="Les revenus forestiers de Yokadouma, communes de l'Est du Cameroun,  sont-ils investis dans les services de base ? Crédit photo : Avec l'aimable autorisation de Paolo Scoppola - www.paoloscoppola.com" alt="Are forest revenues of Yokadouma, a council in the East region of Cameroon, invested in basic services? Image credit: Courtesy of Paolo Scoppola - www.paoloscoppola.com" src="{{ site.baseurl }}/img/blog/2014/08/Yokadouma.jpg" width="800" height="515" /></a>

<p dir="ltr">Dans un pays où l'accès aux services de base reste encore largement insuffisant pour les populations rurales, la redevance d'exploitation forestière devrait donc constituer un levier important pour le développement local. Mais quel est son impact réel ? Difficile de savoir quand les informations sur les investissements publics ne sont pas accessibles. Les populations bénéficiaires devraient pourtant pouvoir controler si la redevance est effectivement perçue, redistribuée et correctement investie. C'est tout l'enjeu de la transparence budgétaire.

<p dir="ltr">Ainsi, dans le cadre du programme de la Banque Mondiale,<a href="http://www.banquemondiale.org/fr/news/feature/2013/04/15/budget-transparency-initiative-makes-officials-accountable-to-citizens" target="_blank"> Initiative pour la Transparence Budgétaire au Cameroun</a>, l’équipe OpenSpending a développé en 2012 le site <a href="http://cameroon.openspending.org/fr/" target="_blank">cameroon.openspending.org</a>, une application dédiée à l'exploration et au suivi des budgets. Le site permet de naviguer à travers les différent niveaux administratifs du pays et de visualiser les dépenses publiques plannifiées et exécutées qui s'y rapportent.

<p dir="ltr"><a href="http://cameroon.openspending.org/fr/contribute.html" target="_blank">Chacun peut contribuer à la base de données et ajouter les informations budgétaires de sa commune.</a> Cela requiert cependant certaines compétences techniques. C'est pourquoi une seconde mission a eu lieu en juin 2014 pour former l'association <a href="http://www.assoal.org/">ASSOAL</a> et ses partenaires. L'objectif était de transmettre aux participants les compétences et outils nécessaires pour maîtriser l'ensemble de la procédure, de la collecte à la publication en ligne des données budgétaires des communes.

<p dir="ltr"><a href="{{ site.baseurl }}/img/blog/2014/08/OpenSpendingCameroon.png"><img title="Objectif de l'atelier : transformer des budgets papiers en informations facilement compréhensibles et disponibles en ligne." alt="The aim of the workshop was to transform budget papers into easy-to-understand online information. " src="{{ site.baseurl }}/img/blog/2014/08/OpenSpendingCameroon.png" width="800" height="400" /></a>

<p dir="ltr">La démarche d'ASSOAL vise à promouvoir et démontrer les bienfaits de la transparence sur le développement local. Les informations que l'association publie sont accessibles à tout citoyen connecté et peuvent également être réutilisées pour la préparation des budgets participatifs, ou pour la réalisation de fresques murales ou émissions de radios citoyennes. À terme, l'association souhaite pouvoir mettre en ligne et explorer l'ensemble des budgets planifiés et éxecutés des 336 communes du pays. Cela nécessitera une plus forte collaboration avec les instances publiques, comme le FEICOM chargé des investissements intercommunaux, et la mise en place de nouvelles procédures de gestion des données budgétaires. La mission a ainsi été l'occasion d'insister sur l'importance de disposer de données budgétaires dans des formats numériques réutilisables et non dans des formats papiers ou PDF.

<p dir="ltr">Pour l'heure, les membres d'ASSOAL saisissent manuellement sur leur ordinateur les données contenues dans les budgets papiers qu'ils collectent auprès des communes. Un travail fastidieux donc, et source d'erreurs, mais qui à défaut de budgets disponibles au format numérique reste la seule solution pour pouvoir ensuite publier les données en ligne.

<p dir="ltr">L'atelier a permis aux participants d'apprendre à nettoyer, corriger et formater les données tabulées en utilisant des outils simples tels que Excel, LibreOffice ou encore OpenRefine. Ils ont également pu se former à la collaboration et au partage de données en ligne grâce à des outils comme <a href="https://pad.okfn.org/p/OpenSpendingCameroon" target="_blank">Etherpad</a> ou <a href="http://datahub.io/organization/openspending-cameroon" target="_blank">Datahub.io</a>. L'atelier a été l'occasion d'améliorer la procédure de saisie des données budgétaires, en adoptant une structure de données plus conforme à la nomenclature réelle et en s'inspirant des spécifications du nouveau <a href="https://github.com/openspending/budget-data-package/blob/master/specification.md" target="_blank">Budget Data Package</a> de OpenSpending. À la suite des 4 jours de formation, l'équipe a été capable de traiter et publier 40 budgets en un mois. L'objectif est de doubler ce chiffre pour fin 2014.

<p dir="ltr"><a href="{{ site.baseurl }}/img/blog/2014/08/redevanceforet.jpg"><img title="Sur cameroon.openspending.org explorez combien une commune reçoit en taxe forestière et combien elle dépense dans les services de base." alt="Explore how much a council earns from forest tax and how much it spends in basic services on cameroon.openspending.org." src="{{ site.baseurl }}/img/blog/2014/08/redevanceforet-1024x683.jpg" width="591" height="394" /></a>

<p dir="ltr">Grâce aux efforts de la societé civile et à l'usage d'outils comme OpenSpending, la transparence budgétaire progresse au Cameroun, mais essentiellement au niveau des communes. C'est un premier pas encourageant qui, il faut l'espérer, incitera le gouvernement à faire de même au niveau national. L'enjeu ici est bien d'améliorer le niveau de vie des populations en leur permettant de contribuer à leur propre développement. Ces dernières devraient donc être en mesure de connaître leurs droits, être capables de suivre les décisions de ceux qui les représentent et les obliger à rendre des comptes. La transparence et la compréhension des budgets sont donc ici essentielles, tout comme le sont l'accès aux textes de loi et, dans ce cas précis, l'accès aux informations sur les exploitations forestières du pays.

&nbsp;

&nbsp;

&nbsp;

