---
redirect_from: /2013/11/joined-up-data-connecting-transparency-initiatives/
title: 'Joined Up Data: first steps towards connecting transparency initiatives'
authors:
- Neil Ashton
---
<!--magazine.image = http://farm4.staticflickr.com/3755/9704493341_71201c2884_z.jpg -->

Unprecedented amounts of information on the financial resources available to fight poverty are now being released through the efforts of multi-stakeholder transparency initiatives in sectors like aid, construction, contracting, and extractives. Unleashing this data's potential will mean *joining it up*, following the money by merging and comparing datasets from different sources. Transparency initiatives have the opportunity to make this possible by identifying the shared *building blocks* of their data standards that enable comparisons

[caption id="" align="aligncenter" width="640"]<a href="http://www.flickr.com/photos/69583224@N05/9704493341/"><img src="http://farm4.staticflickr.com/3755/9704493341_71201c2884_z.jpg" alt="" width="640" height="480" /></a> Photo credit: European Commission on DG ECHO[/caption]

With this opportunity in mind, [Development Initiatives][1] (DevInit), the technical leads of the [International Aid Transparency Initiative][2] (IATI) and designers of the [IATI standard][3] for resource flow data, have initiated the **Joined Up Data** project. With this project, they aim to build a new culture of collaboration among multi-stakeholder transparency initiatives and to begin work on developing a shared set of building blocks for their data standards.

Joined Up Data has begun with a [scoping study][4] developed for DevInit by the Open Knowledge Foundation and debuted at a workshop at the [Open Government Partnership][5] summit. The study identifies opportunities for collaboration between five transparency initiatives in different sectors: aid ([IATI][6]), construction ([Construction Sector Transparency Initiative][7]; CoST), contracting ([Open Contracting][8]), extractives ([Extractive Industries Transparency Initiative][9]; EITI), and fiscal transparency generally ([Global Initiative for Fiscal Transparency][10]). It assesses the coverage of each initiative's data collection requirements and identifies areas of overlap that could become fruitful sites of collaboration, and it discusses the implementation challenges faced by each initiative and the governance processes underlying the creation of each initiative's disclosure requirements.

The scoping study demonstrates that there is much to discuss and a great deal of work to be done. The five initiatives covered in the study would all benefit from the development of building blocks covering organisational identifiers for government entities, geospatial data for sub-national administrative boundaries, and data standards for contracting information. The initiatives also have much to learn from one another's structure: bottom-up initiatives like EITI and CoST can share the view from "on the ground", whereas more top-down initiatives like IATI can contribute technical guidance.

The Joined Up Data project is just taking its first steps, with future iterations promising to both deepen and broaden its coverage. The project also needs *you*. Improving the experience of using data is the most important goal of the Joined Up Data project. If you work with transparency initiative data (or want to), the organizers of Joined Up Data will surely want <a href="http://lists.okfn.org/mailman/listinfo/openspending">to hear how you use data</a> and how it can be made more useful to you as they plan the next steps of the project.

Access the scoping study <a href="http://devinit.org/wp-content/uploads/2013/11/JUD-scoping-study-final1.pdf">Joined Up Data</a> [PDF].

[1]: http://devinit.org
[2]: http://www.aidtransparency.net
[3]: http://iatistandard.org
[4]: http://devinit.org/report/joined-data-building-blocks-common-standards/
[5]: http://www.opengovpartnership.org
[6]: http://www.aidtransparency.net
[7]: http://constructiontransparency.org
[8]: http://open-contracting.org
[9]: http://eiti.org
[10]: http://fiscaltransparency.net

