---
redirect_from: /2013/10/wearing-your-examples/
title: Wearing your examples
authors:
- Tryggvi Björgvinsson
---
![Spending t-shirts at Googleplex](http://farm6.staticflickr.com/5343/10051655705_a48d349b5c_z.jpg)

[OpenSpending](http://openspending.org) and [Journalism++](http://jplusplus.org) are collaborating on a project we call *How much is it really?* The goal of the project is to create a webapp where users can type in a number to rough equivalents.

The idea is that a reader of the news might be reading about how much it cost to built an airport. It might say it cost millions of dollars. The problem is that most news readers don't have millions of dollars nor will they ever have. They can't even begin to understand how much it is (but they do know that it's probably a hefty sum). This news reader could then quickly go and type in the cost mentioned in the news article and see that this cost half of what another airport cost or double what the government spent on education.

We hope that this webapp will help readers of the news, journalists or just about anybody better understand the numbers or start questioning where money is going. Why does it cost so much to build airports? Why not settle for something less expensive and improve education instead?

The airports and education example is fictional. I don't know how much it costs to build airports and I don't have in my head the amounts governments spend on education. But an example like this is the best way to explain the idea behind the webapp.

Now OpenSpending and Journalism++ were invited to a meeting in Palo Alto by the funder of the project, [The Knight Foundation](http://knightfoundation.org) (the webapp is a subproject of a bigger project called *Spending Stories*). At the meeting we wanted to quickly give people an idea of what the webapp was all about.

Instead of giving people a fictional example of airports and education we decided to use real examples and link them to an amount people understand and if there is an amount hackers and activists understand then that amount would be the price of t-shirts with witty things printed on them. So we decided to print t-shirts with real examples on them.

But what to put on those t-shirts? There were three of us going to Palo Alto and each of us from a different country: Denmark (Anders), France (Anne-Lise), and Iceland (me). That's a great opportunity to give examples from all over te world (OK, not all over the world since we're all from Europe). We just needed to look at data we had for each of those countries in OpenSpending. Then we had to write those examples down and create some pretty images (or just use the ones we have in [OpenSpendingJS](http://jmblog.github.io/openspending-icons/) since they're awesome).

## Danish version

For Denmark we could look at all of the different municipalities and their spending. Made even easier by the ["Kend dine kommune"](http://kommune.politiken.dk/) project by the Politiken newspaper. After looking around tax revenue paid every year by an average inhabitant amounted to about 365 t-shirts. First example down! The resulting images and text:

![Danish t-shirt version](http://farm6.staticflickr.com/5472/10051615784_cd29f67cea_z.jpg)

Now here's one thing about that t-shirt. The image of the Little Mermaid (a monument for Copenhagen) is taken from [flaticon](http://www.flaticon.com/free-icon/little-mermaid-bronze-sculpture-in-denmark_852) and appears to be licensed under Creative Commons Attribution and the designer is said to be *Freepik*.

The problem with that is that *"Freepik is a search engine that helps graphic and web designers to locate high quality photos, vectors, illustrations and PSD files for their creative projects."* It's not a designer. So I didn't want to attribute this incorrectly on a printed t-shirt (I probably should have just gone with a silhouette of Denmark but it's too late now). Anyways. See this as an attribution to Freepik but also me asking who the real designer is since I want to attribute the designer and not the search engine (and reimburse that designer for not attributing on the t-shirt).

## French version

France was slightly more difficult than Denmark. There was no good data in OpenSpending -- look at this as a call for action if you're from France! However Anne-Lise pointed out a recent scandal that had popped up recently surrounding [a charity website by Carla Bruni-Sarkozy](http://www.theguardian.com/culture/2013/jul/26/carla-bruni-sarkozy-foundation-website). The cost of this charity website was about €410,000 which is way more than you'd need to create a WordPress site. What's worse is that she paid for this site while she was France's first lady... and she paid for it with public money!

Nicolas Bousquet (a web designer quoted in the news article) said anyone could have built this site for less than €10,000. With those amounts in hand we could mix them up with the estimated number of homeless children in France:

![French t-shirt version](http://farm8.staticflickr.com/7294/10051656555_ab26986260_o.png)

## Icelandic version

Icelandic version was simpler since OpenSpending had data on [how much was spent my ministries in Iceland in 2012](http://openspending.org/uppgjor-rikissjods). These were probably the simplest calculations but the most interesting amount is probably how much the government spends on the welfare system since that's where it spends the most money (Nordic welfare system ftw!) even though our national hospital is almost bankrupt. Anyways looking at those numbers and how much Icelanders spent on average every second in the welfare system this was the result:

![Icelandic t-shirt version](http://farm8.staticflickr.com/7324/10051762113_4932787e19_o.png)

## Final t-shirts

So how did the t-shirts come out. Well, me being the perfectionist I am not as I had hoped but they were still awesome. We were going to have colour versions with better prints but when the t-shirt printer called to let me know they wouldn't be able to print this because of details in the pictures I had to improvise a little. Since the graphics were all based on a specific price I had to go with normal prints on white t-shirts of better quality than the coloured t-shirts (got those for the same price). Nonetheless, the resulting t-shirts are still awesome:

![Printed t-shirts](http://farm8.staticflickr.com/7422/10051762633_de55735d23_o.jpg)

## Bonus

It was really fun finding these examples and there were a lot of different ideas that came up. But since I mentioned airports in the initial fictional example I thought I'd throw in a t-shirt version that's connected to airports. It's an alternative French version (the looks aren't the same since this was scrapped before fixing fonts and adding logos):

![Alternative French version](http://farm4.staticflickr.com/3785/10051687156_5e833d57e6_z.jpg)

