---
redirect_from: /2013/08/new-york-comptroller/
title: New York State Comptroller Using Open Data and Models to Track Local Government
  Finances
authors:
- Marc Joffe
---
In the wake of Detroit’s bankruptcy filing, many are wondering which city will be next. Thanks to an innovative fiscal transparency project undertaken by the New York State Comptroller’s Office, it is unlikely that the next municipal bankruptcy will occur in “Empire” State.

Earlier this year, the Office started publishing 23 fiscal stress indicators for local governments along with summary scores derived from a weighted average of these indicators. Nine of the indicators are fiscal metrics, such as the ratio of debt service expenses to revenue. The other fourteen indicators are “environmental factors” mostly taken from Census data. They include measures of property values, unemployment, and child poverty. The [scoring data](http://www.osc.state.ny.us/localgov/fiscalmonitoring/excel/AllDataWorkbook.xls) for 900 New York State local governments is available in a large Excel workbook. The Comptroller’s local government [fiscal distress scoring methodology](http://www.osc.state.ny.us/localgov/pubs/fiscalmonitoring/pdf/fiscalstressmonitoring2013.pdf) is also available.

According to Nathaalie Carey, Assistant Comptroller for Local Government and School Accountability, the scoring system arose from a collaboration between statisticians and auditors working in the division. Their work began by investigating what had already been done elsewhere. One source of inspiration, ironically, was a fiscal scoring project in Michigan. Until fiscal 2009, the Michigan Treasury department published fiscal distress scores based on [ten indicators](http://www.michigan.gov/treasury/0,1607,7-121-1751_47023-171423--,00.html). We do not know why this effort was discontinued, but do note that the Michigan system showed Detroit as an elevated risk in the final 2009 survey. The New York team was also influenced by work done at the International City/Council Management Association (ICMA). After developing their fiscal stress model, department staff solicited comments from academics, think tanks, and municipal leaders. 

In addition to the stress monitoring system, the Comptroller’s office promotes transparency through its [Open Book New York](http://www.openbooknewyork.com/) web site. This site allows users to see revenue and expenditure breakdowns by category for each local government. It also provides state level spending and contracts by state agency. This raw data enables researchers and the general public to investigate government spending priorities and to see how much money is flowing to specific contractors.

Overall, the New York State Comptroller’s Office is providing citizens with copious amounts of free, machine-readable government spending data. Further, they use a fully transparent methodology to boil down the statistics into a single, clearly understandable fiscal health score. We hope that other states, provinces, and central governments worldwide gain inspiration from New York’s example. 

