---
authors:
- anders
redirect_from: /2013/06/How-to-understand-data-from-EIB/
title: How to understand data from the EIB - what does the data tell us?
---

<iframe width='500' height='400' src='http://openspending.org/eib-energy-lending/embed?widget=bubbletree&state=%7B%22drilldowns%22%3A%5B%22category%22%2C%22location%22%2C%22year%22%2C%22project-name%22%5D%2C%22year%22%3A2011%2C%22cuts%22%3A%7B%7D%7D&width=500&height=400' frameborder='0'></iframe>

This is a guest post by Anna Roggenbuck from [Bankwatch](http://bankwatch.org/). 
<br>
The European Investment Bank (EIB) is the house bank of the EU. It has a lending portfolio of about 60 billion euros annually, about 90 percent of which go to projects within the EU.

For each project the EIB is considering to finance, it publishes on its website basic data including a description of the project, its location, the amount of EIB financing, in most cases the loan beneficiary and where relevant environmental impact assessments. The data has its limitations: no machine-readable data is readily available, and it is not possible to aggregate loan volumes.

Machine-readable datasets for individual industry sectors are available on request, though not for all industry sectors (no transport database for instance) and you’ll have to wait one month for the file. With these files you can relatively quickly aggregate and examine EIB lending in a certain country or region like old or new Member States and for different years. Slightly more complex, but still very much possible, is collecting data for sub-sectors (e.g. renewable energy). This is particularly useful if comparing for instance energy efficiency lending in the old Member States of the western EU versus the new Member States, where the potential of and need for energy efficiency measures is much higher.

EIB loans for energy efficiency projects 2007-2011:<br>
- Old EU member states (EU 15): EUR 1,429 million<br>
- New EU member states (EU 12): EUR 354 million<br>

At the same time, the data provided by the EIB is relatively sparse, and the files notably do not include the names of loan beneficiaries, which would allow assessing whether any companies receive particularly extensive EIB support and in which countries these are based. 

Another problem is how the EIB categorises projects. Even though the bank uses an official Eurostat classification system (NACE), inconsistencies and unclear attributions create a much rosier picture about the bank’s lending. (See more details for the energy sector lending below.) Note that for a more critical assessment or investigation one needs to consult additional materials like project summaries, EIB project assessment reports (only available on request), or a project promoter’s website.

###Why is it important to analyse the EIB’s classifications? 

Take the EIB energy lending as an example. The EIB boldly states that it is a leading institution in the fight against climate change. While the bank does lend significant amounts for renewable energy projects, it also finances a large number of climate-damaging projects. 

What the EIB categorises as clean energy is often not clear. This is especially the case when portions of a particular loan are attributed to different, often conflicting EU priorities like financing for renewable energy and energy efficiency on the one hand and security of energy supply (to EU countries) and trans-European energy networks like gas or oil pipelines on the other hand.

By assessing each project individually, we found the following underlying trends in the EIB’s overstated green energy lending:

###1. Unclear classifications

Quite a number of projects in the EIB database we simply removed because they did not seem to be related to energy, let alone renewable energy. For example the [Poland Forestry and Environment project](http://www.eib.org/projects/pipeline/2011/20110329.htm) aims at rural development and includes “afforestation, improved forest management and protection, and small-scale rural and agricultural infrastructure”. The project is classified as renewable energy in the EIB’s database, but after examining all the information we could find, it is inexplicable how the programme relates to renewable energy development. 

Confronted with our criticism of its classifications, the EIB argued that Bankwatch analysis is misleading as it lowers EIB’s support to renewable energy (by not considering large hydro and waste to energy projects) and to energy efficiency projects (by neglecting efficiency gains of new co-generation projects). Bankwatch explained that its methodology focuses on sustainability objective (what was an accusation from the EIB side) thus it takes into account wider impacts of projects, like biodiversity impacts of big dams or climate impact of new, greenfield fossil fuel power stations (even if they are considered more efficient than old ones, they are still new fossil fuel plants). EIB accused Banwkatch methodology of not being in line with EU policy (methodology) however Bankwatch had made its methodology transparent and explained main differences and justification for the methodology chosen. 

###2. Very broad strokes

In some cases, financing that clearly did not go to renewable energy sources was nonetheless added to the renewables figure, even though renewables was just part of that loan. In case of [a project with the Italian power company ENEL](http://www.eib.org/projects/pipeline/2006/20060248.htm) the EIB assigned the loan to “Renewable energy” even though more than 50% of the total loan of 450 million Euro was aiming at fossil fuels. (See the excerpt from the EIB’s database below. Irrelevant columns were deleted to reduce space.)

<a href="http://www.flickr.com/photos/94746900@N06/9024498649/" title="eib table by anderspedersenOKF, on Flickr"><img src="http://farm9.staticflickr.com/8129/9024498649_ce560d1a7e_z.jpg" width="640" height="197" alt="eib table"></a>
<br>
###3. Compartmentalisation

Somewhat in contrast to point two, the EIB in many cases focuses too narrowly on the specific activity they finance rather than taking the impact of a project as a whole into account. 

For example, a loan over 500 million euros in 2007 for the construction of [a new boiler at the Power Plant Karlsruhe](http://www.eib.org/projects/pipeline/2006/20060303.htm) is considered energy efficiency (and thus boosts the bank’s ‘green energy lending’) even though the project leads to an overall increase in CO2 emissions. 
 
This is especially problematic in the case of greenfield power plants in developing or transition countries that often have a significant potential to increase energy efficiency. EIB money that could be used for measures to decrease energy loss and consumption, has instead financed new and more efficient (or ‘less inefficient’) fossil fuel fired power plants to address growing energy demand.

###What further questions can we ask?

While the EIB's 2011 energy figures have improved over previous years, the share of fossil fuels is variable when considered over a longer period of time. It will be interesting to see whether the positive trend from 2011 continues. 

Up to 30 percent of EIB financing is offered as ‘global loans’ to intermediary institutions like commercial banks and different investment funds. Details for such activities are almost never available due to confidentiality provisions by the financial institution. A more in-depth investigation into these loans and the financial intermediaries could offer insightful information on how climate-friendly the EIB’s global loans are. 
