---
redirect_from: /2013/06/amsterdam-citizen-budget/
title: Budget monitoring in an Amsterdam neighborhood
---

Budget monitoring in an Amsterdam neighborhood
The Centre for Budget Monitoring and Citizen Participation (www.budgetmonitoring.nl) is a Dutch organization founded in December 2011. The foundation is the result of a co-operation between active citizens and social workers from the Netherlands and INESC from Brazil (www.inesc.org.br), supported by Oxfam Novib through E-Motive.
The Centre is rooted in the Dutch social movement and implements budget monitoring as a tool to enable citizen’s access to financial information, to promote social participation in public policy making and to monitor the spending of determined budgets of various governmental organizations. In this way, the centre attempts to strengthen civil society and enhance social participation.
Indische Buurt
In 2012 we started with an experiment in one of the neighborhoods in Amsterdam, called Indische Buurt. The Indische Buurt was chosen for the experiment on budget monitoring for various reasons. For example, many active citizen groups, called communities exist and are active within the neighbourhood. These groups already work hard to improve their neighbourhood and are actively developing numerous instruments on participation. Budget monitoring suits their approach well.
Besides, these communities take on a very specific starting point in their work; namely, the citizen and his right on ambition, which can be fulfilled in several ways in his neighbourhood. The communities play an important role to fulfil these ambitions. Budget monitoring and participation contribute to the right of ambitions.
And finally, budget monitoring cannot be implemented as an instrument on its own: it has to be rooted in social movement. The communities in the Indische buurt were already active within various areas therefore, it has been convenient to experiment with budget monitoring in collaboration with these active groups.  

To start the experiment on budget monitoring based on the methodology of INESC it was necessary to translate the methodology for the Netherlands into a roadmap. The university of Applied Sciences of Amsterdam developed the roadmap Budget Monitoring based on the methodology of INESC , and adapted it to the Dutch situation, after discussions with the communities in the Indische Buurt. In the roadmap, the emphasis is placed on social justice and civic participation and less on human rights in comparison to the methodology of INESC. Budget monitoring comprises of five steps.

The steps towards budget monitoring
In the first step we tried to localize public budgets. This was not very easy because budgets and information about spending are not (yet) transparent in the Netherlands. So, we had to search for information in PDF-documents. In Amsterdam the annual reports and budgets, as well as ‘5 and 9-months reports’ and reports of meetings have to be published at www.oost.amsterdam.nl (and www.amsterdam.nl). It is very difficult to find the proper information, so an expert was needed to find the way in the 1000 pages on the sites. After a lot of research, we built a simple database. This database also included projects in the city of Amsterdam, concentrating on neighborhoods. 
In the second step we analyzed the database to understand the budget for the Indische Buurt. We were unable to find all the budgets that were spent in the neighborhood. This turned out to be a common problem with civil servants. As a civil servant told us in January 2012: “We don’t know the budget for the Indische Buurt, every civil servant just knows his own budget”.
This heavy conclusion was also the reason for the local district to start a research on this subject. The result was a pilot on neighborhood budgets. In the next blog we will write more about this. 
During the third step we organized a training. The participants of the training were spokespersons of communities and other community members. The subjects matters were: budget cycle, annual report, annual budget. And other subjects, such as how to influence politics, how to make a plan for the neighbourhood?

Part of the training was the practice and theory of budget monitoring in Brazil, by trainers of INESC who showed the group the emphasis on political influence and advocacy. During the training we started to analyze the data available on budgets. For example, we compared the budget of the local district 2011 with the budget of 2013. We also studied a list of subsidies from the city of Amsterdam and the Ministery of internal affairs for the Indische Buurt.

In the meantime, we asked the local district to give us more information. The district, also began to conduct research. The first result of our request was a short version of the annual report 2011 with infographics.  
To make a proper Agenda the group decided that they had to know the priorities of the citizens. What do citizens want for their neighborhood? A questionnaire was made based on the results of several participation events in the Indische Buurt. 

After detecting the priorities of the citizens, we re-monitored the budget of the local district and re-analyzed the annual report of 2011. We did this by comparing the figures, the local district published. And we noticed, for example, that there was a big difference in 2011 between the budget and the spending of the budget on education, youth, and welfare. Altogether the difference was over 3,2 million euros.

On the basis of the findings during the training and questionnaire, the community members decided to make a perspective paper, with a long-term policy, instead of making just an Agenda for the neighbourhood. The training group used the financial data and went to the political board of the local district to ask questions about budgeting and spending. 
The report of this experiment and the questions the communities asked can be seen at: http://www.budgetmonitoring.nl/english/downloads/Brochure%20Budgetmonitoring%20(ENG).pdf.
The report also contains the way INESC is working on budgets from the perspective of human rights.

The experiment has now concluded. But, the communities and the Centre will keep working with budget monitoring. In the past 3 months things changed a lot. For example, the local district made a website containing facts and figures per neighbourhood. In our next blog we will pay attention on this subject. 

