---
redirect_from: /2013/06/french-press-aid/
title: Making sense of French press aid
---

This is a guest post by [Samuel Goëta](https://twitter.com/samgoeta), OKF France.

On May 22nd members of the [OKFN local group France](http://fr.okfn.org/) met at la Cantine, the digital hub of Paris, for visualising press aid data. This workshop held prior to a conference organised by the Social Media Club France on the efficiency on press aid for innovation in the media industry. The results of the 3-hour intensive workshop were presented right after to the audience and the speakers of the conference.

The press has received support in France since Second World War as it is considered critical for ensuring all opinions can circulate in society. These aids are direct subsidies as well as indirect in the form of tax breaks, reduced post fares and subsidised distribution. More recently, in April 2012, the press industry was granted the Strategic Found for the Development of the Press (fonds stratégique pour le développement de la presse) accounting for 60 millions euros of aid. This found was associated with a commitment to transparency, data on the 9 million euros spending, was published in April 2013 on the French [open data portal](http://data.gouv.fr).

<a href="http://www.flickr.com/photos/94746900@N06/8916665396/" title="photo (3) by anderspedersenOKF, on Flickr"><img src="http://farm6.staticflickr.com/5444/8916665396_25f7da44ca_o.jpg" width="640" height="478" alt="photo (3)"></a>

Following the publication of data on press aid, 5 members of OKF France got hands on the data available. Every participants had no previous experience with data visualization and did not even prepare this workshop. The challenge was to prove that, using open resources and with perseverance, one can visualise a complex system of subsidies in a couple of hours. Data cleansing was obviously the hardest part of the work as participants had little experience of handling data.

The workshop was divided in two groups, one using Open Spending to visualise data on an interactive treemap.

<iframe width='700' height='400' src='http://openspending.org/aidespresse3/embed?widget=treemap&state=%7B%22drilldowns%22%3A%5B%22Division%22%2C%22Nom_unique%22%5D%2C%22year%22%3A2012%2C%22cuts%22%3A%7B%7D%7D&width=700&height=400' frameborder='0'></iframe>

Another group used D3 Javascript library to map data on [an interactive bubble chart](http://okf.s3-website-eu-west-1.amazonaws.com/aidesalapresse/).

The presentation of the visualizations between the two roundtables of the conference raised great interests, as most speakers were speaking about data they could not visualize nor source. The results were directly [published on checkthis](http://checkthis.com/y2ci). The poster spread quite quickly as it reached 400 views in less than 24 hours. This workshop shows that mediation is crucial if we want to develop data literacy. Open data publishers should encourage and support such events as they can also benefit from simple visualisation everyone can use and understand. It also shows the limits of transparency on press aid: although aid is distributed for the development of innovation projects, the details of the funded projects are not mentioned. Officials state it could not be published based for trade secrets reasons. Also we were able to visualize only the tip of the iceberg as data is published for 30 millions € of press aid while total of direct and indirect aids accounts for 1,2 billion € in 2012. This workshop was a small, probably incomplete, effort to understand a complex and opaque funding system for sustaining an industry in the midst of massive changes.
