---
authors:
- martin
redirect_from: /2013/02/open-spending-in-morocco/
title: Opening Budgets in Morocco
---
This post is written by [Martin Keegan](https://twitter.com/mk270). 

In January I attended a conference in Morocco at the
[University of Mundiapolis in Casablanca](http://mundiapolis.ma/), to present OpenSpending. The
conference attracted a broad range of interests: civil society
organisations, journalists, private companies, academics and students,
the World Bank, and the director general of Morocco's Ministry of
Finance. My presentation ([notes here](http://mk.ucant.org/media/openspending-francais/)) showcased the use of OpenSpending in a variety of countries, by
state, civil and commercial actors. We are very generous to [Transparency
International Morocco](http://www.transparencymaroc.ma/) and the University
for their gracious invitation.

The conference covered the efforts in the country, the region and globally
towards fiscal transparency and accountability; there was much discussion of
the proposed Freedom of Information law in Morocco, and the Moroccan
government's efforts towards publishing fiscal data. Several of the
presentations incorporated technology demonstrations. There was some
local press coverage of the conference, and some involvement from broadcast
media (in
French
[1](http://www.lnt.ma/economie/la-transparence-budgetaire-au-centre-dune-rencontre-debat-63825.html)
and
[2](http://www.leconomiste.com/article/902383-la-transparence-budg-taire-fait-d-bat)).


What maybe was not clear to the audience (and indeed, the press
coverage reflected this) was how OpenSpending and similar tools fit
into the landscape.  I was directly asked "is the Government of
Morocco going to use OpenSpending?", and very firmly responded that
this was a question for the Government (after all, a representative of
the government was sat only a few paces away).  The boundary between
government and private sector (both commercial and civil society) is
always evolving and sometimes contested, and it may be locate differently
in different societies. OpenSpending enables actors of all types (government,
private commercial, private non-profit and individuals) to participate
in discussions of spending, and by changing the costs can help enable
some actors to participate where previously this was infeasible.

The key point why I made in response to this question is that a
Freedom of Information law can in theory substitute for
government-initiated publication of spending data, but that this
should be a complement, not a substitute. What I ought to have
remembered to say was that the access to information, either via FOI
or regular publication does not guarantee that the information be Open
Data, which is effectively necessary for civil society use in
OpenSpending.

It was the experience of [MySociety](http://mysociety.org) that their parliamentary monitoring
tools were never accused of being partisan. It's important to keep
out of conventional politics: we're here to say "if you have transparency,
this is what you get" not "you should have transparency" or "you should spend
more money on this and less on that". The bulk of my presentation was on
four or five country studies, demonstrating the diversity of the places
which can use OpenSpending.



The details of any national budget are a always a matter of healthy
political controversy, and this is [especially true of
Morocco](http://www.reuters.com/article/2012/11/18/us-morocco-protest-idUSBRE8AH0LX20121118). The Moroccan constitution contains an as yet unimplemented undertaking
to establish a Freedom of Information law. It still remains to be seen to what extent this will enable civil society in the future
to obtain more information about expenditures in the Moroccan national budget. In practise Freedom of Information laws will likely not do it alone. They tend often to allow the requester to specify the format of the material published,
or that it be published as open data. Where governments publish fiscal
information AND comply with an FOI law, it can be a [somewhat confrontational
move](http://constitution-unit.com/2011/05/24/we-can-work-it-out-eric-pickles-vs-nottingham-city-council/) to use the FOI laws to compel publication of fiscal data

It was exciting to see that Transparency International Morocco have used the OpenSpending software
for [a site on the Moroccan budget](http://floussna.ma/). They however encountered some challenges with the implementation, which the OpenSpending community will work with them
to help resolve or mitigate these such as language.
By the stage in the conference where the Moroccan OpenSpending instance was
demonstrated, the audience had been subjected to about ten other countries'
spending visualisations, so this presentation by Dr Nesh-Nash came across
as just more of the same, which is an excellent situation to be in. The
audience immediately took to noting that regional spending was arguably
misallocated in his visualisation: this is great progress on the previous
state of not having easy access to this information, and underlies the point
that the raw data, and interpretations thereof, are linked but separable.

[Samuel Lee from the World Bank demonstrated their new mobile app](http://openspending.org/blog/2013/01/29/worldbank-guest-post.html) and its Arabic language features, which was very well receieved from the participants. 
Ultimately it would be great if OpenSpending could have an Arabic translation; it's
an official language in about twenty countries, many of which don't
use multiple languages as in Morocco. The public role
of OpenSpending to explain budgetary data depends on its ability to be read in the
languages people use. We're therefore pushing for the localization of OpenSpending into
French as well as another 15 languages. You can check our progress and help contribute at our site on the
[translation platform Transifex](https://www.transifex.com/projects/p/openspending/).


Several participants at the conference placed a particular emphasis on what was termed
"[vulgarisation](http://fr.wikipedia.org/wiki/Vulgarisation)", by which
is meant the business of describing and explaining information intellgible
to experts such that the general public can understand it as well (the word
lacks the pejorative connotations it possesses in English). What this really
means is that in French the motivation of OpenSpending is expressible in
a *single word*. We look forward to follow the developments on budget transparency in Morocco. The broad participation at this conference served to show that the interest will remain strong. 




