---
authors:
- lucy
redirect_from: /2012/11/Sarajevo-Workshop-Writeup-2/
title: Day 2 OpenSpending CSO Workshop - Sarajevo
---

This blogpost is the second in the series of the OpenSpending workshop - Sarajevo. Read the [first post](http://openspending.org/blog/2012/11/26/Sarajevo-Workshop-Writeup.html) on the OpenSpending blog.

# Day 2 - Converting Data into Action & Finding Narratives in Data

The people we are trying to target with this data are bombarded constantly from every side with data, numbers statistics - what they need is *narratives*, things that stick in their mind when they leave your website. This is the theme of day 2 - How to convert data into action: how to find the times at which people will be receptive to your message, and how to create a narrative they will remember. To get things rolling, we have a quick look at some of the other projects going on around the world, and play a game to see how much information people can extract from a visualisation in 30 seconds.

<iframe src="http://www.slideshare.net/slideshow/embed_code/15349310" width="427" height="356" frameborder="0" marginwidth="0" marginheight="0" scrolling="no" style="border:1px solid #CCC;border-width:1px 1px 0;margin-bottom:5px" allowfullscreen webkitallowfullscreen mozallowfullscreen> </iframe> <div style="margin-bottom:5px"> <strong> <a href="http://www.slideshare.net/lucyfedia/visualising-budgets" title="Visualising budgets" target="_blank">Visualising budgets</a> </strong> from <strong><a href="http://www.slideshare.net/lucyfedia" target="_blank">Lucy Chambers</a></strong> </div>

Before splitting off into two streams for the day: *technical* and *policy*, we quickly show everyone together how easy it is to upload and model your data using OpenSpending. If anyone missed it, or couldn't follow along due to our lovely and mighty wifi connection, we've [documented this](http://cameroon.openspending.org/en/contribute.html) extensively as part of the World Bank Cameroon project.

## Policy Stream
<table>
<tr><td><img alt="" src="http://farm9.staticflickr.com/8201/8219599019_4471d497a9_c.jpg" title="Data into action - Mindmap" class="alignnone" width="500" height="500" /></td></tr>
<tr><td class="caption">You can see the full-sized file <a href="http://www.flickr.com/photos/okfn/8219599019/sizes/c/in/photostream/">on our Flickr Stream</a></td></tr>
</table>

The policy stream highlight the areas they are interested in capturing in their projects, from international comparisons, to naming and shaming and then ask the key question: "Who cares?" - to work out who we should be targeting and via which medium. Secondly, we did a deeper dive into some of the problems experienced by the various projects, including how to get the data you require when the people giving it to you know you are competent enough to find scandal in it.

<img alt="" src="http://farm9.staticflickr.com/8201/8219558127_da6049c827_m.jpg" title="Slide from Tony Bowden's Talk" class="pull-right" style="margin-left: 1em;" />

### Targeting citizens with your project

**PERSONAL BELIEF ALERT!** It's a blunt statement, but I'm going to put it out there anyway: I believe citizens don't care about budgets. At least, they don't care about budgets at large, the majority of the time. When numbers are presented to them as ten figure numbers, it is very tricky for them to identify with as they don't relate to things of a size of anything familiar: A household budget, the turnover of their business. 

What citizens might sometimes care about is the overall funding priorities of the government as this affects the services they require from government - is my government spending more on defence than it is on hospitals or schools? Journalists have a nose for this, they can feel when people are likely to be receptive to messages like these, and we at OpenSpending often see a traffic spike around the budget times of various countries as they embed our visualisations in their sites and as policy makers themselves use the visualisations to explain freshly drafted budgets to other policymakers (no jokes). 

So, the challenge is: beyond key points in the budget year, how do we keep people interested in how their government spends their tax money? What they might care about is particular things, often **services**, such as hospitals or schools, which they might want improving. We, as policy people and techies, who are prepared to crunch the numbers, deliver them in a way which connects them to the services people care about? 

### Targeting the experts

There are however, plenty of people who do care about the real numbers - NGOs, Researchers, Internet Activists and Policy Wonks - is there a way that some of our projects can remove the headaches for working with data for these groups? At OpenSpending - we've already seen a demand for the ability to search transactions for [supplier information](http://openspending.org/blog/2012/02/24/how-spending-stories-fact-checks-big-brother-the-wiretappers-ball.html), and via the mailing list, we're collecting a list of questions which other people would like to be able to answer. Could organisations such as the ones at the workshop, actually become a better source for this type of data than governments themselves if they can combine it, present it and query it better? 

## Technical Stream

The technical stream split off for an action-packed day. They cover an introduction to [DataWrapper](http://datawrapper.de/) for making simple charts and web visualisations, [Kartograph](http://kartograph.org/) for making elegant maps, Scraping using [ScraperWiki](http://scraperwiki.com/), using Optical Character Recognition to get data out of PDFs and cleaning data using [Google Refine](http://code.google.com/p/google-refine/). All before 5:30 :)

## Project Proposals

The wrapup activity for Day 2 was a Dream Project proposal. If money and data were no object, what would the participants build? A variety of projects, from a Fix My Street-esque project for Bosnia, could be used to produce some alternative performance statistics for various project to rethinking how budget laws were made, so that they had to be submitted as small pieces of code.

While the suggestion from the group from CRTA and Tony Bowden to build on their project tracking site by equipping kids with cameras to take pictures of broken parts of playparks was, I believe, intended largely jokingly, I can't help wondering whether encouraging kids as part of their school projects to take part in these projects might not be a bad idea. Other large management consultancy companies use this technique and besides just collecting data, you are teaching the kids to be active citizens. I shall continue to ponder...

