---
authors:
- friedrich
redirect_from: /2012/10/open-interests/
title: Open Interests Hackathon - November 24-25, London, England
---

As a journalist, to understand European Union institutions, policies and commitments, you have to look where the money goes and understand who affects the money flow in the EU. As the influence of Brussels lobbyists grows, it is increasingly important to draw the connections between lobbying, policy-making and funding. [The EU publishes information on its spending](http://ec.europa.eu/beneficiaries/fts/index_en.htm) and also maintains a [transparency register](http://europa.eu/transparency-register/). These, however, are difficult for journalists and citizens to use. 

With [OpenSpending](http://openspending.org/), we set out to use the power of technology to catalyze greater government transparency by providing new tools for media and citizens to more easily access government data in searchable, sortable and machine readable formats. 

<img alt="Hackday-thumb-800x600-2721.jpeg" img class=caption src="http://www.pbs.org/idealab/Hackday-thumb-800x600-2721.jpeg" title="The Open Interests Hackday is just the latest in a series of events aimed at encouraging journalists to work with data. In this image, programmers and designers gather at the OKFestival in Helsinki." />

One step on our road to achieving this goal is a "hackathon" where we aim to build tools that will help the media and citizens investigate the influence of Brussels lobbyists and where the money goes in the EU. [Open Interests Europe](http://okfnlabs.org/events/hackdays/lobbying.html), which will take place on November 24-25 at the Google Campus Cafe in London, brings together developers, designers, activists, journalists and other geeks for two days of collaboration, learning, fun, intense hacking and app building.

Below are some of the projects we will be working on.

## The Lobby Transparency Challenge

Within any political process there are many interests wanting to be heard -- companies, trade unions, NGOs -- and Brussels is no exception. Corporate Europe Observatory, Friends of the Earth Europe and LobbyControl have begun to data-mine the lobby registers of the European Commission and of the European Parliament to find out who the lobbyists are, what they want, and how much they are investing. Participants will have the exclusive opportunity to work with this data before it is made public in their upcoming portal. 

## The Fish Subsidies Challenge

Subsidies paid to owners of fishing vessels and others working in the fishing industry under the European Union's common fisheries policy amount to approximately 1 billion euros ($1.3 billion) a year. EU Transparency gathered detailed data relating to payments and recipients of fisheries subsidies in every EU member state from multiple sources, from European Commission databases to member state government databases and inter-governmental fishery organizations such as ICCAT. Participants will have the opportunity to build maps, visualizations and apps with this data. 

There will be prizes and interesting talks by jury members [Rufus Pollock](https://twitter.com/rufuspollock), co-founder and director of the [Open Knowledge Foundation](http://okfn.org/), and [Alastair Dant](https://twitter.com/ajdant), lead interactive technologist for the Guardian. The hackathon is organized by the [European Journalism Centre](http://www.ejc.nl/) and the Open Knowledge Foundation, and sponsored by [Knight-Mozilla OpenNews](http://www.mozillaopennews.org/). 

*You can find out more details on the [event webpage](http://okfnlabs.org/events/hackdays/lobbying.html). If you'd like to join us and help build these tools, please register [here](http://openinterests.eventbrite.com/).* 