---
authors:
- federico
redirect_from: /2012/10/publicidad-oficial/
title: PROFILE - 'Publicidad Oficial' - Official Advertising, Fundar, Mexico
---

**At Open Knowledge Festival, Federico Ramírez from Mexico presented Fundar's project on uncovering which government parties were using taxpayers's money to
finance their PR and advertising. In this post, based on an interview [Velichka Dimitrova](https://twitter.com/vndimitrova) did when she went out to Mexico for [OpenDataMx](http://blog.okfn.org/2012/09/04/opendatamx/), the Fundar team have delved deeper to talk about how this project came about, and hopefully inspire other organizations to tackle the issue in other countries.**

> “Government advertising should be understood as a communication channel between the government and citizens. It should be clear, objective, easy to understand, necessary, useful and relevant to the public. It should not promote, explicitly or
implicitly, the interests of any party or government”. [*]

## Vital Facts

* *URL*: <http://publicidadoficial.com.mx/>
* *Country*: Mexico
* *Scope*: Federal and state budget
* *Who*: Campaign implemented by [Fundar](http://fundar.org.mx/), [Article 19](http://www.article19.org/ ) and the Open Society Justice Initiative.
* *Contact*: [Justine Dupuys](mailto:justine@fundar.org.mx) (Fundar)

<img alt="" src="http://farm9.staticflickr.com/8319/8046507275_7876f2b14e_z.jpg" title="Publicidad Oficial" width="640" height="480" />

## What is the Background of the Project?

*'Publicidad Oficial'* is the expenditure of the government on public advertising. Fundar was particularly concerned that a lot of money in Mexico was being spent in promoting its own work and own image through public advertising, and aimed to tackle this. In Latin America, government advertising is often contentious: the relationship between the government and the media has frequently come under scrutiny. The amount spent on government advertising is very high in Mexico; in 2011, about 5027 million Mexican pesos / 385 million US dollars was spent, 75% of which went directly to television and radio broadcasting. During the past 12 years in Mexico there has been a huge discussion on how to take public money out of private (media) hands.

In 2007, the Mexican constitution was changed to incorporate a ban on government advertising during political campaigns (Art.41) and also a ban on public servants (especially key executive officers, including thePresident, state governors, and municipal authorities) from appearing on
official publicity campaigns (Art. 134). The reasons for the reform included the abuse of official publicity as a resource for electoral campaigning. During the Mexican Presidential Elections in 2006 the five candidates aired 757,572 spots on radio and TV, while the Mexican President aired approximately 462,000 spots (2/3 of all such spots) publicising his image and governmental actions on social programs. Local governments also aired an unknown number of spots with similar characteristics, but they were not counted. It is important to highlight that this publicity was paid for with public resources.

This is why this campaign is really important: it is not just about showing how much the government spends in this particular area, but it is also about measuring the impact of these continuous violations of this constitutional article e.g. on freedom of expression.

[Read more on rules regulating government advertising in Mexico.](http://publicidadoficial.com.mx/como-se-regula-a-nivel-nacional)

## What are the aims?

Fundar approached this campaign with two concerns:

* The first one is the concern about how the government spends its money in a more general context.
* The second concern is about the structural framework of democracy and the role of the media, as well as the relationship of the political parties and the media.

There are two steps involved in tackling these concerns:

* *Step 1:* Creating fair rules on how the governments can spend money on government advertising
* *Step 2:* Promoting information instead of propaganda in government advertising.

A feasible goal for the project has been to gather data and evidence, which has not been available for government spending before and to provide it to civil society and the general public. In working with the data, there have been two aims:

* Show what kind of data exists: get the numbers on government media spending.
* Denounce those parts of the government who refuse to provide the data for political reasons: show where the gaps are and where lack of transparency (opacidad) exist.

## What kind of data and how to get it?

The government does not release government advertising data for several reasons:

* Deficient government accounting in Mexico due to structural problems in the bureaucracy.
* Trying to avoid political conflict, as in many states the media are not primarily a commercial, but a political actor, which can put a lot of pressure on the government.
* As some media is also owned by government officials, there is unwillingness to release the data which would reveal these connections and ownerships.

A collective of organizations has worked on this topic since a while, but there have been no numbers to serve as evidence. For the Mexican civil society it is not very common to gather data and to try to provide it in some usable format.

Learning from these organizations who were already involved in this discourse and had the political message, Fundar got the data as evidence.

The data was obtained by Freedom of Information (FOI) requests, where some cases were brought even before the Supreme Court, which has to decide on the balance of public and private interest and whether the government had the right to protect information as a part of commercial negotiation. This aspect was contested by civil society, as public tenders should be public knowledge. In some cases a few FOI requests were done for the same kind of data in order to find whether there were any discrepancies.

## Features

The website of Publicidad Oficial offers:

* A map and an index of transparency for all Mexican states (the red states are
where no information has been obtained)


<img alt="" src="http://farm9.staticflickr.com/8041/7982235586_48c8e1e095_z.jpg
" title="Advertising Map Mexico" class="alignnone" width="640" height="480" />

* [Data on the government advertising of the federal
government](http://publicidadoficial.com.mx/gasto-federal)

<table class="image">
<tr><td><img alt="" src="http://farm9.staticflickr.com/8295/7982232561_e58d7aca44_z.jpg" title="Access to information Index" class="alignnone" width="640" height="480" /></td></tr>
<tr><td class="caption">(Above) Index of access to spending information on government advertising per category: 11 of the Mexican states did not provide any information (0 stars). Only 2 Mexican states provide all the information - 5 stars.</td></tr>
</table>

## Taxonomy of Data Problems - why was it difficult to work with the data?

There were 3 main types of problems in working with the data:

* Political Problems: it is often difficult to track how much money goes to a particular commercial entity. If ghost entities / businesses are created it might not be possible to track the spending to the actual company, as there is no actual proof for connecting the transaction back to them.
* Legal Problems: related to the legality of opening up government spending data when this data is related to a commercial negotiation. A lot of litigation currently is about the government disputing whether some tenders should be protected because of subject to a commercial contract secret.
* Technical / Operative Problems: from issues about transcribing PDF into spreadsheet format to diverging data formats, data quality and availability,
resulting from the fact that Mexican states have different transparency laws and data standards.
* Access to information problems: the discrepancies between the data have posed a problem of reliability of the information we access.

Additionally, fragmentation of the data is also an issue, as data is provided in PDF format for every state, every 6 months, separately for each programme and it is not available to download in bulk format or accessible through API. Often the technical requirements for open data are too specialised and too complicated for CSOs with limited technical capacity and the non-technical staff of the government.

## Relevance, Audiences and User-groups

The website of Publicidad Oficial has become the official source of information on government advertising in Mexico - it is practically the only source. Even the presidential candidates and the media itself cites Fundar as the source of the data.

During the latest presidential elections there has been a polemic about the candidate’s expenditure on the media where candidates have been discussing who is in fact spending more on the media campaign. One candidate has even accused another of being a project of the television media: “If the television makes presidents, you would be a president”.

Users of the webpage and involved stakeholders in the campaign were journalists, researchers, other civil society organisations as well as political parties.

## The Role of Technology

In order to justify having more technical staff in the organisation, one should find more purposes beyond the experimental use of the technology. While there is a need to develop the technological skills of civil society, these should be complementary
to their advocacy skills. Technology is just one of the tools for advocacy.

## Successes

1) Having raised public awareness – government spending on the media is a public and national topic, especially in the time of the electoral campaigns where this kind of transparency is called for.

2) The opportunity to be the most important and respected source for this information and having provoked the winning candidate to take this issue forward with the new government.

3) Having broken the traditional barriers that Fundar faces when trying to reach out to more people in creating a website with its own audience.

## Failures

1) Despite the public awareness and national discussion, no legislation /public policy have been created to solve the problem. The question of how to convert the discussion into tangible results still remains. It does exist a lot of draft bill on the subject, but no one has been passed. See: <http://publicidadoficial.com.mx/iniciativas> for more details.

2) Not having shown the data in a more creative way, related directly to the problems in the communication between the non-technical researchers and the technical staff. A more collaborative way of work should be explored.

3)  Not having been able to create and maintain a bigger coalition as a stable process. Involving other actors and sharing one’s political capital has been challenging, as other organisations might have felt they have been invited to “someone else’s party”.

[*] [Basic Principles for the regulation of advertising, ADC.](http://www.censuraindirecta.org.ar/advf/documentos/4804c757c7e629.40711373.pdf)

## Lessons learned

We asked Justine Dupuys from the project what advice she would give to organisations embarking on similar missions in other countries. Here is what she suggested:

1) It is really important to clearly define government advertising and what is acceptable use.

2) In order to fulfil investigation’s objectives, we made a lot of FOI requests at federal and local levels. We suggest [constructing a very complete database with all the deadlines](https://docs.google.com/spreadsheet/ccc?key=0AvoV_cBqwo28dHMwUUQybms4Z3dxZ2hDMGQ2Tm5ucGc). It will help to follow up on these requests.

3) Communication strategy for releasing the findings on governmental advertising is complicated. Traditional media are reluctant to inform on this issue because they are taking advantages of this situation. My suggestion is to think about creative way of communicate. It is the reason why we implemented a website and used social media [@publioficial](https://twitter.com/PubliOficial).

*Our aim at OpenSpending is to bring together people working all over the world, be they techies or advocacy organisations, to find common patterns and solutions in how to work with and glean answers from publicly available data. Know someone we should contact? [Get in touch](http://lists.okfn.org/mailman/listinfo/openspending).*