---
authors:
- raimo
redirect_from: /2012/09/participatory-budgeting-finland/
title: First steps for Participatory Budgeting in Finland
---

**This post is written by [Raimo Muurinen](https://twitter.com/ra__mu) and [Henri Ahti](https://twitter.com/HenriAhti) who are taking a lead on one of Finland’s first Participatory Budgeting (PB) projects with Helsinki City Library. The post comes just as we prepare for Tiago Peixoto’s (aka [@participatory](https://twitter.com/participatory)) keynote and talk on [how to involve citizens in the budget making process](http://okfestival.org/participatory-budgeting/) at OKFestival.**

## How did the project get going? 

In April 2012, the Finnish innovation fund [Sitra](http://www.sitra.fi/en) organized [the first participatory budgeting process in Finland](http://www.sitra.fi/artikkelit/2012/osallistuva-budjetointi). As a result, among few others, a new PB project was elected to receive funding. [Helsinki City Library](http://www.lib.hel.fi/en-GB/) users now have the chance to plan and decide projects for the upcoming new [central library](http://keskustakirjasto.fi/en/).

## Why is this necessary and why should it happen now?

At the end of 2011, the [Democracy Group of the City of Helsinki](http://demokratia.hel.fi/english), led by mayor Jussi Pajunen, published a report saying PB has not been used previously in Finland. Except for, with a broad understanding, the area of the northernmost city of Finland, Rovaniemi, where regional boards have a strong role in budgeting.

<img alt="" src="http://farm9.staticflickr.com/8038/7992581440_b0f417be88_n.jpg" title="OsallistuvaBudjetointi" class="pull-left" style="margin-right: 1em" width="320" height="90" />


At the same time Sitra, a Finnish innovation fund, took a more practical approach to the matter. Between August 2011 and April 2012 they organized, the [New Democracy Forum](http://www.sitra.fi/en/new-democracy), which examined and sought for a 'new type of democracy' with 30 guest participants invited from different fields of expertise. A varied group of journalists, members of the parliament, public administration officials, SME CEOs and citizen activists among others heard about the concept of participatory budgeting and as a result, Sitra decided to organize a small-scale experiment, as it had budgeted ca. 100,000 euros for the arising new democracy initiatives. 16 proposals for new democracy projects qualified for voting, where the forum participants, spokespeople for the projects and a few employees from Sitra had each one vote per person. The voters were to vote for a list of ten preferable projects to receive funding. Prior to voting, all the projects’ spokespeople had pitched their projects. As a result, [Avoin ministeriö](http://www.avoinministerio.fi/) (Open Ministry), [Sosiaalinen hub](http://sosiaalinenhub.wordpress.com/) (Social Hub) and our Participatory Budgeting proposition for the Central Library were voted to receive funding.

## Who will be involved in implementing it?

Behind the PB proposal were companies [Emobit Oy](http://emobit.fi/en) and [Avanto insight Oy](http://avanto.in/) as a partner and the Helsinki City Library as a client. The plan started with gathering information about PB and setting up a free and open resource site [osallistuvabudjetointi.fi](http://osallistuvabudjetointi.fi/), which is now running the early first version.

Emobit leads the project as contractual partner for Sitra, providing technical expertise for [OpenSpending](http://openspending.org/), which is used to visualize library spending from previous years with data from [Helsinki Region Infoshare](http://www.hri.fi/en/).

Avanto insight is responsible for planning the PB processess and is running the osallistuvabudjetointi.fi site. The company is a startup founded in 2011 and based in Tampere.

<iframe width='600' height='400' src='http://openspending.org/helsinki_city_library_2009_2011_1/embed?widget=treemap&state=%7B%22drilldown%22%3A%22kustannuspaikka%22%2C%22year%22%3A%222011%22%2C%22cuts%22%3A%7B%7D%7D&width=600&height=400' frameborder='0'></iframe>

## How will it work?

Focus is on allowing library users to participate on developing the new Central Library, which is currently waiting for the results of the architectural competition. At the moment, we are planning to hold 2-3 live sessions in different libraries. These will be open, creative participation sessions for anybody interested. The sessions will give people the possibility to create their own budget proposal and also draw on feedback from the [Dream! survey](http://keskustakirjasto.fi/en/2012/06/07/dream-the-central-library-to-reality-weekend-at-the-pavilion-16-17-june/) held at the beginning of 2012, where Helsinki residents were invited to design the type of urban space and culture they would like to see blossom in the library. Planning is conducted openly, as we publish all the documents freshly to the osallistuvabudjetointi.fi site, where it is possible to comment them and affect the execution.

[View the data on OpenSpending](http://openspending.org/helsinki_city_library_2009_2011_1)

*We’re looking forward to seeing some pictures from the living results of these sessions. Look out for Raimo, Henri and Tiago on Friday, 21st September at OKFestival. We hope that bringing these two groups together will spark a great discussion on the future of PB in Finland.* 
