---
authors:
- lucy
redirect_from: /2012/07/budapest-institute/
title: Athens to Berlin - PROFILE - Our Money, the Budapest Institute
---

**This post was written based on the contributions of Petra Reszkető, Balázs Váradi and Timea Sütő of the [Budapest Institute](http://www.budapestinstitute.eu/), Hungary. The video of their interview will be displayed as part of the complete series [Athens to Berlin](http://openspending.org/blog/2012/07/05/OSI.html).**

*The Budapest Institute is an independent think-thank. It produces public policy research and analyses to support policy-making in Hungary and in the Central-Eastern-European region. It is part of our mission to promote evidence-based policy-making and to try to make the national public policy discourse based more on facts rather then beliefs. This post is about the project 'A Mi Penzünk' which aims to present the budget spending of the Hungarian State simply and interactively to make it engaging for the interested layperson.*

[A Mi Penzünk's](http://amipenzunk.hu/) aim is to present financial data for the Hungarian State broken down by functions to provide information on what exactly tax money is spent on. With the visual presentation (thanks to the open software developed by the [Open Knowledge Foundation](http://okfn.org/)) of the budgetary expenses and with the database that can be mined and freely downloaded from the website.

## What is the aim?

Main policy goals of the project are the following:

* to make ’dry numbers’ digestible and illustrative by visualizing the Hungarian budget (spending lines)
* to dispel misbeliefs and popular fallacies on spending priorities of Hungarian governments by sharing information and providing policy narratives.

With this project we would like to contribute to the national tax consciousness and to the strengthening of civic responsibility. Our partners were the Open Knowledge Foundation (visualization software) and the Fiscal Responsibility Institute Budapest (converting and editing the database). The Budapest Institute for Policy Analysis started the project in June 2011, as a revival of an earlier, Hungarian initiative with the same name. 

<img alt="" src="http://farm8.staticflickr.com/7270/7656395574_10b7347f5e_b.jpg" title="A Mi Penzunk" class="alignnone" width="640" height="480" />

## Who is it targeted at?

First, we aim at informing young people (high school students) who are just now growing up to become tax paying citizens by orienting secondary school teachers with the tools and applications installed on the website.

For students we drew up “homework” exercises, and we also created visual aids, posters and other teaching materials to support the work of interested high school teachers. For journalists we provide some short essays introducing policy narratives on the raw budget data. 

Second, we would like to facilitate the work of journalists who may use this kind of information and data. One of the conclusions of the workshop with journalists and the following consultations with media representatives was that our initial idea turns to be a false hope. The level of data journalism is far below the EU average in Hungary and in addition, the  Hungarian media actors/ firms can not fit this rather seasonal content into their business model. We have learned that the Hungarian media is prone to get ready-made analytics and reports rather than to perform investigative projects on its own. 

## Why is it necessary?

In Hungary, policy debates and the media frequently discuss government expenditures. But factual, politically unbiased and easy-to-understand information about actual numbers and proportions is in short supply. Both electioneering and run-of-the-mill political communication is, to a large extent, about how much should be spent on schools and pensions, trains and healthcare. For the average citizen these statements are hard to interpret without points of reference. Are those sums too much or too little? Compared to what? What else could we spend the billions potentially saved on? During our work we have often had to face up to the fact that there is no convenient public database that would represent the budget of the Hungarian state. True, we are informed about the general budget from the current year’s budget law and, in the year after, the law on the final accounts. It is, however, quite a challenge to learn about the planned and actual costs and revenues broken down by the functions of government, not institutions, in a unified and transparent way. 

Usually if a tax-conscious Hungarian citizen wants to gather information on the central budget he or she can only do so upon patiently waiting for years, accessing the Central Statistical Office’s or the Eurostat’s homepage. There is unfortunately no public database available on the website of the Hungarian Government.

With this project not only that we provide up to date, accurate information organised in a downloadable database, but we present the data broken down in such way, that it becomes clear and easily understandable on which functional activities is the taxmoney spent (cf. COFOG standards), not - as it was customary before - which institutions receive it. 

## How did you get the data?

At the very start of the project we faced several challenges relating to accessing the official data. We struggled with the National Statistical Office and the Ministry of National Development for months, we finally had to ask for support of a later partner organization, the [Fiscal Responsibility Institute Budapest](http://www.kfib.hu/) in July 2011.  After an overlong awaiting for the data we cleaned and restructured the database according to our needs, and built the website.

## Features

The project:

* developed an online public information resource presenting information on public spending, thereby matching  a niche due to the lack of availability of any official public database
* applied and presented visualization software that make raw data easy to digest 
* contains two online [posters](http://amipenzunk.hu/front/poszter) downloadable from the website, one available in 50 printed A1 copies 
* Contains a feature called ['Your Dream Budget'](http://amipenzunk.hu/front/dream?country=AT) presenting the relationship between different expense items and 5 international comparisons, allowing you to assess the spending priorities of your government in comparision to other countries. 
* Entailed one media workshop, and two workshops with teachers and representatives of educational organizations
* Has social media profiles ([Facebook](https://www.facebook.com/pages/amipenzunkhu/186571038102340), [Twitter](https://twitter.com/amipenzunk).)

<img alt="" src="http://amipenzunk.hu/images/poszter.jpg" title="A Mi Penzunk Poster" class="alignnone" width="640" height="480" />

## What was the impact? 

In all this we have relied a great deal on the input of the participants of the three workshops we organized for teachers and journalists, and on the recommendations of peer colleagues. 

The workshops have proved that such projects can grab attention, and there is explicit need for follow up. However we have also learned that, contrary to our expectations, the real interest for our project is not shown by the media, but by teachers and NGOs with an educational profile.

For the time of being, we are in consultation with workshop participants from high schools and educational organizations (NGOs) and we are still receiving orders for the poster. 

The long term impact of this initiative can hardly be measured in a proper way, though the real immediate impact we hope can be demonstrated later by the webpage statistics (visitors, users of applications, downloads of data and poster) and by the steady demand for the poster to be ordered at re-production costs. [As of April 2012], since the website was officially published in mid January we have had over 10000 visitors out of which 16.66% are returning ones. 87.84% of our visitors are from Hungary, mainly from Budapest and the bigger cities.

## Where Next?

Based on the workshops and follow up consultations with teachers and educational experts, we drew the conclusion, that there is a real need: 

* for developing a comprehensive teaching modul (more teaching material explaining terms, clarifying definitions, class schedules, etc.)
* for extending the project to the revenue side (e.g. visualization, trade-off between revenues/taxes and expenditures, other interactive applications highlighting balance at the individual/ household level) 
* for creating English version of the website and providing more and deeper international analysis
* to update the database with fresh data for 2012, to create the English version of the website, and to develop another version of the webpage that would be accessible for people with disabilities.

## What could be done to make your work easier?

Based on our experience implementing this project the BI is interested in organising and/or participating in workshops focusing on issues like:

* working in an interdisciplinary scheme (developer-desinger-economist)
* developing applications and interactive tools – how to test them?
* enhancing usability / promoting techniques

Datawise, we also need data classified by function (i.e. programme)!

*Stay tuned for more updates from the [Athens to Berlin series](http://openspending.org/blog/2012/07/05/OSI.html) via the [OpenSpending Mailing List](http://openspending.org/blog/2012/07/27/budapest-institute.html).*







