---
authors:
- lucy
redirect_from: /2012/07/Romania/
title: Athens to Berlin - Romania's Money Mappers.
---

Although the people I meet here in Romania seem to dispute the fact - Bucharest has a very strong NGO scene. Corruption, both institutional and petty, comes high on the focus agenda as well as making citizens vaguely data-literate about how the government spends money and getting a good grasp on where the money comes from.

<img alt="" src="http://farm8.staticflickr.com/7139/7592671502_e50276d3e0_z.jpg" title="Dying for Freedom" class="alignnone" width="640" height="480" />

Andra Bucur from the Soros Foundation has kindly gathered together a group of some of the key players in the world of financial transparency together for a discussion on how . It's clearly a hot-topic and turns into more of a debate than an interview, which I am naturally delighted about :)

While I'm here, I meet:

* Andra Bucur - *[Soros Foundation, Romania](http://www.soros.org/about/offices-foundations/soros-foundation-romania)*, working on transparency in Revenues from Extractive Industries
* Bogdan Manolea - *Executive Director, [APTI (Association for Technology and Internet)](http://www.apti.ro/)*
* Cristina Lupu - *[Centre for Independent Journalism](http://www.cji.ro)*
* Codru Vrabie - *[Bribe Market](http://www.piatadespaga.ro/)*
* Elena Calistru - *[Lost Money (Bani Pierduti)](http://banipierduti.cloudapp.net/)*

Unfortunately, they couldn't join us on the day, but I also make a note with myself to check in with [Expert Forum](http://www.expertforum.ro/) and [Active Watch](http://www.activewatch.ro/), who focus on in-depth analysis of financial information.

## Highlights

### Lost Money

Elena Calistru's project, Lost Money, attempts to engage the public with the scary numbers behind the public budget. She says:

> "The public budget is something which is very complicated. For the average Romanian (and not only) it is usually this black hole where their money is spent, for roads, for public services and so on, without knowing exactly what happens there. So this platform tried to put everything there but in a very user-friendly manner with beautiful visualisations and by offering the user a personal experience of that complicated process of collecting taxes and spending them..."

I learn all manner of things about how budgets are calculated in Romania, for example, for school spending, standard costs per pupil have been introduced, with coefficients altering the amount based on the temperature of the region... There's also a *big* debate about whether the favourite topic - roads - should have standard prices per kilometre of road, would that actually solve anything, and would the average citizen care what was spent, as long as they could get from a to b?

<img alt="" src="http://farm9.staticflickr.com/8289/7607848026_21cbeef8ed_z.jpg" title="Lost Money by Elena Calistru" class="alignnone" width="640" height="480" />

Finding the right triggers to engage users is definitely a challenge and there's a consensus that Romanian citizens will only be interested if the data is given a personal angle. Elena's project contains a personal [tax calculator](http://banipierduti.cloudapp.net/calculator/), allowing users to input their salary and get an estimate for how much they contribute in taxes to various spending areas. But the bigger picture and research into big investments is still difficult to engage the public on. Here's Elena on one piece of feedback she got from a piece of her research:

> "We focused on several contracts, large investment contracts, and we showed that the road from Bucharest and the road surrounding Ploieşti, they paid a huge amount of money [...] I received a phonecall from one user... telling me: "Look, stop it with this, I don't care how much money they've spent here, it's the best road available here, I don't care". [...] It's not correct, they could have done more with that money..."

Participation is also something which comes up a lot as something the group are keen to promote, Elena describes how she tackles it in her project.

> [...] "We are now working on a feature where they can become a budget heroes [...] they will be able to see there that this law means cutting expenses of 1 bn Euros from here [...] These are the other policy options [...] Even though I cannot promise the users that all these options you are expressing here will be heard at the decision makers, what I can do is expose them to different policy options for a particular decision and tell them, these are the pros and cons for each of them, what's your choice?"

*Elena is currently working on an English profile of her project, which we'll publish when it's done.*

### Money, Media and Megalomania

Christina Lupu, from the Centre for Independent Journalism described the reason that she currently needs access to information about how the government spends its money: to ensure the media does not become reliant on state support. Christina is working on a project to see how money from the public budget is spent on advertising... :

> "[I]n a lot of the cases the authorities, the local government, uses money from the local budget buying advertising in the media companies. It is a crisis period. The state in Romania is one of the most important investors in the media, buying advertising from public money; they buy advertising and they say, "OK,you are not allowed to write bad things about me because I will cut the budgets", [...] we had cases that it was written that "you are not allowed to write bad things about me". But now it is something that you know. [The agreement is] 'I will not write it in the contract that you have to write good things about me, that you have to come to my events and present them as the most interesting in the world, but if you don't do that, I will go to the competition...' So the media is powerless with regard to how the money is spent."

### Bribe Market - Combatting Corruption

Petty corruption, isn't 'fiscal data' in the pure sense. However, if getting access to basic services requires money to be handed over regularly enough, it becomes almost like an unofficial tax.  I listened to Codru Vrabie on his project *[Bribe Market](http://www.piatadespaga.ro/)* (not yet launched) -treating petty corruption as such in an attempt to tackle it:

> "[W]e looked at bribery as in a sense, a legitimate transaction and tried to see, from a supply and demand perspective how can you tackle that, so we thought, "OK, what if we put together a platform which will help people learn what's the actual rate, so open up the prices, and hopefully also get an indication with smiley faces or a star system as to how satisfied they were as to the services they got?", so you open up information about the quality of service as well. [...] So it's wishful thinking based on economic theory but who knows, maybe in a few years or so, maybe we'll actually get to see results either in the sense that prices of bribes will drop significantly [...] or we will see that corrupt public servants will form a kind of cartel and fix prices at a specific rate, but then if people continue to pay that price that means that that is a legitimate tax for getting that specific service, so what we can do then is go to Parliament and advocate that that specific tax is included as a legal price for that particular service. And then no-one will have any incentive to pay a bribe, because they legally pay a tax."

I asked Codru whether he had looked at other bribe spot sites such as [I Paid A Bribe](http://www.ipaidabribe.com/) or [BribeSpot](http://bribespot.com/) - he explained that to some extent, he had modelled his site on Bribespot, but there was one key philosophical difference - Bribemarket is also about user satisfaction with services, their *value for money*, in a sense. Users will be provided with a feedback form, where they can write about how happy they are with a given product or service. Two birds with one stone - tackling petty corruption and (hopefully) improving service delivery...

*We will follow up with Codru to get a full profile of the project when it is launched in the autumn...*

A slight digression, but while we're on the note of corruption, there were some very interesting examples floating around of how Government technology had been successfully used in Romania to counter corruption, for example, in the passport service. According to the group, where before the slow wheels of the passport system may often have been greased to accelerate the lengthy process of getting your documents, the new digitised passport service cuts out many middlemen, and is faster, so it is almost impossible to pay bribes.

### Getting the data - what's it like in Romania?

How do you get data in Romania? How are they finding Freedom of Information laws working out in practice? Would it be helpful to have a portal such as "[What Do They Know?](http://www.whatdotheyknow.com/)" or "[Ask the EU?](http://www.asktheeu.org/)" in Romania?

> *Andra Bucur*: I usually make information requests and send them to the specific authorities but normally I don't get an answer in 10 days, which is the time specified in the law, sometimes you get in about 30 days but they should advise you beforehand if it takes a while to get your request processed... Usually in the extractive industries, we don't get an answer about the information we want [...] so then we use strategic litigation in order to get the information. [...] We send it by fax, I never sent it electronically. There are institutions that don't even have their contacts on the website. Like the National Agency for Mineral Resources, they don't have budgets online, they don't have public acquisitions online, you can click on everything you want but it doesn't work, they don't have contacts online, so the only way to send a request is to actually send it by post or to go to the institution, it depends on the agency. [...]

> *Cristina Lupu*: You may submit your requests online, but the problem is if you do that, you can't prove that they received the email. And this is one of the excuses that they use. If you go to the registration office and they put the date and the stamp you are sure that they received the information [...]

This obviously gets a raised eyebrow from me - rubber stamp syndrome strikes again... We don't come to a consensus on whether the portal would be useful in the end, but we've had a jolly good debate in the meantime...

The age-old ugly beast of data formats (PDFs) also rears its head again, but not just PDFs - nightmare PDFs:

> *Codru Vrabie*: The ones I like [this is presumably sarcastic] best are the PDFs that is locked that was actually distilled from a JPG that is actually a copy, tilted like that [gestures], of a third hand fax, so all the letters are smudged and effaced...

Someday soon, I hope this problem will no longer be an issue, but there needs to be a serious mentality change in government and there need to be more CSOs, such as these, keeping the pressure on to ensure the message gets through...

#### So what data do they want?

The group have actually put together a list already of key datasets, when they were consulted about how Romania should approach the Open Government Partnership, they promise to translate and send it on to me. Until the full list is ready, here's a quick overview of some of the things they ask for:

> *Codru Vrabie*: **Public Institutions - Activity reports.** "For instance the General Authorities Office, the public prosecution. When they published their report a couple of years ago they said there's [X] million criminal cases being tried every year. This is a piece of information which you will find in the annual activity report, it should be referenced to a database. And so, what I'm saying is, for all the information you put in your activity report, give me the attachment, so to say...in an open format."

> *Elena Calistru*: **Machine-readable budgets - "both at central level and at the local level"** - There are some core datasets which need to be there, which are already in place at least at a central level. [...] at the level of Ministry of Finance, sure you have the budget in a machine readable format, but you're not putting it on your website in a website in an open format, which is silly, you could do this without any effort, you can do it without any costs... and so on, so this is very important to start because it's very, very easy. It's the same with the datasets from the National Institute of Statistics."

<div class="well homework"> TOP TIP: Looking for statistics on Romania? You may well be able to find many of the datasets which the Romanian National Institute of Statistics charges for, for free on <a href="http://epp.eurostat.ec.europa.eu/portal/page/portal/eurostat/home/">Eurostat</a>.</div>

> *Elena Calistru*: "**Statistical indicators which are of use for the business sector**, deciding where to invest, what to focus on and so on..."

> *Codru Vrabie*: **Public Procurement Data**  "This is a question you should take to Slovakia - I think they have now 3 different portals from [Fair-Play Alliance](http://www.fair-play.sk/index.php) and [Transparency International in Slovakia](http://www.transparency.sk/) that relate to the public contracts and the interface between business sector and the public sector from various perspectives. And the question would be 'to what extent they have seen an increased interest from the business sector to ask these kind of questions or to ask for this type of information now that they can actually see what information is out there and how it can be used.'"

I will put this to both groups when I meet them in Bratislava... The above point is seconded by Bogdan Manolea, who talks about how useful steps forward in e-procurement had previously been made when the data used to be published as a feed. Bogdan says he knew someone planning to make a business out of that data, rehashing it and selling it on, but then came the CAPTCHA codes which made automatic harvest impossible...

> *Elena Calistru*: "**Datasets related to party financing**" Another feature of Bani Pierduti is that we make analyses. I'm now working on an analysis of party finance during the last election campaign. And sure, I checked the dataset available [...] I also made some requests for information from the Parliamentary Parties, but besides that, I took a camera [... and] took pictures of all the banners and so on, and afterwards sent a request for some prices from 3 companies offering outdoor media. The differences are at least significant. [...] the electoral financing laws says that no party can receive discounts or preferential rates for something, because that is considered a donation and they have to declare all the donations. And if one party will yell me "yeah, I got a discount" - why didn't you declare it?

## Civil Society Collaboration

My favourite part of the whole day is when the group start talking about how they might be able to help each other out by sharing the data that they each have added value to in some way. I ask: *"Do any of your projects archive the data so that it is available to the public for many years to come?"*. These are the responses we get:

<iframe src="http://player.vimeo.com/video/46076299" width="500" height="281" frameborder="0" webkitAllowFullScreen mozallowfullscreen allowFullScreen></iframe> <p><a href="http://vimeo.com/46076299">Romania - Civil Society Collaboration</a> from <a href="http://vimeo.com/okf">Open Knowledge Foundation</a> on <a href="http://vimeo.com">Vimeo</a>.</p>

(*NOTE: The Soros Foundation reports are already online, not in open formats, but a little bird tells me it is something that is being considered for future*.)

Safe to say, I think it would be a great start if more Civil Society Organisations shared data between themselves as well.

## More to come

This is just a tiny sample of a great and rich debate, I haven't even touched on here the views of the group on whether social media is a hindrance or a help for their work, other interesting methods employed to get  participation, both from active citizens and governments in the decision-making process.
