---
authors:
- lucy
redirect_from: /2012/07/Greece-2/
title: Athens to Berlin - Chicken or the Egg? Days 2-4 (Athens and Thessaloniki)
---

Immediately after landing in Greece, I have my first experience of where austerity cuts were hitting services. While attempting to buy tickets for the metro, I struck up conversation with an irate but lovely lady named Tina, who was irritated to have to travel all the way into central Athens by metro just to travel out again on another line to get home, a journey she would normally do via the suburban railway, which wasn't running, meaning the journey would take twice as long. *"Cuts!"* she told me in a mock-angry voice.

One of the things I found quite bizarre in Greece is that many people seemed to be able to put a date on a lot of the public works which had taken place:

> "Sorry about the pavements here, the last time they renovated them was 2004."

2004, came up a lot and it was only later that I realised that that was the last time that Greece hosted the Olympics; I suspect in 10 years I will be saying similar things about London...

All of this gets me thinking about whether transparency has anything to offer in terms of mitigating the effects of the cuts, if people could see why and where the money was disappearing from services, would it help to make the unpopular decisions faced by policy makers less difficult?

## Chicken or the Egg - where are the budget advocacy groups?

As I mentioned in my announce post, I've not come across *any* budget advocacy groups in Greece. I ask everyone I meet, but no-one can point me to any... I eventually come across [Greece Debt Free](http://www.greecedebtfree.org/), a crowdfunding project to volunteer away Greece's debt, but by that point I am already leaving, so I make a note to get in contact ... I start to wonder whether this is because before Diavgeia, information on public spending simply was not available and so the work was not possible, but was there genuinely no-one campaigning for the information to be released? What comes first? Budget advocacy groups or budgets?

On the off-chance that they knew anyone working in this area, I dropped a line to the local Transparency International group. While they also did not focus on the issue, they put me in touch with a lone-ranger, one of their lawyers, Effie Vraniali, who studied the Greek Public Financial Management System as part of her PhD, comparing it to other countries. Below are some of her thoughts.

Highlights:

* Not only absence of the data, but finding out who was responsible for what within government was an issue,
* Even the Greek Parliament themselves struggled to get hold of the information they required,
* Information in Diavgeia was quite scattered and thus unusable unless you had the time to search for everything you wanted

<iframe src="http://player.vimeo.com/video/45818263" width="500" height="375" frameborder="0" webkitAllowFullScreen mozallowfullscreen allowFullScreen></iframe> <p><a href="http://vimeo.com/45818263">Effie Vraniali - How Greece manages its money</a> from <a href="http://vimeo.com/okf">Open Knowledge Foundation</a> on <a href="http://vimeo.com">Vimeo</a>.</p>

Last but not least, Effie mentions that she would *love* to do more work to measure the openness financial information in Greece, but she can't do it alone, she needs a team. Effie is now part of the [Working Group on Open Spending Data](http://openspending.org/resources/wg/index.html), so if you are likewise looking to work in this area in Greece, please [get in touch via the mailing list](http://lists.okfn.org/mailman/listinfo/openspending).

## Diavgeia's Dodgy Data?

Everyone who I speak to is full of praise for what the Greek government are doing with Diavgeia, although all have comments on how it could be done better!

While I'm still in Athens, I meet up with [Thodoris Papadopoulos](http://thodoris.net/weblog/archive/2012/02/29/?p=176), who wrote a paper at the National School of Public Administration on the pros and cons of the Diavgeia system, which he promises to translate selections of and send me. I also meet [Ioannis Anagnostopoulos](http://www.anagnostopoulos.name/) from the Athens team of the cross-university collaboration team [PublicSpending.gr](http://publicspending.medialab.ntua.gr/) who shares his experiences on how easy it was to use Diavgeia to build their research platform.

In my next post, I'll urge journalists, researchers etc to have a look at Diavgeia's data, but before I do, here's a couple of things they flagged up to be wary of...

### How is data born?

The manner in which data is generated affects how it can be used, here are the thoughts I collected from Thodoris, Ioannis and others...

* **Data is uploaded in various formats, often PDFs**. When I was in the e-governance office of Neo Iraklio Attikis, I was given a demonstration of how the data was uploaded to Diavgeia, it took quite a while to locate and upload individual PDFs to the form they were supposed to support. In the back of my mind, I keep thinking to myself, "Why do people like rubber stamps so much?", surely there is a quicker way than this? As has already been pointed out, this also makes it very difficult to search across all of the data in the site at once.
* **A couple of the most important fields in the civil servants' form used to be free text, and not mandatory.** e.g. Some people may have used "." instead of commas, some may use the word "Euro" rather than the sign "€".  It was fixed after repeated notices from developers. (Go civic-minded-developers!)
* **Information in the *amount* field is stored as text, rather than as numbers.** A deeper complication of the problem above.

This is particularly problematic when combined with another procedural problem. There are 3 stages to making any official purchase:

1. A document has to be signed to show the expense has been accepted (like a purchase order)
2. There has to be a decision to actually pay the money e.g. upon satisfactory completion of a task
3. There is the actual payment or transaction

According to Thodoris, this field is often entered incorrectly and is not mandatory, so it is often impossible to know whether the information you are looking at is a purchase order or the actual transaction. This could cause big problems down the line, not just for CSO budget monitors, but also within government...

* **The system does not use international standards such as COFOG to classify the information.** This seems to be a recurring theme. For example, if you are interested in a question such as 'how much does the government spend on mobile phones?' it is impossible to find out.Someone buying a mobile phone for the ministry of finance will register it with one code - for another ministry, it will be recorded against another code.
* **A lot of errors.** Diavgeia does not have a validation service. PublicSpending.gr seeks to track down these errors and correct them by validating them against another service, [taxisnet](http://www.gsis.gr/). Ioannis says that 70% of the effort behind PublicSpending.gr is taken up with data cleansing, rather than producing visualisations etc.
* **Missing information.** All of my interviewees were skeptical that *all* information which is meant to actually made it into Diavgeia. Some even had personal anecdotes to prove it didn't. The following quote is from a scientist at the local university, George:

> "My own experience of Diavgeia. I was giving some lectures in a university for a small amount of money, €60 /hour or something like that.

>After 2 months they called me back to sign again the contract to say that I was happy for them to publish this information in Diavgeia. After 2 months I discovered through a variety of things that the information had not been added to Diavgeia."

## On to Thessaloniki

It may take a group of techies to do it, but all is not lost... my next stop is to meet the WebScience Master Programme at the University of Thessaloniki [Read the profile of the programme](http://openspending.org/blog/2012/07/16/Greece-3.html).
