---
authors:
- lucy
redirect_from: /2012/07/OSI/
title: Athens to Berlin - a European Financial Profile
---

**How does the work of budget monitoring organisations, investigative journalists, academic researchers and think-tanks differ in the various countries of Europe? What are the key questions these organisations address - are they largely the same in every country, or does each country have a different issue at the forefront of their minds? What tools and techniques do they have at their disposal to get to the bottom of Europe's tricky financial situations?**

<img alt="" src="http://farm7.staticflickr.com/6032/6309941378_b0a365ce28.jpg" title="Euro" class="alignnone" width="640" height="480" />

A few months back, [we wrote about our project to map out how Civil Society Organisations around the world use technology in their work](http://openspending.org/blog/2012/01/12/civil-society-and-spending-data-who-is-mapping-the-money.html). Having identified in the first phase numerous interesting organisations working in this area, we now move on to phase two, getting down to the questions of tools, methodologies and barriers. A couple of the questions we will be looking at can be found below:

* How government financial information relates to the mission of CSOs, what questions are they trying to answer? 
* What are the high-value datasets? Besides the eight key budget documents that every government should produce, as highlighted by the International Budget Partnership, which datasets should we be asking that governments of every country in the world to release?
* How do CSOs get hold of the data? Formats, channels & procedures. 
* How do they ensure the sustainability of their efforts? What happens if the person who has been working with the data leaves? Do they document their processes? 
* What tools are used to work with, archive, share and to spread the word about any findings?
* Anywhere else the conversation logically takes us... 

Considering Europe's current financial situation and the Euro crisis, my focus for this current section is a cross-section of Europe - from Greece to Germany. These two countries stand at either end of the debate on proposed austerity measures for the Euro Zone, but are they actually poles apart in terms of challenges they face in monitoring their budgeting priorities at a grass-roots level? or are there common issues which could be solved with a technical helping hand?

So, armed with a video camera, sunscreen and an InterRail ticket, I am departing today to find some of the answers to these questions and will visit Greece, Romania, Hungary, Slovakia and (possibly) Czech Republic collecting opinions on what it is like to be working with government financial data across Europe... 

This chain will be completed in the autumn with a trip to Germany, to whom most of Europe is currently looking for hopes of salvation of the common currency.

## First Stop - Athens

The first thing that I should note about my journey to Greece is that, unlike the other countries I intend to visit, I have been, as yet, unable to find a Civil Society Organisation which specifically dedicates its effort to monitoring government budgets, contracts and procurement. Any hints welcomed if such an organisation exists, please do put them in touch!ß

However, I will meet the team behind **Diavgeia** - the Government "Cl@rity" programme, to talk about the up and coming project **"AGORA"**, which deals with transparency in the cost of supplies to the Greek Public Administration  Nikolaos Stavropoulos, Maria Galaktopoulou (the Vice Mayor) and Photios Zygoulis. Secondly, Thodoris Papadopoulos, a member of the OpenSpending community and graduate of the **National School Of Public Administration**, who has run up against problems in using Greek data has promised to share his thoughts on what could be done better in Greece. Finally I will meet the team of **Transparency International - Greece**, in particular, Ms Effie Vraniali, a lawyer and a PhD holder in Public Financial Management, before moving on to Thessaloniki.

Our aims in this phase are threefold:

1. To work out what tips and tricks the various CSOs could learn from one another, to document them and put them together as a Spending Data Handbook.
2. To work out what tools are being used in budget and spending monitoring - are there any gaps which could easily be filled?
3. To connect the civil society organisations together, to ensure that ideas keep being exchanged.

## Stay in touch

Please do get in touch and let me know of any questions you would like me to put to the CSOs. The easiest way to stay in contact is via the [mailing list](http://lists.okfn.org/mailman/listinfo/openspending).

*Image credits: [quapan on Flickr](http://www.flickr.com/photos/hinkelstone/)*

