---
authors:
- lucy
redirect_from: /2012/06/upload-videos/
title: Video Instruction Guide - Loading Data Into OpenSpending
---

Recently, the OpenSpending team have been working on a project to visualise financial data in Cameroon. One of the aims of the project is to create a platform which is sustainable for years to come and that means that it needs to be really easy to load and maintain datasets into OpenSpending.

So... we've created some screencasts about how to load data into OpenSpending. Please do take a look and try it out for yourself and let us know if anything needs to be clearer!

Once you've got your data into the [OpenSpending data format](http://openspending.org/help/data-cleansing.html) you're ready to load. 


## Preparing your dataset information

First add information about your dataset to make it easily findable in OpenSpending

<iframe src="http://player.vimeo.com/video/45913394" width="500" height="375" frameborder="0" webkitAllowFullScreen mozallowfullscreen allowFullScreen></iframe> <p><a href="http://vimeo.com/45913394">OpenSpending Upload</a> from <a href="http://vimeo.com/okf">Open Knowledge Foundation</a> on <a href="http://vimeo.com">Vimeo</a>.</p>

## Upload your data online

Next, you need to get your CSV file online. There are numerous ways to do this, [Dropbox](https://www.dropbox.com/), exporting your data directly from a Google Docs (*File > Publish to the Web > Publish a CSV*). We've used the DataHub to publish our data. If you've never used it before here's a quick demo of how to upload a dataset. 

<iframe src="http://player.vimeo.com/video/45913395" width="500" height="375" frameborder="0" webkitAllowFullScreen mozallowfullscreen allowFullScreen></iframe> <p><a href="http://vimeo.com/45913395">DataHub upload</a> from <a href="http://vimeo.com/okf">Open Knowledge Foundation</a> on <a href="http://vimeo.com">Vimeo</a>.</p>

## Create a model to explain the structure of your data to OpenSpending

Next, tell OpenSpending how to understand your data by creating a model.

<iframe src="http://player.vimeo.com/video/45913393" width="500" height="375" frameborder="0" webkitAllowFullScreen mozallowfullscreen allowFullScreen></iframe> <p><a href="http://vimeo.com/45913393">OpenSpending - Create a Model</a> from <a href="http://vimeo.com/okf">Open Knowledge Foundation</a> on <a href="http://vimeo.com">Vimeo</a>.</p>

If that's all gone well, you'll be able to move on to creating visualisations (video coming soon - watch this space!) and if not and you have some errors watch the video below to see what to do next.

## Not quite right? How to fix errors...

It doesn't always go right the first time you try and load your data - here's what to do if you have made a mistake either in your model or your data.

<iframe src="http://player.vimeo.com/video/45913391" width="500" height="375" frameborder="0" webkitAllowFullScreen mozallowfullscreen allowFullScreen></iframe> <p><a href="http://vimeo.com/45913391">OpenSpending Error</a> from <a href="http://vimeo.com/okf">Open Knowledge Foundation</a> on <a href="http://vimeo.com">Vimeo</a>.</p>

Please let us know if you upload a new dataset and if you have any feedback. You can get in touch any time via the [mailing list](http://lists.okfn.org/mailman/listinfo/openspending).

